/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.net.DNS;
import org.kitesdk.minicluster.HdfsService;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.Service;
import org.kitesdk.minicluster.ZookeeperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(HBaseService.class);
    public static final String MASTER_PORT_KEY = "hbase-master-port";
    public static final String REGIONSERVER_PORT_KEY = "hbase-regionserver-port";
    private static final String HBASE_META_TABLE = "hbase:meta";
    private Configuration hadoopConf;
    private int zookeeperClientPort = 2828;
    private String bindIP = "127.0.0.1";
    private int masterPort = 60000;
    private int regionserverPort = 60020;
    private MiniHBaseCluster hbaseCluster;

    @Override
    public void configure(Service.ServiceConfig serviceConfig) {
        if (serviceConfig.contains("bind-ip")) {
            this.bindIP = serviceConfig.get("bind-ip");
        }
        if (serviceConfig.contains("zk-port")) {
            this.zookeeperClientPort = Integer.parseInt(serviceConfig.get("zk-port"));
        }
        if (serviceConfig.contains(MASTER_PORT_KEY)) {
            this.masterPort = Integer.parseInt(serviceConfig.get(MASTER_PORT_KEY));
        }
        if (serviceConfig.contains(REGIONSERVER_PORT_KEY)) {
            this.masterPort = Integer.parseInt(serviceConfig.get(REGIONSERVER_PORT_KEY));
        }
        this.hadoopConf = serviceConfig.getHadoopConf();
    }

    @Override
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    @Override
    public void start() throws IOException, InterruptedException {
        Preconditions.checkState((this.hadoopConf != null ? 1 : 0) != 0, (Object)"Hadoop Configuration must be set before starting mini HBase cluster");
        Preconditions.checkState((this.zookeeperClientPort != 0 ? 1 : 0) != 0, (Object)"The zookeeper client port must be configured to a non zero value");
        this.hbaseCluster = new MiniHBaseCluster(this.hadoopConf, 0, 0, null, null);
        this.hadoopConf = HBaseService.configureHBaseCluster(this.hbaseCluster.getConf(), this.zookeeperClientPort, FileSystem.get((Configuration)this.hadoopConf), this.bindIP, this.masterPort, this.regionserverPort);
        this.hbaseCluster.startMaster();
        this.hbaseCluster.startRegionServer();
        HBaseService.waitForHBaseToComeOnline(this.hbaseCluster);
        logger.info("HBase Minicluster Service Started.");
    }

    @Override
    public void stop() throws IOException {
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
            this.hbaseCluster.killAll();
            this.hbaseCluster.waitUntilShutDown();
            logger.info("HBase Minicluster Service Shut Down.");
            this.hbaseCluster = null;
        }
    }

    @Override
    public List<Class<? extends Service>> dependencies() {
        ArrayList<Class<? extends Service>> services = new ArrayList<Class<? extends Service>>();
        services.add(HdfsService.class);
        services.add(ZookeeperService.class);
        return services;
    }

    private static Configuration configureHBaseCluster(Configuration config, int zkClientPort, FileSystem hdfsFs, String bindIP, int masterPort, int regionserverPort) throws IOException {
        config.set("hbase.zookeeper.property.clientPort", Integer.toString(zkClientPort));
        Path hbaseDir = new Path(hdfsFs.makeQualified(hdfsFs.getHomeDirectory()), "hbase");
        FSUtils.setRootDir((Configuration)config, (Path)hbaseDir);
        hdfsFs.mkdirs(hbaseDir);
        config.set("fs.defaultFS", hdfsFs.getUri().toString());
        config.set("fs.default.name", hdfsFs.getUri().toString());
        FSUtils.setVersion((FileSystem)hdfsFs, (Path)hbaseDir);
        logger.info("HBase force binding to ip: " + bindIP);
        config.set("hbase.master.ipc.address", bindIP);
        config.set("hbase.master.port", Integer.toString(masterPort));
        config.set("hbase.regionserver.ipc.address", bindIP);
        config.set("hbase.regionserver.port", Integer.toString(regionserverPort));
        config.set("hbase.zookeeper.quorum", bindIP);
        try {
            Field cachedHostname = DNS.class.getDeclaredField("cachedHostname");
            cachedHostname.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(cachedHostname, cachedHostname.getModifiers() & 0xFFFFFFEF);
            cachedHostname.set(null, bindIP);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        config.set("hbase.master.info.port", "-1");
        config.set("hbase.regionserver.info.port", "-1");
        return config;
    }

    private static void waitForHBaseToComeOnline(MiniHBaseCluster hbaseCluster) throws IOException, InterruptedException {
        while (!hbaseCluster.getMaster().isInitialized()) {
            Thread.sleep(1000L);
        }
        hbaseCluster.getRegionServer(0).waitForServerOnline();
        HTable t = new HTable(hbaseCluster.getConf(), HBASE_META_TABLE);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        s.close();
        t.close();
    }

    static {
        MiniCluster.registerService(HBaseService.class);
    }
}

