/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.kite;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosUtil.class);

    public static UserGroupInformation proxyAs(String username, UserGroupInformation login) {
        Preconditions.checkArgument((username != null && !username.isEmpty() ? 1 : 0) != 0, (Object)("Invalid username: " + String.valueOf(username)));
        Preconditions.checkArgument((login != null ? 1 : 0) != 0, (Object)"Cannot proxy without an authenticated user");
        return UserGroupInformation.createProxyUser((String)username, (UserGroupInformation)login);
    }

    public static synchronized UserGroupInformation login(String principal, String keytab) {
        String finalPrincipal = null;
        if (principal != null && !principal.isEmpty()) {
            try {
                finalPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"");
            }
            catch (IOException e) {
                throw new SecurityException("Failed to resolve Kerberos principal", e);
            }
        }
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            LOG.debug("Unable to get login user before Kerberos auth attempt", (Throwable)e);
        }
        if (currentUser != null) {
            if (finalPrincipal == null || finalPrincipal.equals(currentUser.getUserName())) {
                LOG.debug("Using existing login for {}: {}", (Object)finalPrincipal, (Object)currentUser);
                return currentUser;
            }
            throw new SecurityException("Cannot use multiple Kerberos principals: " + finalPrincipal + " would replace " + currentUser.getUserName());
        }
        Preconditions.checkArgument((principal != null && !principal.isEmpty() ? 1 : 0) != 0, (Object)("Invalid Kerberos principal: " + String.valueOf(principal)));
        Preconditions.checkNotNull((Object)finalPrincipal, (Object)"Resolved principal must not be null");
        Preconditions.checkArgument((keytab != null && !keytab.isEmpty() ? 1 : 0) != 0, (Object)("Invalid Kerberos keytab: " + String.valueOf(keytab)));
        File keytabFile = new File(keytab);
        Preconditions.checkArgument((keytabFile.isFile() && keytabFile.canRead() ? 1 : 0) != 0, (Object)("Keytab is not a readable file: " + String.valueOf(keytab)));
        try {
            LOG.debug("Logging in as {} with {}", (Object)finalPrincipal, (Object)keytab);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            return UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new SecurityException("Kerberos login failed", e);
        }
    }

    public static <T> T runPrivileged(UserGroupInformation login, PrivilegedExceptionAction<T> action) {
        try {
            if (login == null) {
                return action.run();
            }
            return (T)login.doAs(action);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Privileged action failed", ex);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new DatasetException((Throwable)ex);
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public static class SecurityException
    extends RuntimeException {
        private SecurityException(String message) {
            super(message);
        }

        private SecurityException(String message, Throwable cause) {
            super(message, cause);
        }

        private SecurityException(Throwable cause) {
            super(cause);
        }
    }
}

