/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.shaded.com.google.common.collect.Lists;

public class PathIterator
implements Iterator<Path>,
Iterable<Path> {
    private final FileSystem fs;
    private final Path root;
    private final Iterator<StorageKey> partitions;
    private StorageKey key = null;
    private Iterator<Path> files = null;

    public PathIterator(FileSystem fs, Path root, @Nullable Iterator<StorageKey> partitions) {
        this.fs = fs;
        this.root = root;
        this.partitions = partitions;
    }

    @Override
    public boolean hasNext() {
        if (this.files != null && this.files.hasNext()) {
            return true;
        }
        return this.advance();
    }

    public StorageKey getStorageKey() {
        return this.key;
    }

    @Override
    public Path next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.files.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private boolean advance() {
        FileStatus[] stats;
        if (this.partitions == null) {
            if (this.files != null) {
                return false;
            }
            try {
                stats = this.fs.listStatus(this.root, PathFilters.notHidden());
            }
            catch (IOException ex) {
                throw new DatasetIOException("Cannot list files in " + this.root, ex);
            }
            this.key = null;
        } else if (this.partitions.hasNext()) {
            StorageKey key = this.partitions.next();
            try {
                stats = this.fs.listStatus(new Path(this.root, key.getPath()), PathFilters.notHidden());
            }
            catch (IOException ex) {
                throw new DatasetIOException("Cannot list files in " + key.getPath(), ex);
            }
            this.key = key;
        } else {
            return false;
        }
        ArrayList<Path> nextFileSet = Lists.newArrayListWithCapacity(stats.length);
        for (FileStatus stat : stats) {
            if (stat.isDir()) continue;
            nextFileSet.add(stat.getPath());
        }
        if (nextFileSet.size() > 0) {
            this.files = nextFileSet.iterator();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Path> iterator() {
        return this;
    }
}

