/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.PartitionView;
import org.kitesdk.data.Signalable;
import org.kitesdk.data.spi.AbstractDatasetWriter;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.InputFormatAccessor;
import org.kitesdk.data.spi.LastModifiedAccessor;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.SizeAccessor;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionIterator;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionView;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.filesystem.FileSystemViewKeyInputFormat;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.data.spi.filesystem.MultiFileDatasetReader;
import org.kitesdk.data.spi.filesystem.PartitionedDatasetWriter;
import org.kitesdk.data.spi.filesystem.PathIterator;
import org.kitesdk.data.spi.filesystem.SignalManager;
import org.kitesdk.shaded.com.google.common.base.Function;
import org.kitesdk.shaded.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
class FileSystemView<E>
extends AbstractRefinableView<E>
implements InputFormatAccessor<E>,
LastModifiedAccessor,
SizeAccessor,
Signalable<E> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemView.class);
    final FileSystem fs;
    final Path root;
    private final PartitionListener listener;
    private final SignalManager signalManager;

    FileSystemView(FileSystemDataset<E> dataset, @Nullable PartitionListener listener, @Nullable SignalManager signalManager, Class<E> type) {
        super(dataset, type);
        this.fs = dataset.getFileSystem();
        this.root = dataset.getDirectory();
        this.listener = listener;
        this.signalManager = signalManager;
    }

    FileSystemView(FileSystemView<E> view, Constraints c) {
        super(view, c);
        this.fs = view.fs;
        this.root = view.root;
        this.listener = view.listener;
        this.signalManager = view.signalManager;
    }

    private FileSystemView(FileSystemView<?> view, Schema schema, Class<E> type) {
        super(view, schema, type);
        this.fs = view.fs;
        this.root = view.root;
        this.listener = view.listener;
        this.signalManager = view.signalManager;
    }

    @Override
    protected FileSystemView<E> filter(Constraints c) {
        return new FileSystemView<E>(this, c);
    }

    @Override
    protected <T> AbstractRefinableView<T> project(Schema schema, Class<T> type) {
        return new FileSystemView<T>(this, schema, type);
    }

    @Override
    public DatasetReader<E> newReader() {
        this.checkSchemaForRead();
        MultiFileDatasetReader reader = new MultiFileDatasetReader(this.fs, this.pathIterator(), this.dataset.getDescriptor(), this.constraints, this.getAccessor());
        reader.initialize();
        return reader;
    }

    @Override
    public DatasetWriter<E> newWriter() {
        this.checkSchemaForWrite();
        AbstractDatasetWriter writer = this.dataset.getDescriptor().isPartitioned() ? PartitionedDatasetWriter.newWriter(this) : FileSystemWriter.newWriter(this.fs, this.root, this.dataset.getDescriptor());
        writer.initialize();
        return writer;
    }

    @Override
    public Iterable<PartitionView<E>> getCoveringPartitions() {
        final FileSystemDataset fsDataset = (FileSystemDataset)this.dataset;
        if (this.dataset.getDescriptor().isPartitioned()) {
            return new Iterable<PartitionView<E>>(){

                @Override
                public Iterator<PartitionView<E>> iterator() {
                    return Iterators.transform(FileSystemView.this.partitionIterator(), new Function<StorageKey, PartitionView<E>>(){

                        @Override
                        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="False positive, initialized above as non-null.")
                        public PartitionView<E> apply(@Nullable StorageKey key) {
                            return FileSystemPartitionView.getPartition(fsDataset.unbounded, key.getPath());
                        }
                    });
                }
            };
        }
        return new Iterable<PartitionView<E>>(){

            @Override
            public Iterator<PartitionView<E>> iterator() {
                return Iterators.singletonIterator(fsDataset.unbounded);
            }
        };
    }

    @Override
    public boolean deleteAll() {
        if (!this.constraints.alignedWithBoundaries()) {
            throw new UnsupportedOperationException("Cannot cleanly delete view: " + this);
        }
        return this.deleteAllUnsafe();
    }

    @Override
    public InputFormat<E, Void> getInputFormat(Configuration conf) {
        return new FileSystemViewKeyInputFormat(this, conf);
    }

    PathIterator pathIterator() {
        if (this.dataset.getDescriptor().isPartitioned()) {
            return new PathIterator(this.fs, this.root, this.partitionIterator());
        }
        return new PathIterator(this.fs, this.root, null);
    }

    Iterator<Path> dirIterator() {
        if (this.dataset.getDescriptor().isPartitioned()) {
            return Iterators.transform(this.partitionIterator(), new Function<StorageKey, Path>(){

                @Override
                @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="False positive, initialized above as non-null.")
                public Path apply(@Nullable StorageKey key) {
                    return new Path(FileSystemView.this.root, key.getPath());
                }
            });
        }
        return Iterators.singletonIterator(this.root);
    }

    private FileSystemPartitionIterator partitionIterator() {
        DatasetDescriptor descriptor = this.dataset.getDescriptor();
        try {
            return new FileSystemPartitionIterator(this.fs, this.root, descriptor.getPartitionStrategy(), descriptor.getSchema(), this.getKeyPredicate());
        }
        catch (IOException ex) {
            throw new DatasetException("Cannot list partitions in view:" + this, ex);
        }
    }

    boolean deleteAllUnsafe() {
        boolean deleted = false;
        if (this.dataset.getDescriptor().isPartitioned()) {
            for (StorageKey key : this.partitionIterator()) {
                boolean bl = deleted = FileSystemUtil.cleanlyDelete(this.fs, this.root, key.getPath()) || deleted;
                if (this.listener == null) continue;
                this.listener.partitionDeleted(this.dataset.getNamespace(), this.dataset.getName(), key.getPath().toString());
            }
        } else {
            for (Path path : this.pathIterator()) {
                deleted = FileSystemUtil.cleanlyDelete(this.fs, this.root, path) || deleted;
            }
        }
        return deleted;
    }

    @Override
    public long getSize() {
        long size = 0L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fs.listStatus(dir)) {
                    size += st.getLen();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find size of " + dir, e);
            }
        }
        return size;
    }

    @Override
    public long getLastModified() {
        long readyTimestamp;
        long lastMod = -1L;
        Iterator<Path> i = this.dirIterator();
        while (i.hasNext()) {
            Path dir = i.next();
            try {
                for (FileStatus st : this.fs.listStatus(dir)) {
                    if (lastMod >= st.getModificationTime()) continue;
                    lastMod = st.getModificationTime();
                }
            }
            catch (IOException e) {
                throw new DatasetIOException("Cannot find last modified time of of " + dir, e);
            }
        }
        if (this.signalManager != null && lastMod < (readyTimestamp = this.signalManager.getReadyTimestamp(this.getConstraints()))) {
            lastMod = readyTimestamp;
        }
        return lastMod;
    }

    @Override
    public void signalReady() {
        if (this.signalManager != null) {
            this.signalManager.signalReady(this.getConstraints());
        }
    }

    @Override
    public boolean isReady() {
        if (this.signalManager != null) {
            long readyTimestamp = this.signalManager.getReadyTimestamp(this.getConstraints());
            return readyTimestamp != -1L;
        }
        return false;
    }
}

