/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.net.URI;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.PartitionView;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.MarkerComparator;
import org.kitesdk.data.spi.SchemaValidationUtil;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.base.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractRefinableView<E>
implements RefinableView<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRefinableView.class);
    protected final Dataset<E> dataset;
    protected final MarkerComparator comparator;
    protected final Constraints constraints;
    protected final EntityAccessor<E> accessor;
    protected final Predicate<E> entityTest;
    protected final boolean canRead;
    protected final boolean canWrite;
    protected final ThreadLocal<StorageKey> keys;

    protected AbstractRefinableView(Dataset<E> dataset, Class<E> type) {
        this.dataset = dataset;
        final DatasetDescriptor descriptor = dataset.getDescriptor();
        if (descriptor.isPartitioned()) {
            this.constraints = new Constraints(descriptor.getSchema(), descriptor.getPartitionStrategy());
            this.comparator = new MarkerComparator(descriptor.getPartitionStrategy());
            this.keys = new ThreadLocal<StorageKey>(){

                @Override
                protected StorageKey initialValue() {
                    return new StorageKey(descriptor.getPartitionStrategy());
                }
            };
        } else {
            this.constraints = new Constraints(descriptor.getSchema());
            this.comparator = null;
            this.keys = null;
        }
        this.accessor = DataModelUtil.accessor(type, descriptor.getSchema());
        this.entityTest = this.constraints.toEntityPredicate(this.accessor);
        Schema datasetSchema = descriptor.getSchema();
        this.canRead = SchemaValidationUtil.canRead(datasetSchema, this.accessor.getReadSchema());
        this.canWrite = SchemaValidationUtil.canRead(this.accessor.getWriteSchema(), datasetSchema);
        IncompatibleSchemaException.check(this.canRead || this.canWrite, "The type cannot be used to read from or write to the dataset:\nType schema: %s\nDataset schema: %s", this.getSchema(), descriptor.getSchema());
    }

    protected AbstractRefinableView(AbstractRefinableView<?> view, Schema schema, Class<E> type) {
        this.dataset = view.dataset instanceof AbstractDataset ? ((AbstractDataset)view.dataset).asType((Class)type) : (Dataset)Datasets.load(view.dataset.getUri(), type);
        this.comparator = view.comparator;
        this.constraints = view.constraints;
        this.keys = view.keys;
        this.accessor = DataModelUtil.accessor(type, schema);
        this.entityTest = this.constraints.toEntityPredicate(this.accessor);
        Schema datasetSchema = this.dataset.getDescriptor().getSchema();
        this.canRead = SchemaValidationUtil.canRead(datasetSchema, this.accessor.getReadSchema());
        this.canWrite = SchemaValidationUtil.canRead(this.accessor.getWriteSchema(), datasetSchema);
        IncompatibleSchemaException.check(this.canRead || this.canWrite, "The type cannot be used to read from or write to the dataset:\nType schema: %s\nDataset schema: %s", this.getSchema(), datasetSchema);
    }

    protected AbstractRefinableView(AbstractRefinableView<E> view, Constraints constraints) {
        this.dataset = view.dataset;
        this.comparator = view.comparator;
        this.constraints = constraints;
        this.keys = view.keys;
        this.accessor = view.accessor;
        this.entityTest = constraints.toEntityPredicate(this.accessor);
        this.canRead = view.canRead;
        this.canWrite = view.canWrite;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    protected abstract AbstractRefinableView<E> filter(Constraints var1);

    protected abstract <T> AbstractRefinableView<T> project(Schema var1, Class<T> var2);

    @Override
    public Dataset<E> getDataset() {
        return this.dataset;
    }

    @Override
    public boolean deleteAll() {
        throw new UnsupportedOperationException("This Dataset does not support bulk deletion");
    }

    @Override
    public Class<E> getType() {
        return this.accessor.getType();
    }

    @Override
    public Schema getSchema() {
        return this.accessor.getReadSchema();
    }

    public EntityAccessor<E> getAccessor() {
        return this.accessor;
    }

    public Map<String, Object> getProvidedValues() {
        return this.constraints.getProvidedValues();
    }

    @Override
    public Iterable<PartitionView<E>> getCoveringPartitions() {
        throw new UnsupportedOperationException("This Dataset does not support getCoveringPartitions.");
    }

    @Override
    public boolean includes(E entity) {
        return this.entityTest.apply(entity);
    }

    @Override
    public AbstractRefinableView<E> with(String name, Object ... values) {
        return this.filter(this.constraints.with(name, values));
    }

    @Override
    public AbstractRefinableView<E> from(String name, Comparable value) {
        return this.filter(this.constraints.from(name, value));
    }

    @Override
    public AbstractRefinableView<E> fromAfter(String name, Comparable value) {
        return this.filter(this.constraints.fromAfter(name, value));
    }

    @Override
    public AbstractRefinableView<E> to(String name, Comparable value) {
        return this.filter(this.constraints.to(name, value));
    }

    @Override
    public AbstractRefinableView<E> toBefore(String name, Comparable value) {
        return this.filter(this.constraints.toBefore(name, value));
    }

    public AbstractRefinableView<GenericRecord> asSchema(Schema schema) {
        return this.project(schema, GenericRecord.class);
    }

    @Override
    public <T> View<T> asType(Class<T> type) {
        if (DataModelUtil.isGeneric(type)) {
            return this.project(this.getSchema(), type);
        }
        return this.project(this.getDataset().getDescriptor().getSchema(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        DatasetReader reader = null;
        try {
            reader = this.newReader();
            boolean bl = !reader.hasNext();
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Objects.equal(this.getClass(), o.getClass())) {
            return false;
        }
        AbstractRefinableView that = (AbstractRefinableView)o;
        return Objects.equal(this.dataset, that.dataset) && Objects.equal(this.constraints, that.constraints);
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass(), this.dataset, this.constraints);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("dataset", this.dataset).add("constraints", this.constraints).toString();
    }

    @Override
    public URI getUri() {
        URIBuilder builder = new URIBuilder(this.dataset.getUri());
        for (Map.Entry<String, String> entry : this.constraints.toQueryMap().entrySet()) {
            builder.with(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    protected Predicate<StorageKey> getKeyPredicate() {
        return this.constraints.toKeyPredicate();
    }

    protected void checkSchemaForWrite() {
        IncompatibleSchemaException.check(this.canWrite, "Cannot write data with this view's schema, it cannot be read with the dataset's schema:\nCurrent schema: %s\nDataset schema: %s", this.getSchema(), this.dataset.getDescriptor().getSchema());
    }

    protected void checkSchemaForRead() {
        IncompatibleSchemaException.check(this.canRead, "Cannot read data with this view's schema:\nCurrent schema: %s\nDataset schema: %s", this.dataset.getDescriptor().getSchema(), this.getSchema());
    }
}

