/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.spi.predicates.Exists;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.RegisteredPredicate;

public class TestRegisteredPredicateToFromString {
    private static final Schema SCHEMA = (Schema)SchemaBuilder.record((String)"Event").fields().requiredString("id").requiredLong("timestamp").requiredString("color").endRecord();
    private static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);

    @Test
    public void testExists() {
        Exists exists = Predicates.exists();
        Assert.assertEquals((Object)"", (Object)exists.toString(SCHEMA));
        Assert.assertEquals((Object)"exists()", (Object)RegisteredPredicate.toString((RegisteredPredicate)exists, (Schema)SCHEMA));
        Assert.assertEquals((Object)exists, (Object)RegisteredPredicate.fromString((String)"exists()", (Schema)SCHEMA));
    }

    public static Contains<String> contains(String contained) {
        return new Contains<String>(contained);
    }

    @Test
    public void testContains() {
        Contains<String> a = TestRegisteredPredicateToFromString.contains("a");
        Contains<String> b = TestRegisteredPredicateToFromString.contains("b");
        Assert.assertEquals((String)"Should wrap delegate toString in name function", (Object)"contains(a)", (Object)RegisteredPredicate.toString(a, (Schema)STRING));
        Assert.assertEquals((String)"Should wrap delegate toString in name function", (Object)"contains(b)", (Object)RegisteredPredicate.toString(b, (Schema)STRING));
        Assert.assertEquals((String)"Should produce equivalent contains(a)", a, (Object)RegisteredPredicate.fromString((String)"contains(a)", (Schema)STRING));
    }

    @Test
    public void testNormalizedNotOneOf() {
        NotOneOf notAorB = new NotOneOf(Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"b", "a"})));
        Assert.assertEquals((String)"Should wrap delegate toNormalizedString in name function", (Object)"notOneOf(a,b)", (Object)RegisteredPredicate.toNormalizedString(notAorB, (Schema)STRING));
    }

    public static class NotOneOf<T>
    extends RegisteredPredicate<T> {
        private final Set<String> restrictedValues;

        public NotOneOf(Set<String> restrictedValues) {
            this.restrictedValues = restrictedValues;
        }

        public String getName() {
            return "notOneOf";
        }

        public String toString(Schema schema) {
            return Joiner.on((char)',').join(this.restrictedValues);
        }

        public String toNormalizedString(Schema schema) {
            return Joiner.on((char)',').join((Iterable)Sets.newTreeSet(this.restrictedValues));
        }

        public boolean apply(@Nullable T value) {
            return value == null || !this.restrictedValues.contains(value.toString());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.restrictedValues});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            NotOneOf other = (NotOneOf)((Object)obj);
            return Objects.equal(this.restrictedValues, other.restrictedValues);
        }

        static {
            RegisteredPredicate.register((String)"notOneOf", (RegisteredPredicate.Factory)new RegisteredPredicate.Factory(){

                public <T> RegisteredPredicate<T> fromString(String predicate, Schema schema) {
                    Object[] values = predicate.split(",");
                    return new NotOneOf(Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])values)));
                }
            });
        }
    }

    public static class Contains<T>
    extends RegisteredPredicate<T> {
        private final String contained;

        public Contains(String contained) {
            this.contained = contained;
        }

        public String getName() {
            return "contains";
        }

        public String toString(Schema schema) {
            return this.contained;
        }

        public boolean apply(@Nullable T value) {
            return value != null && value.toString().contains(this.contained);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.contained});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Contains other = (Contains)((Object)obj);
            return Objects.equal((Object)this.contained, (Object)other.contained);
        }

        static {
            RegisteredPredicate.register((String)"contains", (RegisteredPredicate.Factory)new RegisteredPredicate.Factory(){

                public <T> RegisteredPredicate<T> fromString(String predicate, Schema schema) {
                    return new Contains(predicate);
                }
            });
        }
    }
}

