/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;

public class TestRangeToFromString {
    private static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);
    private static final Schema INT = Schema.create((Schema.Type)Schema.Type.INT);
    private static final Schema LONG = Schema.create((Schema.Type)Schema.Type.LONG);
    private static final Schema FLOAT = Schema.create((Schema.Type)Schema.Type.FLOAT);
    private static final Schema DOUBLE = Schema.create((Schema.Type)Schema.Type.DOUBLE);

    @Test
    public void testRangeBoundTypes() {
        Assert.assertEquals((String)"Should use [ and ]", (Object)"[3,4]", (Object)Ranges.closed((Object)3, (Object)4).toString(INT));
        Assert.assertEquals((String)"Should produce closed endpoints", (Object)Ranges.closed((Object)3, (Object)4), (Object)Range.fromString((String)"[3,4]", (Schema)INT));
        Assert.assertEquals((String)"Should use ( and )", (Object)"(5,9)", (Object)Ranges.open((Object)5, (Object)9).toString(INT));
        Assert.assertEquals((String)"Should produce open endpoints", (Object)Ranges.open((Object)5, (Object)9), (Object)Range.fromString((String)"(5,9)", (Schema)INT));
        Assert.assertEquals((String)"Should use [ and )", (Object)"[3,4)", (Object)Ranges.closedOpen((Object)3, (Object)4).toString(INT));
        Assert.assertEquals((String)"Should produce closed, open endpoints", (Object)Ranges.closedOpen((Object)3, (Object)4), (Object)Range.fromString((String)"[3,4)", (Schema)INT));
        Assert.assertEquals((String)"Should use ( and ]", (Object)"(5,9]", (Object)Ranges.openClosed((Object)5, (Object)9).toString(INT));
        Assert.assertEquals((String)"Should produce open, closed endpoints", (Object)Ranges.openClosed((Object)5, (Object)9), (Object)Range.fromString((String)"(5,9]", (Schema)INT));
    }

    @Test
    public void testStringRangeBoundTypes() {
        Assert.assertEquals((String)"Should use [ and ]", (Object)"[c,f]", (Object)Ranges.closed((Object)"c", (Object)"f").toString(STRING));
        Assert.assertEquals((String)"Should produce closed endpoints", (Object)Ranges.closed((Object)"c", (Object)"f"), (Object)Range.fromString((String)"[c,f]", (Schema)STRING));
        Assert.assertEquals((String)"Should use ( and )", (Object)"(m,p)", (Object)Ranges.open((Object)"m", (Object)"p").toString(STRING));
        Assert.assertEquals((String)"Should produce open endpoints", (Object)Ranges.open((Object)"m", (Object)"p"), (Object)Range.fromString((String)"(m,p)", (Schema)STRING));
        Assert.assertEquals((String)"Should use [ and )", (Object)"[c,f)", (Object)Ranges.closedOpen((Object)"c", (Object)"f").toString(STRING));
        Assert.assertEquals((String)"Should produce closed, open endpoints", (Object)Ranges.closedOpen((Object)"c", (Object)"f"), (Object)Range.fromString((String)"[c,f)", (Schema)STRING));
        Assert.assertEquals((String)"Should use ( and ]", (Object)"(m,p]", (Object)Ranges.openClosed((Object)"m", (Object)"p").toString(STRING));
        Assert.assertEquals((String)"Should produce open, closed endpoints", (Object)Ranges.openClosed((Object)"m", (Object)"p"), (Object)Range.fromString((String)"(m,p]", (Schema)STRING));
    }

    @Test
    public void testRangeUnboundedTypes() {
        Assert.assertEquals((String)"Should use [ and inf)", (Object)"[3,)", (Object)Ranges.atLeast((Object)3).toString(INT));
        Assert.assertEquals((String)"Should parse inf) correctly", (Object)Ranges.atLeast((Object)3), (Object)Range.fromString((String)"[3,)", (Schema)INT));
        Assert.assertEquals((String)"Should use ( and inf)", (Object)"(5,)", (Object)Ranges.greaterThan((Object)5).toString(INT));
        Assert.assertEquals((String)"Should parse inf) correctly", (Object)Ranges.greaterThan((Object)5), (Object)Range.fromString((String)"(5,)", (Schema)INT));
        Assert.assertEquals((String)"Should use (inf and )", (Object)"(,4)", (Object)Ranges.lessThan((Object)4).toString(INT));
        Assert.assertEquals((String)"Should parse (inf correctly", (Object)Ranges.lessThan((Object)4), (Object)Range.fromString((String)"(,4)", (Schema)INT));
        Assert.assertEquals((String)"Should use (inf and ]", (Object)"(,9]", (Object)Ranges.atMost((Object)9).toString(INT));
        Assert.assertEquals((String)"Should parse (inf correctly", (Object)Ranges.atMost((Object)9), (Object)Range.fromString((String)"(,9]", (Schema)INT));
        Assert.assertEquals((String)"Should parse inf] as inf)", (Object)Ranges.atLeast((Object)3), (Object)Range.fromString((String)"[3,]", (Schema)INT));
        Assert.assertEquals((String)"Should parse [inf as (inf", (Object)Ranges.atMost((Object)9), (Object)Range.fromString((String)"[,9]", (Schema)INT));
    }

    @Test
    public void testStringRangeUnboundedTypes() {
        Assert.assertEquals((String)"Should use [ and inf)", (Object)"[c,)", (Object)Ranges.atLeast((Object)"c").toString(STRING));
        Assert.assertEquals((String)"Should parse inf) correctly", (Object)Ranges.atLeast((Object)"c"), (Object)Range.fromString((String)"[c,)", (Schema)STRING));
        Assert.assertEquals((String)"Should use ( and inf)", (Object)"(m,)", (Object)Ranges.greaterThan((Object)"m").toString(STRING));
        Assert.assertEquals((String)"Should parse inf) correctly", (Object)Ranges.greaterThan((Object)"m"), (Object)Range.fromString((String)"(m,)", (Schema)STRING));
        Assert.assertEquals((String)"Should use (inf and )", (Object)"(,f)", (Object)Ranges.lessThan((Object)"f").toString(STRING));
        Assert.assertEquals((String)"Should parse (inf correctly", (Object)Ranges.lessThan((Object)"f"), (Object)Range.fromString((String)"(,f)", (Schema)STRING));
        Assert.assertEquals((String)"Should use (inf and ]", (Object)"(,p]", (Object)Ranges.atMost((Object)"p").toString(STRING));
        Assert.assertEquals((String)"Should parse (inf correctly", (Object)Ranges.atMost((Object)"p"), (Object)Range.fromString((String)"(,p]", (Schema)STRING));
        Assert.assertEquals((String)"Should parse inf] as inf)", (Object)Ranges.atLeast((Object)"c"), (Object)Range.fromString((String)"[c,]", (Schema)STRING));
        Assert.assertEquals((String)"Should parse [inf as (inf", (Object)Ranges.atMost((Object)"p"), (Object)Range.fromString((String)"[,p]", (Schema)STRING));
    }

    @Test
    public void testStringRanges() {
        Assert.assertEquals((String)"Range<Utf8>#toString(STRING)", (Object)"[t,z)", (Object)Ranges.closedOpen((Object)new Utf8("t"), (Object)new Utf8("z")).toString(STRING));
        Assert.assertEquals((String)"Range#toString(STRING)", (Object)"[t,z)", (Object)Ranges.closedOpen((Object)"t", (Object)"z").toString(STRING));
        Assert.assertEquals((String)"Range.fromString(String, STRING)", (Object)Ranges.closedOpen((Object)"t", (Object)"z"), (Object)Range.fromString((String)"[t,z)", (Schema)STRING));
    }

    @Test
    public void testIntegerRanges() {
        Assert.assertEquals((String)"Range#toString(INT)", (Object)"[1,7)", (Object)Ranges.closedOpen((Object)1, (Object)7).toString(INT));
        Assert.assertEquals((String)"Range.fromString(String, INT)", (Object)Ranges.closedOpen((Object)1, (Object)7), (Object)Range.fromString((String)"[1,7)", (Schema)INT));
    }

    @Test
    public void testLongRanges() {
        Assert.assertEquals((String)"Range#toString(LONG)", (Object)"[1,7)", (Object)Ranges.closedOpen((Object)1L, (Object)7L).toString(LONG));
        Assert.assertEquals((String)"Range.fromString(String, LONG)", (Object)Ranges.closedOpen((Object)1L, (Object)7L), (Object)Range.fromString((String)"[1,7)", (Schema)LONG));
    }

    @Test
    public void testFloatRanges() {
        Assert.assertEquals((String)"Range#toString(FLOAT)", (Object)"[1.4,7.1)", (Object)Ranges.closedOpen((Object)Float.valueOf(1.4f), (Object)Float.valueOf(7.1f)).toString(FLOAT));
        Assert.assertEquals((String)"Range.fromString(String, FLOAT)", (Object)Ranges.closedOpen((Object)Float.valueOf(1.4f), (Object)Float.valueOf(7.1f)), (Object)Range.fromString((String)"[1.4,7.1)", (Schema)FLOAT));
    }

    @Test
    public void testDoubleRanges() {
        Assert.assertEquals((String)"Range#toString(DOUBLE)", (Object)"[1.4,7.1)", (Object)Ranges.closedOpen((Object)1.4, (Object)7.1).toString(DOUBLE));
        Assert.assertEquals((String)"Range.fromString(String, DOUBLE)", (Object)Ranges.closedOpen((Object)1.4, (Object)7.1), (Object)Range.fromString((String)"[1.4,7.1)", (Schema)DOUBLE));
    }
}

