/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.predicates;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;

public class TestInToFromString {
    private static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);
    private static final Schema BOOL = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    private static final Schema INT = Schema.create((Schema.Type)Schema.Type.INT);
    private static final Schema LONG = Schema.create((Schema.Type)Schema.Type.LONG);
    private static final Schema FLOAT = Schema.create((Schema.Type)Schema.Type.FLOAT);
    private static final Schema DOUBLE = Schema.create((Schema.Type)Schema.Type.DOUBLE);
    private static final Schema BYTES = Schema.create((Schema.Type)Schema.Type.BYTES);
    private static final Schema ARRAY = Schema.createArray((Schema)INT);

    @Test
    public void testSingleEmptyStringValue() {
        Assert.assertEquals((String)"In<Utf8>#toString(STRING) (empty)", (Object)"", (Object)Predicates.in((Object[])new Utf8[]{new Utf8("")}).toString(STRING));
        Assert.assertEquals((String)"In#toString(STRING) (empty)", (Object)"", (Object)Predicates.in((Object[])new String[]{""}).toString(STRING));
        Assert.assertEquals((String)"In.fromString(String, STRING) (empty)", (Object)Predicates.in((Object[])new String[]{""}), (Object)In.fromString((String)"", (Schema)STRING));
    }

    @Test
    public void testSingleStringValue() {
        Assert.assertEquals((String)"In<Utf8>#toString(STRING)", (Object)"a", (Object)Predicates.in((Object[])new Utf8[]{new Utf8("a")}).toString(STRING));
        Assert.assertEquals((String)"In#toString(STRING)", (Object)"a", (Object)Predicates.in((Object[])new String[]{"a"}).toString(STRING));
        Assert.assertEquals((String)"In.fromString(String, STRING)", (Object)Predicates.in((Object[])new String[]{"a"}), (Object)In.fromString((String)"a", (Schema)STRING));
    }

    @Test
    public void testSingleStringValueUrlEncoded() {
        Assert.assertEquals((String)"In<Utf8>#toString(STRING)", (Object)"a%2Cb", (Object)Predicates.in((Object[])new Utf8[]{new Utf8("a,b")}).toString(STRING));
        Assert.assertEquals((String)"In.fromString(String, STRING)", (Object)Predicates.in((Object[])new String[]{"a,b"}), (Object)In.fromString((String)"a%2Cb", (Schema)STRING));
    }

    @Test
    public void testMultipleStringValues() {
        Assert.assertEquals((String)"In<Utf8>#toString(STRING)", (Object)"a,b,c", (Object)Predicates.in((Object[])new Utf8[]{new Utf8("a"), new Utf8("b"), new Utf8("c")}).toString(STRING));
        Assert.assertEquals((String)"In#toString(STRING)", (Object)"a,b,c", (Object)Predicates.in((Object[])new String[]{"a", "b", "c"}).toString(STRING));
        Assert.assertEquals((String)"In.fromString(String, STRING)", (Object)Predicates.in((Object[])new String[]{"a", "b", "c"}), (Object)In.fromString((String)"a,b,c", (Schema)STRING));
    }

    @Test
    public void testMultipleStringValuesWithEmpty() {
        Assert.assertEquals((String)"In<Utf8>#toString(STRING)", (Object)"a,b,", (Object)Predicates.in((Object[])new Utf8[]{new Utf8("a"), new Utf8("b"), new Utf8("")}).toString(STRING));
        Assert.assertEquals((String)"In#toString(STRING)", (Object)"a,b,", (Object)Predicates.in((Object[])new String[]{"a", "b", ""}).toString(STRING));
        Assert.assertEquals((String)"In.fromString(String, STRING)", (Object)Predicates.in((Object[])new String[]{"a", "b", ""}), (Object)In.fromString((String)"a,b,", (Schema)STRING));
    }

    @Test
    public void testMultipleStringValuesNormalized() {
        Assert.assertEquals((String)"In<Utf8>#toNormalizedString(STRING)", (Object)"ab,al,m,z", (Object)Predicates.in((Object[])new Utf8[]{new Utf8("z"), new Utf8("al"), new Utf8("ab"), new Utf8("m")}).toNormalizedString(STRING));
        Assert.assertEquals((String)"In#toNormalizedString(STRING)", (Object)"ab,al,m,z", (Object)Predicates.in((Object[])new String[]{"z", "al", "ab", "m"}).toNormalizedString(STRING));
    }

    @Test
    public void testSingleBooleanValue() {
        Assert.assertEquals((String)"In#toString(BOOL)", (Object)"false", (Object)Predicates.in((Object[])new Boolean[]{false, false}).toString(BOOL));
        Assert.assertEquals((String)"In.fromString(String, BOOL)", (Object)Predicates.in((Object[])new Boolean[]{false}), (Object)In.fromString((String)"34", (Schema)BOOL));
    }

    @Test
    public void testMultipleBooleanValues() {
        Assert.assertEquals((String)"In#toString(BOOL)", (Object)"false,true", (Object)Predicates.in((Object[])new Boolean[]{false, true}).toString(BOOL));
        Assert.assertEquals((String)"In.fromString(String, BOOL)", (Object)Predicates.in((Object[])new Boolean[]{false, true}), (Object)In.fromString((String)"false,true", (Schema)BOOL));
    }

    @Test
    public void testSingleIntegerValue() {
        Assert.assertEquals((String)"In#toString(INT)", (Object)"34", (Object)Predicates.in((Object[])new Integer[]{34}).toString(INT));
        Assert.assertEquals((String)"In.fromString(String, INT)", (Object)Predicates.in((Object[])new Integer[]{34}), (Object)In.fromString((String)"34", (Schema)INT));
    }

    @Test
    public void testMultipleIntegerValues() {
        Assert.assertEquals((String)"In#toString(INT)", (Object)"3,4,5", (Object)Predicates.in((Object[])new Integer[]{3, 4, 5}).toString(INT));
        Assert.assertEquals((String)"In.fromString(String, INT)", (Object)Predicates.in((Object[])new Integer[]{3, 4, 5}), (Object)In.fromString((String)"3,4,5", (Schema)INT));
    }

    @Test
    public void testMultipleIntegerValuesNormalized() {
        Assert.assertEquals((String)"In#toString(INT)", (Object)"123,45", (Object)Predicates.in((Object[])new Integer[]{45, 123}).toNormalizedString(INT));
    }

    @Test
    public void testSingleLongValue() {
        Assert.assertEquals((String)"In#toString(LONG)", (Object)"34", (Object)Predicates.in((Object[])new Long[]{34L}).toString(LONG));
        Assert.assertEquals((String)"In.fromString(String, LONG)", (Object)Predicates.in((Object[])new Long[]{34L}), (Object)In.fromString((String)"34", (Schema)LONG));
    }

    @Test
    public void testMultipleLongValues() {
        Assert.assertEquals((String)"In#toString(LONG)", (Object)"3,4,5", (Object)Predicates.in((Object[])new Long[]{3L, 4L, 5L}).toString(LONG));
        Assert.assertEquals((String)"In.fromString(String, LONG)", (Object)Predicates.in((Object[])new Long[]{3L, 4L, 5L}), (Object)In.fromString((String)"3,4,5", (Schema)LONG));
    }

    @Test
    public void testSingleFloatValue() {
        Assert.assertEquals((String)"In#toString(FLOAT)", (Object)"34.56", (Object)Predicates.in((Object[])new Float[]{Float.valueOf(34.56f)}).toString(FLOAT));
        Assert.assertEquals((String)"In.fromString(String, FLOAT)", (Object)Predicates.in((Object[])new Float[]{Float.valueOf(34.56f)}), (Object)In.fromString((String)"34.56", (Schema)FLOAT));
    }

    @Test
    public void testMultipleFloatValues() {
        Assert.assertEquals((String)"In#toString(FLOAT)", (Object)"34.0,5.6", (Object)Predicates.in((Object[])new Float[]{Float.valueOf(34.0f), Float.valueOf(5.6f)}).toString(FLOAT));
        Assert.assertEquals((String)"In.fromString(String, FLOAT)", (Object)Predicates.in((Object[])new Float[]{Float.valueOf(34.0f), Float.valueOf(5.6f)}), (Object)In.fromString((String)"34.0,5.6", (Schema)FLOAT));
    }

    @Test
    public void testSingleDoubleValue() {
        Assert.assertEquals((String)"In#toString(DOUBLE)", (Object)"34.56", (Object)Predicates.in((Object[])new Double[]{34.56}).toString(DOUBLE));
        Assert.assertEquals((String)"In.fromString(String, DOUBLE)", (Object)Predicates.in((Object[])new Double[]{34.56}), (Object)In.fromString((String)"34.56", (Schema)DOUBLE));
    }

    @Test
    public void testMultipleDoubleValues() {
        Assert.assertEquals((String)"In#toString(DOUBLE)", (Object)"34.0,5.6", (Object)Predicates.in((Object[])new Double[]{34.0, 5.6}).toString(DOUBLE));
        Assert.assertEquals((String)"In.fromString(String, DOUBLE)", (Object)Predicates.in((Object[])new Double[]{34.0, 5.6}), (Object)In.fromString((String)"34.0,5.6", (Schema)DOUBLE));
    }

    @Test
    public void testSingleBytesValue() {
        ByteBuffer data = ByteBuffer.wrap(new byte[]{97, 98, 99});
        Assert.assertEquals((String)"In#toString(BYTES)", (Object)"BmFiYw", (Object)Predicates.in((Object[])new ByteBuffer[]{data}).toString(BYTES));
        Assert.assertEquals((String)"In.fromString(String, BYTES)", (Object)Predicates.in((Object[])new ByteBuffer[]{data}), (Object)In.fromString((String)"BmFiYw", (Schema)BYTES));
    }

    @Test
    public void testMultipleBytesValues() {
        ByteBuffer data1 = ByteBuffer.wrap(new byte[]{97, 98, 99});
        ByteBuffer data2 = ByteBuffer.wrap(new byte[]{100, 101, 102});
        Assert.assertEquals((String)"In#toString(BYTES)", (Object)"BmFiYw,BmRlZg", (Object)Predicates.in((Object[])new ByteBuffer[]{data1, data2}).toString(BYTES));
        Assert.assertEquals((String)"In.fromString(String, BYTES)", (Object)Predicates.in((Object[])new ByteBuffer[]{data1, data2}), (Object)In.fromString((String)"BmFiYw,BmRlZg", (Schema)BYTES));
    }

    @Test
    public void testSingleArrayValue() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        Assert.assertEquals((String)"In#toString(ARRAY)", (Object)"BgIEBgA", (Object)Predicates.in((Object[])new Object[]{list}).toString(ARRAY));
        Assert.assertEquals((String)"In.fromString(String, ARRAY)", (Object)Predicates.in((Object[])new Object[]{list}), (Object)In.fromString((String)"BgIEBgA", (Schema)ARRAY));
    }

    @Test
    public void testMultipleArrayValues() {
        ArrayList list1 = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{4, 5, 6});
        Assert.assertEquals((String)"In#toString(ARRAY)", (Object)"BgIEBgA,BggKDAA", (Object)Predicates.in((Object[])new Object[]{list1, list2}).toString(ARRAY));
        Assert.assertEquals((String)"In.fromString(String, ARRAY)", (Object)Predicates.in((Object[])new Object[]{list1, list2}), (Object)In.fromString((String)"BgIEBgA,BggKDAA", (Schema)ARRAY));
    }
}

