/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.partition.CalendarFieldPartitioner;
import org.kitesdk.data.spi.partition.DateFormatPartitioner;
import org.kitesdk.data.spi.partition.DayOfMonthFieldPartitioner;
import org.kitesdk.data.spi.partition.HashFieldPartitioner;
import org.kitesdk.data.spi.partition.HourFieldPartitioner;
import org.kitesdk.data.spi.partition.IdentityFieldPartitioner;
import org.kitesdk.data.spi.partition.IntRangeFieldPartitioner;
import org.kitesdk.data.spi.partition.ListFieldPartitioner;
import org.kitesdk.data.spi.partition.LongFixedSizeRangeFieldPartitioner;
import org.kitesdk.data.spi.partition.MinuteFieldPartitioner;
import org.kitesdk.data.spi.partition.MonthFieldPartitioner;
import org.kitesdk.data.spi.partition.RangeFieldPartitioner;
import org.kitesdk.data.spi.partition.YearFieldPartitioner;
import org.kitesdk.data.spi.predicates.In;
import org.kitesdk.data.spi.predicates.Predicates;
import org.kitesdk.data.spi.predicates.Range;
import org.kitesdk.data.spi.predicates.Ranges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPartitionerProjection {
    private static final Logger LOG = LoggerFactory.getLogger(TestPartitionerProjection.class);
    public long sepInstant = 1379020547042L;
    public long octInstant = 1381612547042L;
    public long novInstant = 1384204547042L;
    public static final long ONE_DAY_MILLIS = 86400000L;
    public static final long ONE_YEAR_MILLIS = 31536000000L;

    @Test
    public void testDateFormatPartitionerRangePredicate() {
        DateFormatPartitioner fp = new DateFormatPartitioner("timestamp", "date", "yyyy-MM-dd");
        Predicate projected = fp.project((Predicate)Ranges.open((Object)this.octInstant, (Object)(this.octInstant + 86400000L)));
        Assert.assertEquals((Object)Ranges.closed((Object)"2013-10-12", (Object)"2013-10-13"), (Object)projected);
    }

    @Test
    @Ignore
    public void testDateFormatPartitionerProjectStrict() {
        DateFormatPartitioner fp = new DateFormatPartitioner("timestamp", "date", "yyyy-MM-dd");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        Predicate projected = fp.projectStrict((Predicate)Ranges.open((Object)this.sepInstant, (Object)this.novInstant));
        Assert.assertEquals((Object)Ranges.closed((Object)"2013-09-13", (Object)"2013-11-10"), (Object)projected);
    }

    @Test
    public void testDateFormatPartitionerSetPredicate() {
        DateFormatPartitioner fp = new DateFormatPartitioner("timestamp", "date", "yyyy-MM-dd");
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"2013-09-12", "2013-10-12", "2013-11-11"}), (Object)fp.project((Predicate)Predicates.in((Object[])new Long[]{this.sepInstant, this.octInstant, this.novInstant})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{this.sepInstant, this.octInstant, this.novInstant})));
    }

    @Test
    public void testYearFieldPartitionerRangePredicate() {
        YearFieldPartitioner fp = new YearFieldPartitioner("timestamp", "year");
        Assert.assertEquals((Object)Ranges.singleton((Object)2013), (Object)fp.project((Predicate)Ranges.open((Object)this.sepInstant, (Object)this.novInstant)));
        Assert.assertNull((String)"No year value definitely satisfies original predicate", (Object)fp.projectStrict((Predicate)Ranges.open((Object)this.sepInstant, (Object)this.novInstant)));
        Assert.assertEquals((Object)Ranges.closed((Object)2012, (Object)2013), (Object)fp.project((Predicate)Ranges.open((Object)(this.sepInstant - 31536000000L), (Object)this.novInstant)));
        Assert.assertNull((String)"No year value definitely satisfies original predicate", (Object)fp.projectStrict((Predicate)Ranges.open((Object)(this.sepInstant - 31536000000L), (Object)this.novInstant)));
        Assert.assertEquals((Object)Ranges.closed((Object)2012, (Object)2014), (Object)fp.project((Predicate)Ranges.open((Object)(this.sepInstant - 31536000000L), (Object)(this.novInstant + 31536000000L))));
        Assert.assertEquals((Object)Ranges.singleton((Object)2013), (Object)fp.projectStrict((Predicate)Ranges.open((Object)(this.sepInstant - 31536000000L), (Object)(this.novInstant + 31536000000L))));
        Assert.assertEquals((Object)Ranges.atLeast((Object)2013), (Object)fp.project((Predicate)Ranges.greaterThan((Object)this.sepInstant)));
        Assert.assertEquals((Object)Ranges.atLeast((Object)2014), (Object)fp.projectStrict((Predicate)Ranges.greaterThan((Object)this.sepInstant)));
        Assert.assertEquals((Object)Ranges.atMost((Object)2013), (Object)fp.project((Predicate)Ranges.atMost((Object)this.sepInstant)));
        Assert.assertEquals((Object)Ranges.atMost((Object)2012), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)this.sepInstant)));
        long first2013 = new DateTime(2013, 1, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long last2012 = first2013 - 1L;
        Assert.assertEquals((Object)Ranges.atMost((Object)2012), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)last2012)));
        Assert.assertEquals((Object)Ranges.atMost((Object)2012), (Object)fp.projectStrict((Predicate)Ranges.lessThan((Object)first2013)));
        Assert.assertEquals((Object)Ranges.atLeast((Object)2013), (Object)fp.projectStrict((Predicate)Ranges.atLeast((Object)first2013)));
        Assert.assertEquals((Object)Ranges.atLeast((Object)2013), (Object)fp.projectStrict((Predicate)Ranges.greaterThan((Object)last2012)));
    }

    @Test
    public void testYearFieldPartitionerSetPredicate() {
        YearFieldPartitioner fp = new YearFieldPartitioner("timestamp", "year");
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2013}), (Object)fp.project((Predicate)Predicates.in((Object[])new Long[]{this.sepInstant, this.octInstant})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{this.sepInstant})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2012, 2013}), (Object)fp.project((Predicate)Predicates.in((Object[])new Long[]{this.sepInstant - 31536000000L, this.octInstant})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{this.sepInstant - 31536000000L, this.octInstant})));
    }

    @Test
    public void testCalendarFieldPartitioners() {
        ArrayList fps = Lists.newArrayList((Object[])new CalendarFieldPartitioner[]{new MonthFieldPartitioner("timestamp", "month"), new DayOfMonthFieldPartitioner("timestamp", "day"), new HourFieldPartitioner("timestamp", "hour"), new MinuteFieldPartitioner("timestamp", "min")});
        for (CalendarFieldPartitioner fp : fps) {
            Assert.assertNull((Object)fp.project((Predicate)Predicates.in((Object[])new Long[]{this.octInstant})));
            Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{this.octInstant})));
            Assert.assertNull((Object)fp.project((Predicate)Ranges.greaterThan((Object)this.sepInstant)));
            Assert.assertNull((Object)fp.projectStrict((Predicate)Ranges.open((Object)this.octInstant, (Object)this.novInstant)));
        }
    }

    @Test
    public void testHashFieldPartitionerRangePredicate() {
        HashFieldPartitioner fp = new HashFieldPartitioner("name", 50);
        Assert.assertNull((Object)fp.project((Predicate)Ranges.open((Object)"a", (Object)"b")));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Ranges.open((Object)"a", (Object)"b")));
    }

    @Test
    public void testHashFieldPartitionerSetPredicate() {
        HashFieldPartitioner fp = new HashFieldPartitioner("name", 50);
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{(Integer)fp.apply((Object)"a"), (Integer)fp.apply((Object)"b")}), (Object)fp.project((Predicate)Predicates.in((Object[])new String[]{"a", "b"})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new String[]{"a"})));
    }

    @Test
    public void testIdentityFieldPartitionerRangePredicate() {
        IdentityFieldPartitioner fp = new IdentityFieldPartitioner("str", "str_copy", String.class, 50);
        Range r = Ranges.openClosed((Object)"a", (Object)"b");
        Assert.assertEquals((Object)r, (Object)fp.project((Predicate)r));
        Assert.assertEquals((Object)r, (Object)fp.projectStrict((Predicate)r));
    }

    @Test
    public void testIdentityFieldPartitionerSetPredicate() {
        IdentityFieldPartitioner fp = new IdentityFieldPartitioner("str", "str_copy", String.class, 50);
        In s = Predicates.in((Object[])new String[]{"a", "b"});
        Assert.assertEquals((Object)s, (Object)fp.project((Predicate)s));
        Assert.assertEquals((Object)s, (Object)fp.projectStrict((Predicate)s));
    }

    @Test
    public void testIntRangeFieldPartitionerRangePredicate() {
        IntRangeFieldPartitioner fp = new IntRangeFieldPartitioner("num", new int[]{5, 10, 15, 20});
        Assert.assertEquals((Object)Ranges.closed((Object)1, (Object)2), (Object)fp.project((Predicate)Ranges.open((Object)5, (Object)15)));
        Assert.assertEquals((Object)Ranges.closed((Object)0, (Object)2), (Object)fp.project((Predicate)Ranges.open((Object)4, (Object)15)));
        Assert.assertEquals((Object)Ranges.closed((Object)0, (Object)3), (Object)fp.project((Predicate)Ranges.open((Object)4, (Object)21)));
        TestHelpers.assertThrows("Should not project an invalid range", IllegalArgumentException.class, new Runnable((FieldPartitioner)fp){
            final /* synthetic */ FieldPartitioner val$fp;
            {
                this.val$fp = fieldPartitioner;
            }

            @Override
            public void run() {
                this.val$fp.project((Predicate)Ranges.openClosed((Object)5, (Object)21));
            }
        });
        Assert.assertEquals((Object)Ranges.closed((Object)1, (Object)2), (Object)fp.projectStrict((Predicate)Ranges.open((Object)5, (Object)15)));
        Assert.assertEquals((Object)Ranges.singleton((Object)1), (Object)fp.projectStrict((Predicate)Ranges.open((Object)5, (Object)14)));
        Assert.assertEquals((Object)Ranges.atMost((Object)2), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)15)));
        Assert.assertEquals((Object)Ranges.atMost((Object)3), (Object)fp.projectStrict((Predicate)Ranges.lessThan((Object)21)));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Ranges.closed((Object)15, (Object)16)));
        Assert.assertEquals((Object)Ranges.atLeast((Object)3), (Object)fp.projectStrict((Predicate)Ranges.atLeast((Object)14)));
        TestHelpers.assertThrows("Should not project an invalid range", IllegalArgumentException.class, new Runnable((FieldPartitioner)fp){
            final /* synthetic */ FieldPartitioner val$fp;
            {
                this.val$fp = fieldPartitioner;
            }

            @Override
            public void run() {
                this.val$fp.projectStrict((Predicate)Ranges.openClosed((Object)5, (Object)21));
            }
        });
    }

    @Test
    public void testIntRangeFieldPartitionerSetPredicate() {
        IntRangeFieldPartitioner fp = new IntRangeFieldPartitioner("num", new int[]{5, 10, 15, 20});
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 3}), (Object)fp.project((Predicate)Predicates.in((Object[])new Integer[]{6, 7, 16, 17})));
        TestHelpers.assertThrows("Should not project invalid set", IllegalArgumentException.class, new Runnable((FieldPartitioner)fp){
            final /* synthetic */ FieldPartitioner val$fp;
            {
                this.val$fp = fieldPartitioner;
            }

            @Override
            public void run() {
                this.val$fp.project((Predicate)Predicates.in((Object[])new Integer[]{21}));
            }
        });
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Integer[]{6, 7, 16, 17})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1}), (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Integer[]{6, 7, 8, 9, 10, 16, 17})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 3}), (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Integer[]{5, 6, 7, 8, 9, 10, 16, 17, 18, 19, 20})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1}), (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Integer[]{6, 7, 8, 9, 10, 16, 17, 22})));
    }

    @Test
    public void testLongFixedSizeRangeFieldPartitionerRangePredicate() {
        LongFixedSizeRangeFieldPartitioner fp = new LongFixedSizeRangeFieldPartitioner("num", 5L);
        Assert.assertEquals((Object)Ranges.closed((Object)-5L, (Object)10L), (Object)fp.project((Predicate)Ranges.open((Object)-2L, (Object)15L)));
        Assert.assertEquals((Object)Ranges.closed((Object)5L, (Object)10L), (Object)fp.project((Predicate)Ranges.open((Object)5L, (Object)15L)));
        Assert.assertEquals((Object)Ranges.closed((Object)5L, (Object)10L), (Object)fp.project((Predicate)Ranges.open((Object)4L, (Object)15L)));
        Assert.assertEquals((Object)Ranges.closed((Object)0L, (Object)15L), (Object)fp.project((Predicate)Ranges.closed((Object)4L, (Object)15L)));
        Assert.assertEquals((Object)Ranges.closed((Object)5L, (Object)20L), (Object)fp.project((Predicate)Ranges.openClosed((Object)5L, (Object)21L)));
        Assert.assertEquals((Object)Ranges.atMost((Object)15L), (Object)fp.project((Predicate)Ranges.atMost((Object)15L)));
        Assert.assertEquals((Object)Ranges.atMost((Object)20L), (Object)fp.project((Predicate)Ranges.lessThan((Object)21L)));
        Assert.assertEquals((Object)Ranges.atLeast((Object)10L), (Object)fp.project((Predicate)Ranges.atLeast((Object)14L)));
        Assert.assertEquals((Object)Ranges.singleton((Object)10L), (Object)fp.projectStrict((Predicate)Ranges.open((Object)5L, (Object)15L)));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Ranges.open((Object)5L, (Object)14L)));
        Assert.assertEquals((Object)Ranges.atMost((Object)10L), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)15L)));
        Assert.assertEquals((Object)Ranges.atMost((Object)15L), (Object)fp.projectStrict((Predicate)Ranges.lessThan((Object)21L)));
        Assert.assertEquals((Object)Ranges.atLeast((Object)15L), (Object)fp.projectStrict((Predicate)Ranges.atLeast((Object)14L)));
    }

    @Test
    public void testLongFixedSizeRangeFieldPartitionerSetPredicate() {
        LongFixedSizeRangeFieldPartitioner fp = new LongFixedSizeRangeFieldPartitioner("num", 5L);
        Assert.assertEquals((Object)Predicates.in((Object[])new Long[]{5L, 15L}), (Object)fp.project((Predicate)Predicates.in((Object[])new Long[]{5L, 6L, 15L, 16L})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{5L, 6L, 15L, 16L})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Long[]{5L}), (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{5L, 6L, 7L, 8L, 9L, 15L, 16L})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Long[]{5L, 15L}), (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Long[]{4L, 5L, 6L, 7L, 8L, 9L, 10L, 15L, 16L, 17L, 18L, 19L, 20L})));
    }

    @Test
    public void testRangeFieldPartitionerRangePredicate() {
        RangeFieldPartitioner fp = new RangeFieldPartitioner("str", "str_bound", new String[]{"a", "b", "c"});
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a"}), (Object)fp.project((Predicate)Ranges.atMost((Object)"a")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a", "b"}), (Object)fp.project((Predicate)Ranges.closedOpen((Object)"a", (Object)"b")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a", "b"}), (Object)fp.project((Predicate)Ranges.closedOpen((Object)"a", (Object)"aa")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a", "b", "c"}), (Object)fp.project((Predicate)Ranges.closedOpen((Object)"a", (Object)"ba")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a", "b", "c"}), (Object)fp.project((Predicate)Ranges.closedOpen((Object)"0", (Object)"c")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"c"}), (Object)fp.project((Predicate)Ranges.atLeast((Object)"c")));
        TestHelpers.assertThrows("Cannot project endpoint outside of bounds", IllegalArgumentException.class, new Runnable((FieldPartitioner)fp){
            final /* synthetic */ FieldPartitioner val$fp;
            {
                this.val$fp = fieldPartitioner;
            }

            @Override
            public void run() {
                this.val$fp.project((Predicate)Ranges.atMost((Object)"cc"));
            }
        });
        Assert.assertNull((Object)fp.projectStrict((Predicate)Ranges.lessThan((Object)"a")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a"}), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)"a")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a"}), (Object)fp.projectStrict((Predicate)Ranges.lessThan((Object)"b")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a", "b"}), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)"b")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"c"}), (Object)fp.projectStrict((Predicate)Ranges.atLeast((Object)"b")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"c"}), (Object)fp.projectStrict((Predicate)Ranges.greaterThan((Object)"b")));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a"}), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)"ab")));
    }

    @Test
    public void testRangeFieldPartitionerSetPredicate() {
        RangeFieldPartitioner fp = new RangeFieldPartitioner("str", new String[]{"a", "b", "c"});
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a"}), (Object)fp.project((Predicate)Predicates.in((Object[])new String[]{"0"})));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a"}), (Object)fp.project((Predicate)Predicates.in((Object[])new String[]{"a"})));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"b"}), (Object)fp.project((Predicate)Predicates.in((Object[])new String[]{"aa"})));
        Assert.assertEquals((Object)Predicates.in((Object[])new String[]{"a", "b"}), (Object)fp.project((Predicate)Predicates.in((Object[])new String[]{"a", "aa", "b"})));
        TestHelpers.assertThrows("Cannot project endpoint outside of bounds", IllegalArgumentException.class, new Runnable((FieldPartitioner)fp){
            final /* synthetic */ FieldPartitioner val$fp;
            {
                this.val$fp = fieldPartitioner;
            }

            @Override
            public void run() {
                this.val$fp.project((Predicate)Predicates.in((Object[])new String[]{"cc"}));
            }
        });
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new String[]{"0"})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new String[]{"a"})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new String[]{"aa"})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new String[]{"a", "aa", "b"})));
        Assert.assertNull((Object)fp.projectStrict((Predicate)Predicates.in((Object[])new String[]{"cc"})));
    }

    @Test
    public void testListFieldPartitionerRangePredicate() {
        ArrayList sets = Lists.newArrayList();
        sets.add(Sets.newHashSet((Object[])new Integer[]{7, 14, 21, 28, 35, 42, 49}));
        sets.add(Sets.newHashSet((Object[])new Integer[]{11, 22, 33, 44}));
        sets.add(Sets.newHashSet((Object[])new Integer[]{13, 26, 39}));
        ListFieldPartitioner fp = new ListFieldPartitioner("name", (List)sets, Integer.class);
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1, 2}), (Object)fp.project((Predicate)Ranges.closed((Object)0, (Object)50)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1}), (Object)fp.project((Predicate)Ranges.closed((Object)5, (Object)12)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 2}), (Object)fp.project((Predicate)Ranges.open((Object)7, (Object)14)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1}), (Object)fp.project((Predicate)Ranges.closedOpen((Object)7, (Object)13)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 2}), (Object)fp.project((Predicate)Ranges.openClosed((Object)7, (Object)13)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0}), (Object)fp.project((Predicate)Ranges.atMost((Object)10)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1}), (Object)fp.project((Predicate)Ranges.atLeast((Object)40)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0}), (Object)fp.project((Predicate)Ranges.greaterThan((Object)44)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1}), (Object)fp.project((Predicate)Ranges.lessThan((Object)13)));
        Assert.assertEquals(null, (Object)fp.project((Predicate)Ranges.lessThan((Object)5)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1, 2}), (Object)fp.projectStrict((Predicate)Ranges.closed((Object)0, (Object)50)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 2}), (Object)fp.projectStrict((Predicate)Ranges.closed((Object)11, (Object)44)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2}), (Object)fp.projectStrict((Predicate)Ranges.open((Object)11, (Object)44)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2}), (Object)fp.projectStrict((Predicate)Ranges.closedOpen((Object)13, (Object)44)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2}), (Object)fp.projectStrict((Predicate)Ranges.openClosed((Object)11, (Object)39)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 2}), (Object)fp.projectStrict((Predicate)Ranges.atMost((Object)44)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1, 2}), (Object)fp.projectStrict((Predicate)Ranges.atLeast((Object)11)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2}), (Object)fp.projectStrict((Predicate)Ranges.greaterThan((Object)11)));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2}), (Object)fp.projectStrict((Predicate)Ranges.lessThan((Object)44)));
        Assert.assertEquals(null, (Object)fp.projectStrict((Predicate)Ranges.closed((Object)20, (Object)30)));
    }

    @Test
    public void testListFieldPartitionerSetPredicate() {
        ArrayList sets = Lists.newArrayList();
        sets.add(Sets.newHashSet((Object[])new Integer[]{7, 14, 21, 28, 35, 42, 49}));
        sets.add(Sets.newHashSet((Object[])new Integer[]{11, 22, 33, 44}));
        sets.add(Sets.newHashSet((Object[])new Integer[]{13, 26, 39}));
        ListFieldPartitioner fp = new ListFieldPartitioner("name", (List)sets, Integer.class);
        TestHelpers.assertThrows("Values not in any set are invalid", IllegalArgumentException.class, new Runnable((FieldPartitioner)fp){
            final /* synthetic */ FieldPartitioner val$fp;
            {
                this.val$fp = fieldPartitioner;
            }

            @Override
            public void run() {
                this.val$fp.project((Predicate)Predicates.in((Object[])new Integer[]{12}));
            }
        });
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1, 2}), (Object)fp.project((Predicate)Predicates.in((Object[])new Integer[]{7, 11, 13})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 1, 2}), (Object)fp.project((Predicate)Predicates.in((Object[])new Integer[]{7, 11, 22, 33, 44, 13})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0, 2}), (Object)fp.project((Predicate)Predicates.in((Object[])new Integer[]{7, 13})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{0}), (Object)fp.project((Predicate)Predicates.in((Object[])new Integer[]{7})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{2}), (Object)fp.project((Predicate)Predicates.in((Object[])new Integer[]{13})));
        Assert.assertEquals(null, (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Integer[]{7, 11, 13})));
        Assert.assertEquals((Object)Predicates.in((Object[])new Integer[]{1}), (Object)fp.projectStrict((Predicate)Predicates.in((Object[])new Integer[]{7, 11, 22, 33, 44, 13})));
    }
}

