/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.partition.DateFormatPartitioner;

public class TestDateFormatPartitioner {
    @Test
    public void testApply() {
        long time = 1384912178434L;
        DateFormatPartitioner yyyyMMdd_UTC = new DateFormatPartitioner("sourceField", "day", "yyyy-MM-dd");
        Assert.assertEquals((Object)"2013-11-20", (Object)yyyyMMdd_UTC.apply(Long.valueOf(time)));
        DateFormatPartitioner yyyyMMdd_PDT = new DateFormatPartitioner("sourceField", "day", "yyyy-MM-dd", 1095, TimeZone.getTimeZone("PDT"));
        Assert.assertEquals((Object)"2013-11-20", (Object)yyyyMMdd_PDT.apply(Long.valueOf(time)));
    }

    @Test
    public void testExpressionRoundTrip() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().dateFormat("timestamp", "day", "yyyy-MM-dd").build();
        PartitionStrategy copy = Accessor.getDefault().fromExpression(Accessor.getDefault().toExpression(strategy));
        Assert.assertEquals((Object)strategy, (Object)copy);
    }
}

