/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.event.StandardEvent;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestWriteSpecificReadGeneric
extends TestDatasetReaders<GenericData.Record> {
    private static final int totalRecords = 100;
    protected static FileSystem fs = null;
    protected static Path testDirectory = null;
    protected static Dataset<GenericData.Record> readerDataset;

    @BeforeClass
    public static void setup() throws IOException {
        fs = LocalFileSystem.getInstance();
        testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        FileSystemDatasetRepository repo = new FileSystemDatasetRepository(fs.getConf(), testDirectory);
        Dataset writerDataset = repo.create("ns", "test", new DatasetDescriptor.Builder().schema(StandardEvent.class).build(), StandardEvent.class);
        DatasetWriter writer = writerDataset.newWriter();
        for (long i = 0L; i < 100L; ++i) {
            String text = String.valueOf(i);
            writer.write((Object)new StandardEvent(text, text, i, text, text, i));
        }
        writer.close();
        readerDataset = repo.load("ns", "test", GenericData.Record.class);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        fs.delete(testDirectory, true);
    }

    @Override
    public DatasetReader<GenericData.Record> newReader() throws IOException {
        return readerDataset.newReader();
    }

    @Override
    public int getTotalRecords() {
        return 100;
    }

    @Override
    public DatasetTestUtilities.RecordValidator<GenericData.Record> getValidator() {
        return new DatasetTestUtilities.RecordValidator<GenericData.Record>(){

            @Override
            public void validate(GenericData.Record record, int recordNum) {
                Assert.assertEquals(GenericData.Record.class, record.getClass());
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("event_initiator").toString());
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("event_name").toString());
                Assert.assertEquals((Object)recordNum, (Object)record.get("user_id"));
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("session_id").toString());
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("ip").toString());
                Assert.assertEquals((Object)recordNum, (Object)record.get("timestamp"));
            }
        };
    }
}

