/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.View;
import org.kitesdk.data.event.StandardEvent;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestSimpleView {
    protected static final StandardEvent event = StandardEvent.newBuilder().setEventInitiator("TestSimpleView").setEventName("TestEvent").setUserId(0L).setSessionId("session-0").setIp("localhost").setTimestamp(System.currentTimeMillis() + 35405168L).build();
    protected static final StandardEvent sepEvent = StandardEvent.newBuilder(event).setTimestamp(1379020547042L).build();
    protected static final StandardEvent octEvent = StandardEvent.newBuilder(event).setTimestamp(1381612547042L).setUserId(1L).build();
    protected static final StandardEvent novEvent = StandardEvent.newBuilder(event).setTimestamp(1384204547042L).build();
    protected DatasetRepository repo = null;
    protected Configuration conf = null;
    protected FileSystem fs;
    protected PartitionStrategy strategy = null;
    protected DatasetDescriptor testDescriptor = null;
    protected Dataset<StandardEvent> testDataset = null;

    public DatasetRepository newRepo() {
        return new FileSystemDatasetRepository.Builder().configuration(this.conf).rootDirectory(URI.create("target/data")).build();
    }

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.repo = this.newRepo();
        this.strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").hash("user_id", 2).build();
        this.testDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:standard_event.avsc").partitionStrategy(this.strategy).build();
        this.testDataset = this.repo.create("ns", "test", this.testDescriptor);
    }

    @After
    public void removeDataPath() throws IOException {
        this.fs.delete(new Path("target/data"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void assertContentEquals(Set<E> expected, View<E> view) throws IOException {
        DatasetReader reader = null;
        try {
            reader = view.newReader();
            Assert.assertEquals(expected, (Object)Sets.newHashSet((Iterable)reader));
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitedReader() throws IOException {
        DatasetWriter writer = null;
        try {
            writer = this.testDataset.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, octEvent, novEvent}), this.testDataset);
        long sepEnd = new DateTime(2013, 9, 30, 12, 59, 59, 999, DateTimeZone.UTC).getMillis();
        long octInstant = octEvent.getTimestamp();
        long novStart = new DateTime(2013, 11, 1, 0, 0, DateTimeZone.UTC).getMillis();
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent, novEvent}), this.testDataset.from("timestamp", (Comparable)Long.valueOf(octInstant)));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent, novEvent}), this.testDataset.fromAfter("timestamp", (Comparable)Long.valueOf(sepEnd)));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, octEvent}), this.testDataset.to("timestamp", (Comparable)Long.valueOf(octInstant)));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, octEvent}), this.testDataset.toBefore("timestamp", (Comparable)Long.valueOf(novStart)));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent}), this.testDataset.from("timestamp", (Comparable)Long.valueOf(octInstant)).toBefore("timestamp", (Comparable)Long.valueOf(novStart)));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, novEvent}), this.testDataset.with("user_id", new Object[]{0L}));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent}), this.testDataset.with("user_id", new Object[]{0L}).to("timestamp", (Comparable)Long.valueOf(octInstant)));
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent}), this.testDataset.to("timestamp", (Comparable)Long.valueOf(octInstant)).with("user_id", new Object[]{0L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefineIdentity() throws Exception {
        PartitionStrategy strategy = new PartitionStrategy.Builder().identity("user_id").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:standard_event.avsc").partitionStrategy(strategy).build();
        Dataset identityDataset = this.repo.create("ns", "test_identity", descriptor);
        DatasetWriter writer = null;
        try {
            writer = identityDataset.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TestSimpleView.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, novEvent}), identityDataset.with("user_id", new Object[]{0L}));
    }
}

