/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.IncompatibleSchemaException;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.SchemaManager;

@RunWith(value=Parameterized.class)
public class TestSchemaManager
extends MiniDFSTest {
    Path testDirectory;
    Configuration conf;
    FileSystem fileSystem;
    boolean distributed;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    public TestSchemaManager(boolean distributed) {
        this.distributed = distributed;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.distributed ? MiniDFSTest.getConfiguration() : new Configuration();
        this.fileSystem = FileSystem.get((Configuration)this.conf);
        this.testDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
    }

    @Test
    public void testCreateSchema() throws IOException {
        SchemaManager manager = SchemaManager.create((Configuration)TestSchemaManager.getConfiguration(), (Path)this.testDirectory);
        manager.writeSchema(DatasetTestUtilities.USER_SCHEMA);
        Schema schema = manager.getNewestSchema();
        Assert.assertEquals((Object)DatasetTestUtilities.USER_SCHEMA, (Object)schema);
    }

    @Test
    public void testUpdateSchema() throws IOException {
        SchemaManager manager = SchemaManager.create((Configuration)TestSchemaManager.getConfiguration(), (Path)this.testDirectory);
        manager.writeSchema(DatasetTestUtilities.USER_SCHEMA);
        Schema schema = manager.getNewestSchema();
        Assert.assertEquals((Object)DatasetTestUtilities.USER_SCHEMA, (Object)schema);
        Schema updatedSchema = (Schema)SchemaBuilder.record((String)schema.getName()).fields().requiredString("username").requiredString("email").optionalBoolean("extra_field").endRecord();
        manager.writeSchema(updatedSchema);
        Assert.assertEquals((Object)updatedSchema, (Object)manager.getNewestSchema());
    }

    @Test
    public void testManyUpdates() throws IOException {
        SchemaManager manager = SchemaManager.create((Configuration)TestSchemaManager.getConfiguration(), (Path)this.testDirectory);
        for (int i = 0; i < 20; ++i) {
            SchemaBuilder.FieldAssembler fields = SchemaBuilder.record((String)"test").fields();
            for (int j = 0; j <= i; ++j) {
                fields.optionalString("field_" + j);
            }
            Schema schema = (Schema)fields.endRecord();
            manager.writeSchema(schema);
            Assert.assertEquals((Object)schema, (Object)manager.getNewestSchema());
        }
        Map schemas = manager.getSchemas();
        Assert.assertEquals((long)20L, (long)schemas.size());
    }

    @Test(expected=IncompatibleSchemaException.class)
    public void testIncompatibleUpdate() {
        SchemaManager manager = SchemaManager.create((Configuration)TestSchemaManager.getConfiguration(), (Path)this.testDirectory);
        manager.writeSchema((Schema)SchemaBuilder.record((String)"test").fields().requiredString("foo").endRecord());
        manager.writeSchema((Schema)SchemaBuilder.record((String)"test").fields().requiredString("bar").endRecord());
    }

    @Test(expected=IncompatibleSchemaException.class)
    public void testIndirectIncompatibleUpdate() {
        SchemaManager manager = SchemaManager.create((Configuration)TestSchemaManager.getConfiguration(), (Path)this.testDirectory);
        manager.writeSchema((Schema)SchemaBuilder.record((String)"test").fields().optionalString("foo").endRecord());
        manager.writeSchema((Schema)SchemaBuilder.record((String)"test").fields().optionalString("bar").endRecord());
        manager.writeSchema((Schema)SchemaBuilder.record((String)"test").fields().optionalInt("foo").endRecord());
    }

    @Test
    public void testNoSchemaManagerDirectory() throws IOException {
        SchemaManager manager = SchemaManager.load((Configuration)TestSchemaManager.getConfiguration(), (Path)new Path(this.testDirectory, "NO_SUCH_DIRECTORY"));
        Assert.assertNull((Object)manager);
    }

    @Test
    public void testSameSchemaUpdate() throws IOException {
        SchemaManager manager = SchemaManager.create((Configuration)TestSchemaManager.getConfiguration(), (Path)this.testDirectory);
        URI uri1 = manager.writeSchema(DatasetTestUtilities.USER_SCHEMA);
        URI uri2 = manager.writeSchema(DatasetTestUtilities.USER_SCHEMA);
        Assert.assertEquals((String)"Updating with the same schema should not create a new URI", (Object)uri1, (Object)uri2);
    }
}

