/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.TestGenericRecord;

public class TestReadCustomGeneric
extends TestDatasetReaders<TestGenericRecord> {
    private static final int totalRecords = 100;
    protected static FileSystem fs = null;
    protected static Path testDirectory = null;
    protected static Dataset<TestGenericRecord> readerDataset;

    @BeforeClass
    public static void setup() throws IOException {
        fs = LocalFileSystem.getInstance();
        testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        FileSystemDatasetRepository repo = new FileSystemDatasetRepository(fs.getConf(), testDirectory);
        Dataset writerDataset = repo.create("ns", "test", new DatasetDescriptor.Builder().schema(MyRecord.class).build(), MyRecord.class);
        DatasetWriter writer = writerDataset.newWriter();
        for (int i = 0; i < 100; ++i) {
            writer.write((Object)new MyRecord(String.valueOf(i), i));
        }
        writer.close();
        readerDataset = repo.load("ns", "test", TestGenericRecord.class);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        fs.delete(testDirectory, true);
    }

    @Override
    public DatasetReader<TestGenericRecord> newReader() throws IOException {
        return readerDataset.newReader();
    }

    @Override
    public int getTotalRecords() {
        return 100;
    }

    @Override
    public DatasetTestUtilities.RecordValidator<TestGenericRecord> getValidator() {
        return new DatasetTestUtilities.RecordValidator<TestGenericRecord>(){

            @Override
            public void validate(TestGenericRecord record, int recordNum) {
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("text").toString());
                Assert.assertEquals((Object)recordNum, (Object)record.get("value"));
            }
        };
    }

    public static class MyRecord {
        private String text;
        private int value;

        public MyRecord() {
        }

        public MyRecord(String text, int value) {
            this.text = text;
            this.value = value;
        }
    }
}

