/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import junit.framework.Assert;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.fs.Path;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.PathConversion;
import org.kitesdk.data.spi.partition.DayOfMonthFieldPartitioner;
import org.kitesdk.data.spi.partition.HourFieldPartitioner;
import org.kitesdk.data.spi.partition.MinuteFieldPartitioner;
import org.kitesdk.data.spi.partition.MonthFieldPartitioner;
import org.kitesdk.data.spi.partition.YearFieldPartitioner;

public class TestPathConversion {
    private static final Schema schema = (Schema)SchemaBuilder.record((String)"Event").fields().requiredLong("id").requiredLong("timestamp").endRecord();
    private static final PathConversion convert = new PathConversion(schema);
    private static final Splitter EQ = Splitter.on((char)'=');

    @Test
    public void testDirnameMinWidth() {
        Assert.assertEquals((String)"min=01", (String)PathConversion.dirnameForValue((FieldPartitioner)new MinuteFieldPartitioner("timestamp", "min"), (Object)1));
        Assert.assertEquals((String)"hour=01", (String)PathConversion.dirnameForValue((FieldPartitioner)new HourFieldPartitioner("timestamp", "hour"), (Object)1));
        Assert.assertEquals((String)"day=01", (String)PathConversion.dirnameForValue((FieldPartitioner)new DayOfMonthFieldPartitioner("timestamp", "day"), (Object)1));
        Assert.assertEquals((String)"month=01", (String)PathConversion.dirnameForValue((FieldPartitioner)new MonthFieldPartitioner("timestamp", "month"), (Object)1));
        Assert.assertEquals((String)"year=2013", (String)PathConversion.dirnameForValue((FieldPartitioner)new YearFieldPartitioner("timestamp", "year"), (Object)2013));
    }

    @Test
    public void testUsesFieldName() {
        Assert.assertEquals((String)"day_of_month_field", (String)((String)Iterables.getFirst((Iterable)EQ.split((CharSequence)PathConversion.dirnameForValue((FieldPartitioner)new DayOfMonthFieldPartitioner("day", "day_of_month_field"), (Object)10)), null)));
    }

    @Test
    public void testIgnoresPartitionName() {
        Assert.assertEquals((String)"10", (String)PathConversion.dirnameToValueString((String)"10"));
        Assert.assertEquals((String)"10", (String)PathConversion.dirnameToValueString((String)"=10"));
        Assert.assertEquals((String)"10", (String)PathConversion.dirnameToValueString((String)"anything=10"));
        Assert.assertEquals((int)10, (int)((Integer)convert.valueForDirname((FieldPartitioner)new MonthFieldPartitioner("timestamp", "month"), "10")));
        Assert.assertEquals((int)10, (int)((Integer)convert.valueForDirname((FieldPartitioner)new MonthFieldPartitioner("timestamp", "month"), "=10")));
        Assert.assertEquals((int)10, (int)((Integer)convert.valueForDirname((FieldPartitioner)new MonthFieldPartitioner("timestamp", "month"), "anything=10")));
        Assert.assertEquals((int)10, (int)((Integer)convert.valueForDirname((FieldPartitioner)new MonthFieldPartitioner("timestamp", "month"), "even=strange=10")));
    }

    @Test
    public void testNoValidation() {
        Assert.assertEquals((int)13, (int)((Integer)convert.valueForDirname((FieldPartitioner)new MonthFieldPartitioner("timestamp", "month"), "month=13")));
    }

    @Test
    public void testFromKey() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        StorageKey key = new StorageKey(strategy);
        key.replaceValues((List)Lists.newArrayList((Object[])new Integer[]{2013, 11, 5}));
        Assert.assertEquals((Object)new Path("year=2013/month=11/day=05"), (Object)convert.fromKey(key));
    }

    @Test
    public void testToKey() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        StorageKey expected = new StorageKey(strategy);
        expected.replaceValues((List)Lists.newArrayList((Object[])new Integer[]{2013, 11, 5}));
        Assert.assertEquals((Object)expected, (Object)convert.toKey(new Path("year=2013/month=11/day=5"), new StorageKey(strategy)));
    }

    @Test
    public void toDirNameIdentityWithSlashes() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().identity("name").identity("address").build();
        StorageKey key = new StorageKey(strategy);
        key.replaceValues((List)Lists.newArrayList((Object[])new String[]{"John Doe", "NY/USA"}));
        Assert.assertEquals((Object)new Path("name_copy=John+Doe/address_copy=NY%2FUSA"), (Object)convert.fromKey(key));
    }

    @Test
    public void toDirNameIdentityWithNonString() {
        PartitionStrategy strategy = new PartitionStrategy.Builder().identity("id").build();
        StorageKey expected = new StorageKey(strategy);
        expected.replace(0, (Object)0L);
        Assert.assertEquals((String)"Should convert to schema type", (Object)expected, (Object)convert.toKey(new Path("id=0"), new StorageKey(strategy)));
    }
}

