/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionView;

public class TestPartitionReplacement {
    private FileSystemDataset<TestRecord> unpartitioned = null;
    private FileSystemDataset<TestRecord> partitioned = null;
    private FileSystemDataset<TestRecord> temporary = null;

    @Before
    public void createTestDatasets() {
        Datasets.delete((String)"dataset:file:/tmp/datasets/unpartitioned");
        Datasets.delete((String)"dataset:file:/tmp/datasets/partitioned");
        Datasets.delete((String)"dataset:file:/tmp/datasets/temporary");
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(TestRecord.class).build();
        this.unpartitioned = (FileSystemDataset)Datasets.create((String)"dataset:file:/tmp/datasets/unpartitioned", (DatasetDescriptor)descriptor, TestRecord.class);
        descriptor = new DatasetDescriptor.Builder(descriptor).property("kite.writer.cache-size", "20").partitionStrategy(new PartitionStrategy.Builder().hash("id", 4).build()).build();
        this.partitioned = (FileSystemDataset)Datasets.create((String)"dataset:file:/tmp/datasets/partitioned", (DatasetDescriptor)descriptor, TestRecord.class);
        this.temporary = (FileSystemDataset)Datasets.create((String)"dataset:file:/tmp/datasets/temporary", (DatasetDescriptor)descriptor, TestRecord.class);
        TestPartitionReplacement.writeTestRecords(this.unpartitioned);
        TestPartitionReplacement.writeTestRecords(this.partitioned);
        TestPartitionReplacement.writeTestRecords(this.temporary);
    }

    @After
    public void removeTestDatasets() {
        Datasets.delete((String)"dataset:file:/tmp/datasets/unpartitioned");
        Datasets.delete((String)"dataset:file:/tmp/datasets/partitioned");
        Datasets.delete((String)"dataset:file:/tmp/datasets/temporary");
    }

    @Test
    public void testUnpartitionedReplace() {
        Datasets.delete((String)"dataset:file:/tmp/datasets/temporary");
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder(this.unpartitioned.getDescriptor()).location((URI)null).build();
        this.temporary = (FileSystemDataset)Datasets.create((String)"dataset:file:/tmp/datasets/temporary", (DatasetDescriptor)descriptor, TestRecord.class);
        Assert.assertTrue((String)"Should allow replacing an unpartitioned dataset", (boolean)this.unpartitioned.canReplace(this.unpartitioned));
        TestPartitionReplacement.writeTestRecords(this.unpartitioned);
        TestPartitionReplacement.writeTestRecords(this.unpartitioned);
        TestPartitionReplacement.writeTestRecords(this.temporary);
        TestPartitionReplacement.writeTestRecords(this.temporary);
        HashSet originalFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.unpartitioned.pathIterator(), (Function)new GetFilename()));
        HashSet replacementFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.temporary.pathIterator(), (Function)new GetFilename()));
        Iterators.transform((Iterator)this.temporary.pathIterator(), (Function)new GetFilename());
        Assert.assertFalse((String)"Sanity check", (boolean)originalFiles.equals(replacementFiles));
        this.unpartitioned.replace(this.unpartitioned, this.temporary);
        HashSet replacedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.unpartitioned.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Should contain the replacement files", (Object)replacementFiles, (Object)replacedFiles);
    }

    @Test
    public void testUnpartitionedReplaceDifferentStrategy() {
        final FileSystemPartitionView partition0 = this.partitioned.getPartitionView(new Path("id_hash=0"));
        Assert.assertFalse((String)"Should not allow replacement with a different strategy", (boolean)this.unpartitioned.canReplace(this.partitioned));
        Assert.assertFalse((String)"Should not allow replacement with a different strategy", (boolean)this.unpartitioned.canReplace((View)partition0));
        TestHelpers.assertThrows("Should not allow replacement with a different partition strategy", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                TestPartitionReplacement.this.unpartitioned.replace((View)TestPartitionReplacement.this.unpartitioned, (View)TestPartitionReplacement.this.partitioned);
            }
        });
        TestHelpers.assertThrows("Should not allow replacement with a different partition strategy", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                TestPartitionReplacement.this.unpartitioned.replace((View)TestPartitionReplacement.this.unpartitioned, (View)partition0);
            }
        });
    }

    @Test
    public void testReplaceWithDifferentStrategy() {
        Assert.assertFalse((String)"Should not allow replacement with a different strategy", (boolean)this.partitioned.canReplace(this.unpartitioned));
        TestHelpers.assertThrows("Should not allow replacement with a different partition strategy", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                TestPartitionReplacement.this.partitioned.replace((View)TestPartitionReplacement.this.partitioned, (View)TestPartitionReplacement.this.unpartitioned);
            }
        });
    }

    @Test
    public void testPartitionedReplace() {
        Assert.assertTrue((String)"Should allow replacing a whole dataset", (boolean)this.partitioned.canReplace(this.partitioned));
        Assert.assertTrue((String)"Should not allow replacement test with a different dataset", (!this.partitioned.canReplace(this.temporary) ? 1 : 0) != 0);
        HashSet originalFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        HashSet replacementFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.temporary.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Sanity check", (long)originalFiles.size(), (long)replacementFiles.size());
        Assert.assertFalse((String)"Sanity check", (boolean)originalFiles.equals(replacementFiles));
        this.partitioned.replace(this.partitioned, this.temporary);
        HashSet replacedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Should contain the replacement files", (Object)replacementFiles, (Object)replacedFiles);
    }

    @Test
    public void testReplaceSinglePartition() {
        FileSystemPartitionView partition0 = this.partitioned.getPartitionView(new Path("id_hash=0"));
        FileSystemPartitionView temp0 = this.temporary.getPartitionView(new Path("id_hash=0"));
        Assert.assertTrue((String)"Should allow replacing a single partition", (boolean)this.partitioned.canReplace((View)partition0));
        Assert.assertFalse((String)"Should not allow replacement test with a different dataset", (boolean)this.partitioned.canReplace((View)temp0));
        HashSet replacementFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)temp0.pathIterator(), (Function)new GetFilename()));
        HashSet originalPartitionFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)partition0.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Sanity check", (long)originalPartitionFiles.size(), (long)replacementFiles.size());
        Assert.assertFalse((String)"Sanity check", (boolean)originalPartitionFiles.equals(replacementFiles));
        HashSet expectedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        expectedFiles.removeAll(originalPartitionFiles);
        expectedFiles.addAll(replacementFiles);
        this.partitioned.replace((View)partition0, (View)temp0);
        HashSet replacedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Should contain the replacement files", (Object)expectedFiles, (Object)replacedFiles);
    }

    @Test
    public void testReplacePartitionsByConstraints() throws IOException {
        FileSystemPartitionView partition0 = this.partitioned.getPartitionView(new Path("id_hash=0"));
        FileSystemPartitionView temp0 = this.temporary.getPartitionView(new Path("id_hash=0"));
        HashSet replacementFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)temp0.pathIterator(), (Function)new GetFilename()));
        FileSystem local = LocalFileSystem.getInstance();
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=1"), new Path(this.partitioned.getDirectory(), "0"));
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=2"), new Path(this.partitioned.getDirectory(), "hash=0"));
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=3"), new Path(this.partitioned.getDirectory(), "id_hash=00"));
        Assert.assertTrue((String)"Should allow replacing a single partition", (boolean)this.partitioned.canReplace((View)partition0));
        Assert.assertFalse((String)"Should not allow replacement test with a different dataset", (boolean)this.partitioned.canReplace((View)temp0));
        this.partitioned.replace((View)partition0, (View)temp0);
        HashSet replacedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Should contain the replacement files", (Object)replacementFiles, (Object)replacedFiles);
        Iterator dirIterator = this.partitioned.dirIterator();
        Path onlyDirectory = (Path)dirIterator.next();
        Assert.assertFalse((String)"Should contain only one directory", (boolean)dirIterator.hasNext());
        Assert.assertEquals((String)"Should have the correct directory name", (Object)"id_hash=0", (Object)onlyDirectory.getName());
    }

    @Test
    public void testReplacePartitionsByConstraintsWithoutOriginal() throws IOException {
        FileSystemPartitionView temp0 = this.temporary.getPartitionView(new Path("id_hash=0"));
        HashSet replacementFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)temp0.pathIterator(), (Function)new GetFilename()));
        FileSystem local = LocalFileSystem.getInstance();
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=0"), new Path(this.partitioned.getDirectory(), "id-hash=0"));
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=1"), new Path(this.partitioned.getDirectory(), "0"));
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=2"), new Path(this.partitioned.getDirectory(), "hash=0"));
        local.rename(new Path(this.partitioned.getDirectory(), "id_hash=3"), new Path(this.partitioned.getDirectory(), "id_hash=00"));
        FileSystemPartitionView partition0 = this.partitioned.getPartitionView(new Path("id-hash=0"));
        Assert.assertTrue((String)"Should allow replacing a single partition", (boolean)this.partitioned.canReplace((View)partition0));
        Assert.assertFalse((String)"Should not allow replacement test with a different dataset", (boolean)this.partitioned.canReplace((View)temp0));
        this.partitioned.replace((View)partition0, (View)temp0);
        HashSet replacedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Should contain the replacement files", (Object)replacementFiles, (Object)replacedFiles);
        Iterator dirIterator = this.partitioned.dirIterator();
        Path onlyDirectory = (Path)dirIterator.next();
        Assert.assertFalse((String)"Should contain only one directory", (boolean)dirIterator.hasNext());
        Assert.assertEquals((String)"Should have the correct directory name", (Object)"id_hash=0", (Object)onlyDirectory.getName());
    }

    @Test
    public void testReplaceRemovesPartitionsNotIndividuallyReplaced() throws IOException {
        Assert.assertTrue((String)"Should allow replacing a whole dataset", (boolean)this.partitioned.canReplace(this.partitioned));
        Assert.assertTrue((String)"Should not allow replacement test with a different dataset", (!this.partitioned.canReplace(this.temporary) ? 1 : 0) != 0);
        FileSystem local = LocalFileSystem.getInstance();
        local.delete(new Path(this.temporary.getDirectory(), "id_hash=1"), true);
        local.delete(new Path(this.temporary.getDirectory(), "id_hash=3"), true);
        local.delete(new Path(this.partitioned.getDirectory(), "id_hash=2"), true);
        HashSet originalFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        HashSet replacementFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.temporary.pathIterator(), (Function)new GetFilename()));
        Assert.assertFalse((String)"Sanity check", (boolean)originalFiles.equals(replacementFiles));
        this.partitioned.replace(this.partitioned, this.temporary);
        HashSet replacedFiles = Sets.newHashSet((Iterator)Iterators.transform((Iterator)this.partitioned.pathIterator(), (Function)new GetFilename()));
        Assert.assertEquals((String)"Should contain the only the replacement files", (Object)replacementFiles, (Object)replacedFiles);
        Assert.assertEquals((String)"Should have only 2 files (1 in each partition)", (long)2L, (long)replacedFiles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTestRecords(View<TestRecord> view) {
        DatasetWriter writer = null;
        try {
            writer = view.newWriter();
            for (int i = 0; i < 10; ++i) {
                TestRecord record = new TestRecord();
                record.id = i;
                record.data = "test-" + i;
                writer.write((Object)record);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static class GetFilename
    implements Function<Path, String> {
        private GetFilename() {
        }

        public String apply(Path path) {
            return path.getName();
        }
    }

    public static class TestRecord {
        private long id;
        private String data;
    }
}

