/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Flushable;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.Syncable;
import org.kitesdk.data.spi.filesystem.DurableParquetAppender;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.data.spi.filesystem.ParquetAppender;
import org.kitesdk.data.spi.filesystem.ParquetFileSystemDatasetReader;
import org.kitesdk.data.spi.filesystem.TestFileSystemWriters;

public class TestParquetWriter
extends TestFileSystemWriters {
    @Override
    public FileSystemWriter<GenericData.Record> newWriter(Path directory, Schema schema) {
        return FileSystemWriter.newWriter((FileSystem)this.fs, (Path)directory, (DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).format("parquet").build());
    }

    @Override
    public DatasetReader<GenericData.Record> newReader(Path path, Schema schema) {
        return new ParquetFileSystemDatasetReader(this.fs, path, schema, GenericData.Record.class);
    }

    @Test
    public void testIsFlushable() {
        Assert.assertFalse((boolean)(this.fsWriter instanceof Flushable));
    }

    @Test
    public void testIsSyncable() {
        Assert.assertFalse((boolean)(this.fsWriter instanceof Syncable));
    }

    @Test
    public void testParquetConfiguration() throws IOException {
        FileSystem fs = LocalFileSystem.getInstance();
        FileSystemWriter writer = FileSystemWriter.newWriter((FileSystem)fs, (Path)new Path("/tmp"), (DatasetDescriptor)new DatasetDescriptor.Builder().property("parquet.block.size", "34343434").schema((Schema)SchemaBuilder.record((String)"test").fields().requiredString("s").endRecord()).format("parquet").build());
        Assert.assertEquals((String)"Should copy properties to Configuration", (long)34343434L, (long)writer.conf.getInt("parquet.block.size", -1));
    }

    @Test
    public void testDefaultToParquetAppender() throws IOException {
        Assert.assertEquals((String)"Should default to non-durable parquet appender", ParquetAppender.class, this.fsWriter.newAppender(this.testDirectory).getClass());
    }

    @Test
    public void testConfigureDurableParquetAppender() throws IOException {
        FileSystem fs = LocalFileSystem.getInstance();
        FileSystemWriter writer = FileSystemWriter.newWriter((FileSystem)fs, (Path)new Path("/tmp"), (DatasetDescriptor)new DatasetDescriptor.Builder().property("kite.parquet.non-durable-writes", "false").schema((Schema)SchemaBuilder.record((String)"test").fields().requiredString("s").endRecord()).format("parquet").build());
        Assert.assertEquals((String)"Disabling the non-durable parquet appender should get us a durable appender", DurableParquetAppender.class, writer.newAppender(this.testDirectory).getClass());
    }

    @Test
    public void testConfigureNonDurableParquetAppender() throws IOException {
        FileSystem fs = LocalFileSystem.getInstance();
        FileSystemWriter writer = FileSystemWriter.newWriter((FileSystem)fs, (Path)new Path("/tmp"), (DatasetDescriptor)new DatasetDescriptor.Builder().property("kite.parquet.non-durable-writes", "true").schema((Schema)SchemaBuilder.record((String)"test").fields().requiredString("s").endRecord()).format("parquet").build());
        Assert.assertEquals((String)"Enabling the non-durable parquet appender should get us a non-durable appender", ParquetAppender.class, writer.newAppender(this.testDirectory).getClass());
    }
}

