/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.net.URI;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemView;

public class TestLocalDatasetURIs {
    private static FileSystem localFS;
    private static DatasetDescriptor descriptor;

    @BeforeClass
    public static void createRepositoryAndTestDatasets() throws Exception {
        localFS = LocalFileSystem.getInstance();
        descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
    }

    @Test
    public void testAbsolute() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)"repo:file:/tmp/data");
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)"dataset:file:/tmp/data/ns/test", GenericData.Record.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Assert.assertEquals((String)"Locations should match", (Object)URI.create("file:/tmp/data/ns/test"), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }

    @Test
    public void testRelative() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)"repo:file:target/data");
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        Dataset ds = (Dataset)Datasets.load((String)"dataset:file:target/data/ns/test", GenericData.Record.class);
        Assert.assertNotNull((String)"Should load dataset", (Object)ds);
        Assert.assertTrue((boolean)(ds instanceof FileSystemDataset));
        Path cwd = localFS.makeQualified(new Path("."));
        Assert.assertEquals((String)"Locations should match", (Object)new Path(cwd, "target/data/ns/test").toUri(), (Object)ds.getDescriptor().getLocation());
        Assert.assertEquals((String)"Descriptors should match", (Object)repo.load("ns", "test").getDescriptor(), (Object)ds.getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)ds.getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)ds.getName());
        repo.delete("ns", "test");
    }

    @Test
    public void testViewConstraints() {
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)"repo:file:/tmp/data");
        repo.delete("ns", "test");
        repo.create("ns", "test", descriptor);
        RefinableView v = (RefinableView)Datasets.load((String)"view:file:/tmp/data/ns/test?username=user", GenericData.Record.class);
        Assert.assertNotNull((String)"Should load view", (Object)v);
        Assert.assertTrue((boolean)(v instanceof FileSystemView));
        Assert.assertEquals((String)"Locations should match", (Object)URI.create("file:/tmp/data/ns/test"), (Object)v.getDataset().getDescriptor().getLocation());
        DatasetDescriptor loaded = repo.load("ns", "test").getDescriptor();
        Assert.assertEquals((String)"Descriptors should match", (Object)loaded, (Object)v.getDataset().getDescriptor());
        Assert.assertEquals((String)"Should report correct namespace", (Object)"ns", (Object)v.getDataset().getNamespace());
        Assert.assertEquals((String)"Should report correct name", (Object)"test", (Object)v.getDataset().getName());
        Constraints withUser = new Constraints(loaded.getSchema()).with("username", new Object[]{new Utf8("user")});
        Assert.assertEquals((String)"Constraints should be username=user", (Object)withUser, (Object)((FileSystemView)v).getConstraints());
        repo.delete("ns", "test");
    }

    @Test
    public void testMissingDataset() {
        TestHelpers.assertThrows("Should not find dataset: no such dataset", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)"dataset:file:/tmp/data/ns/nosuchdataset", GenericData.Record.class);
            }
        });
    }

    @Test
    public void testMissingNamespace() {
        TestHelpers.assertThrows("Should not find dataset: no such namespace", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)"dataset:file:/tmp/data/nosuchnamespace/test", GenericData.Record.class);
            }
        });
    }

    @Test
    public void testNotEnoughPathComponents() {
        TestHelpers.assertThrows("Should not match URI pattern", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)"dataset:file:/test", GenericData.Record.class);
            }
        });
    }

    @Test
    public void testMissingRepository() {
        TestHelpers.assertThrows("Should not find dataset: unknown storage scheme", DatasetNotFoundException.class, new Runnable(){

            @Override
            public void run() {
                Dataset ds = (Dataset)Datasets.load((String)"dataset:unknown:/tmp/data/test", GenericData.Record.class);
            }
        });
    }
}

