/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.DescriptorUtil;
import org.kitesdk.data.spi.filesystem.AvroAppender;
import org.kitesdk.data.spi.filesystem.FileSystemUtil;
import org.kitesdk.data.spi.filesystem.ParquetAppender;

public class TestFileSystemUtil {
    private static final Schema USER_SCHEMA = (Schema)SchemaBuilder.record((String)"User").fields().requiredLong("id").requiredString("username").endRecord();
    private static final Schema EVENT_SCHEMA = (Schema)SchemaBuilder.record((String)"Event").fields().requiredLong("timestamp").requiredString("level").requiredString("message").endRecord();
    private static final GenericData.Record USER = new GenericData.Record(USER_SCHEMA);
    private static final GenericData.Record EVENT = new GenericData.Record(EVENT_SCHEMA);
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @BeforeClass
    public static void initRecords() {
        USER.put("id", (Object)1L);
        USER.put("username", (Object)"test");
        EVENT.put("timestamp", (Object)System.currentTimeMillis());
        EVENT.put("level", (Object)"DEBUG");
        EVENT.put("message", (Object)"Useless information!");
    }

    @Test
    public void testEmptyDataset() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e/dataset_name"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        URI datasetUri = URI.create("dataset:file:" + folder.getAbsolutePath());
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(USER_SCHEMA).build();
        Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor);
        ArrayList expected = Lists.newArrayList();
        Assert.assertEquals((String)"Should succeed and find no datasets", (Object)expected, (Object)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
    }

    @Test
    public void testUnpartitionedDataset() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e/dataset_name"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        URI datasetUri = URI.create("dataset:file:" + folder.getAbsolutePath());
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(USER_SCHEMA).build();
        Dataset dataset = (Dataset)Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor);
        this.writeUserToDataset((Dataset<GenericRecord>)dataset);
        this.writeUserToDataset((Dataset<GenericRecord>)dataset);
        DatasetDescriptor expected = dataset.getDescriptor();
        DatasetDescriptor actual = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        Assert.assertEquals((String)"Should succeed and find an equivalent descriptor", (Object)expected, (Object)actual);
    }

    @Test
    public void testPartitionedDataset() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e/dataset_name"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        URI datasetUri = URI.create("dataset:file:" + folder.getAbsolutePath());
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(USER_SCHEMA).partitionStrategy(new PartitionStrategy.Builder().hash("id", 4).build()).build();
        Dataset dataset = (Dataset)Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor);
        this.writeUserToDataset((Dataset<GenericRecord>)dataset);
        this.writeUserToDataset((Dataset<GenericRecord>)dataset);
        Path datasetPath = new Path(folder.toURI());
        Path partitionPath = new Path(datasetPath, "id_hash=1");
        DatasetDescriptor actual = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Location should be at the partition directory", (Object)partitionPath.toUri(), (Object)actual.getLocation());
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)actual.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)actual.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)actual.isPartitioned());
    }

    @Test
    public void testSingleAvroFile() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, parent);
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri().getPath(), (Object)this.parent(descriptor.getLocation()).getPath());
        Assert.assertTrue((String)"Should be a .avro file", (boolean)descriptor.getLocation().toString().endsWith(".avro"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)descriptor.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)descriptor.isPartitioned());
    }

    @Test
    public void testMultipleAvroFilesInOneFolder() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, parent);
        this.createAvroUserFile(fs, parent);
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)descriptor.getLocation());
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)descriptor.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)descriptor.isPartitioned());
    }

    @Test
    public void testMultipleAvroFilesInSeparateFolders() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, new Path(parent, "part=1"));
        this.createAvroUserFile(fs, new Path(parent, "2"));
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        PartitionStrategy strategy = new PartitionStrategy.Builder().provided("part", "int").build();
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)descriptor.getLocation());
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)descriptor.getFormat());
        Assert.assertEquals((String)"Should be partitioned by part=int", (Object)strategy, (Object)descriptor.getPartitionStrategy());
    }

    @Test
    public void testMultipleAvroFilesAtDifferentDepths() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, new Path(parent, "part=1"));
        this.createAvroUserFile(fs, parent);
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        PartitionStrategy strategy = new PartitionStrategy.Builder().provided("part", "int").build();
        Assert.assertTrue((String)"Should flag data at mixed depth in the directory tree", (boolean)DescriptorUtil.isEnabled((String)"kite.filesystem.mixed-depth", (DatasetDescriptor)descriptor));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)descriptor.getLocation());
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)descriptor.getFormat());
        Assert.assertEquals((String)"Should be partitioned by part=int", (Object)strategy, (Object)descriptor.getPartitionStrategy());
    }

    @Test
    public void testMultipleMergeTablesAtDifferentDepths() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, new Path(parent, "part=1"));
        this.createAvroUserFile(fs, new Path(parent, "part=1"));
        this.createAvroUserFile(fs, parent);
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        PartitionStrategy strategy = new PartitionStrategy.Builder().provided("part", "int").build();
        Assert.assertTrue((String)"Should flag data at mixed depth in the directory tree", (boolean)DescriptorUtil.isEnabled((String)"kite.filesystem.mixed-depth", (DatasetDescriptor)descriptor));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)descriptor.getLocation());
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)descriptor.getFormat());
        Assert.assertEquals((String)"Should be partitioned by part=int", (Object)strategy, (Object)descriptor.getPartitionStrategy());
    }

    @Test
    public void testMultipleAvroFilesInSeparateFoldersWithUnknown() throws Exception {
        DatasetDescriptor users2;
        DatasetDescriptor users1;
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, new Path(parent, "part=1"));
        this.createAvroUserFile(fs, new Path(parent, "part=2"));
        this.createUnknownFile(fs, new Path(parent, "part=3"));
        Collection descriptors = FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root);
        Assert.assertEquals((String)"Should have 2 descriptors", (long)2L, (long)descriptors.size());
        DatasetDescriptor first = (DatasetDescriptor)Iterables.getFirst((Iterable)descriptors, null);
        if (first.getLocation().toString().contains("part=1")) {
            users1 = first;
            users2 = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        } else {
            users2 = first;
            users1 = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        }
        if (users1.getLocation().toString().contains("part=2")) {
            users2 = (DatasetDescriptor)Iterables.getFirst((Iterable)descriptors, null);
            users1 = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        }
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)users1.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)new Path(parent, "part=1").toUri(), (Object)this.parent(users1.getLocation()));
        Assert.assertTrue((String)"Should be a .avro file", (boolean)users1.getLocation().toString().endsWith(".avro"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)users1.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)users1.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)users1.isPartitioned());
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)users2.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)new Path(parent, "part=2").toUri(), (Object)this.parent(users2.getLocation()));
        Assert.assertTrue((String)"Should be a .avro file", (boolean)users2.getLocation().toString().endsWith(".avro"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)users2.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)users2.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)users2.isPartitioned());
    }

    @Test
    public void testSingleParquetFile() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createParquetEventFile(fs, parent);
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri().getPath(), (Object)this.parent(descriptor.getLocation()).getPath());
        Assert.assertTrue((String)"Should be a .parquet file", (boolean)descriptor.getLocation().toString().endsWith(".parquet"));
        Assert.assertEquals((String)"Should use event schema", (Object)EVENT_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Parquet format", (Object)Formats.PARQUET, (Object)descriptor.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)descriptor.isPartitioned());
    }

    @Test
    public void testMultipleParquetFilesInOneFolder() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createParquetEventFile(fs, parent);
        this.createParquetEventFile(fs, parent);
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)descriptor.getLocation());
        Assert.assertEquals((String)"Should use event schema", (Object)EVENT_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Parquet format", (Object)Formats.PARQUET, (Object)descriptor.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)descriptor.isPartitioned());
    }

    @Test
    public void testMultipleParquetFilesInSeparateFolders() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createParquetEventFile(fs, new Path(parent, "part"));
        this.createParquetEventFile(fs, new Path(parent, "2"));
        DatasetDescriptor descriptor = (DatasetDescriptor)Iterables.getOnlyElement((Iterable)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
        PartitionStrategy strategy = new PartitionStrategy.Builder().provided("partition_1", "string").build();
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)descriptor.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)descriptor.getLocation());
        Assert.assertEquals((String)"Should use user schema", (Object)EVENT_SCHEMA, (Object)descriptor.getSchema());
        Assert.assertEquals((String)"Should have Parquet format", (Object)Formats.PARQUET, (Object)descriptor.getFormat());
        Assert.assertEquals((String)"Should be partitioned by part=int", (Object)strategy, (Object)descriptor.getPartitionStrategy());
    }

    @Test
    public void testIncompatibleSchemaFilesInSeparateFolders() throws Exception {
        DatasetDescriptor events;
        DatasetDescriptor users;
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, new Path(parent, "part=1"));
        this.createAvroEventFile(fs, new Path(parent, "part=2"));
        Collection descriptors = FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root);
        Assert.assertEquals((String)"Should have 2 descriptors", (long)2L, (long)descriptors.size());
        DatasetDescriptor first = (DatasetDescriptor)Iterables.getFirst((Iterable)descriptors, null);
        if (first.getLocation().toString().contains("part=1")) {
            users = first;
            events = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        } else {
            events = first;
            users = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        }
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)users.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)new Path(parent, "part=1").toUri(), (Object)this.parent(users.getLocation()));
        Assert.assertTrue((String)"Should be a .avro file", (boolean)users.getLocation().toString().endsWith(".avro"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)users.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)users.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)users.isPartitioned());
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)events.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)new Path(parent, "part=2").toUri(), (Object)this.parent(events.getLocation()));
        Assert.assertTrue((String)"Should be a .avro file", (boolean)events.getLocation().toString().endsWith(".avro"));
        Assert.assertEquals((String)"Should use event schema", (Object)EVENT_SCHEMA, (Object)events.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)events.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)events.isPartitioned());
    }

    @Test
    public void testIncompatibleSchemaParquetFilesInSeparateFolders() throws Exception {
        DatasetDescriptor events;
        DatasetDescriptor users;
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createParquetUserFile(fs, new Path(parent, "part=1"));
        this.createParquetEventFile(fs, new Path(parent, "part=2"));
        Collection descriptors = FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root);
        Assert.assertEquals((String)"Should have 2 descriptors", (long)2L, (long)descriptors.size());
        DatasetDescriptor first = (DatasetDescriptor)Iterables.getFirst((Iterable)descriptors, null);
        if (first.getLocation().toString().contains("part=1")) {
            users = first;
            events = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        } else {
            events = first;
            users = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        }
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)users.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)new Path(parent, "part=1").toUri(), (Object)this.parent(users.getLocation()));
        Assert.assertTrue((String)"Should be a .parquet file", (boolean)users.getLocation().toString().endsWith(".parquet"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)users.getSchema());
        Assert.assertEquals((String)"Should have Parquet format", (Object)Formats.PARQUET, (Object)users.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)users.isPartitioned());
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)events.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)new Path(parent, "part=2").toUri(), (Object)this.parent(events.getLocation()));
        Assert.assertTrue((String)"Should be a .parquet file", (boolean)events.getLocation().toString().endsWith(".parquet"));
        Assert.assertEquals((String)"Should use event schema", (Object)EVENT_SCHEMA, (Object)events.getSchema());
        Assert.assertEquals((String)"Should have Parquet format", (Object)Formats.PARQUET, (Object)events.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)events.isPartitioned());
    }

    @Test
    public void testIncompatibleFormatFilesInSameFolder() throws Exception {
        DatasetDescriptor parquet;
        DatasetDescriptor avro;
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createAvroUserFile(fs, parent);
        this.createParquetUserFile(fs, parent);
        Collection descriptors = FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root);
        Assert.assertEquals((String)"Should have 2 descriptors", (long)2L, (long)descriptors.size());
        DatasetDescriptor first = (DatasetDescriptor)Iterables.getFirst((Iterable)descriptors, null);
        if (first.getFormat() == Formats.AVRO) {
            avro = first;
            parquet = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        } else {
            parquet = first;
            avro = (DatasetDescriptor)Iterables.getLast((Iterable)descriptors, null);
        }
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)avro.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)this.parent(avro.getLocation()));
        Assert.assertTrue((String)"Should be a .avro file", (boolean)avro.getLocation().toString().endsWith(".avro"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)avro.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.AVRO, (Object)avro.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)avro.isPartitioned());
        Assert.assertFalse((String)"Should not flag at mixed depth", (boolean)parquet.hasProperty("kite.filesystem.mixed-depth"));
        Assert.assertEquals((String)"Should be directly under parent", (Object)parent.toUri(), (Object)this.parent(parquet.getLocation()));
        Assert.assertTrue((String)"Should be a .parquet file", (boolean)parquet.getLocation().toString().endsWith(".parquet"));
        Assert.assertEquals((String)"Should use user schema", (Object)USER_SCHEMA, (Object)parquet.getSchema());
        Assert.assertEquals((String)"Should have Avro format", (Object)Formats.PARQUET, (Object)parquet.getFormat());
        Assert.assertFalse((String)"Should not be partitioned", (boolean)parquet.isPartitioned());
    }

    @Test
    public void testSingleUnknownFile() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createUnknownFile(fs, parent);
        ArrayList expected = Lists.newArrayList();
        Assert.assertEquals((String)"Should succeed and find no datasets", (Object)expected, (Object)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
    }

    @Test
    public void testMultipleUnknownFiles() throws Exception {
        File folder = this.temp.newFolder(new String[]{"a/b/c/d/e"});
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        Path parent = new Path(folder.toURI());
        this.createUnknownFile(fs, parent);
        this.createUnknownFile(fs, parent);
        ArrayList expected = Lists.newArrayList();
        Assert.assertEquals((String)"Should succeed and find no datasets", (Object)expected, (Object)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
    }

    @Test
    public void testEmptyDirectory() throws IOException {
        Path root = new Path(this.temp.getRoot().toURI());
        FileSystem fs = LocalFileSystem.getInstance();
        ArrayList expected = Lists.newArrayList();
        Assert.assertEquals((String)"Should succeed and find no datasets", (Object)expected, (Object)FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root));
    }

    @Test
    public void testMissingDirectory() throws IOException {
        final Path root = new Path(new Path(this.temp.getRoot().toURI()), "not_there");
        final FileSystem fs = LocalFileSystem.getInstance();
        TestHelpers.assertThrows("Should propagate missing file IOException", FileNotFoundException.class, new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                FileSystemUtil.findPotentialDatasets((FileSystem)fs, (Path)root);
                return null;
            }
        });
    }

    private URI parent(URI file) {
        return new Path(file).getParent().toUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUserToDataset(Dataset<GenericRecord> dataset) {
        DatasetWriter writer = null;
        try {
            writer = dataset.newWriter();
            writer.write((Object)USER);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void createAvroUserFile(FileSystem fs, Path parent) throws IOException {
        Path file = new Path(parent, UUID.randomUUID().toString() + ".avro");
        AvroAppender appender = new AvroAppender(fs, file, USER_SCHEMA, CompressionType.Uncompressed);
        appender.open();
        appender.append((Object)USER);
        appender.close();
    }

    public void createAvroEventFile(FileSystem fs, Path parent) throws IOException {
        Path file = new Path(parent, UUID.randomUUID().toString() + ".avro");
        AvroAppender appender = new AvroAppender(fs, file, EVENT_SCHEMA, CompressionType.Uncompressed);
        appender.open();
        appender.append((Object)EVENT);
        appender.close();
    }

    public void createParquetUserFile(FileSystem fs, Path parent) throws IOException {
        Path file = new Path(parent, UUID.randomUUID().toString() + ".parquet");
        ParquetAppender appender = new ParquetAppender(fs, file, USER_SCHEMA, new Configuration(), CompressionType.Uncompressed);
        appender.open();
        appender.append((IndexedRecord)USER);
        appender.close();
    }

    public void createParquetEventFile(FileSystem fs, Path parent) throws IOException {
        Path file = new Path(parent, UUID.randomUUID().toString() + ".parquet");
        ParquetAppender appender = new ParquetAppender(fs, file, EVENT_SCHEMA, new Configuration(), CompressionType.Uncompressed);
        appender.open();
        appender.append((IndexedRecord)EVENT);
        appender.close();
    }

    public void createUnknownFile(FileSystem fs, Path parent) throws IOException {
        Path file = new Path(parent, UUID.randomUUID().toString() + ".unknown");
        fs.create(file);
    }
}

