/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemMetadataProvider;
import org.kitesdk.data.spi.filesystem.Loader;

public class TestFileSystemRepositoryURIs
extends MiniDFSTest {
    @BeforeClass
    public static void loadImpl() {
        new Loader().load();
    }

    @Test
    public void testLocalRelative() throws URISyntaxException {
        URI repositoryUri = new URI("repo:file:target/dsr-repo-test");
        DatasetRepository repository = DatasetRepositories.repositoryFor((URI)repositoryUri);
        Assert.assertNotNull((String)"Received a repository", (Object)repository);
        Assert.assertTrue((String)"Repo is a FileSystem repo", (boolean)(repository instanceof FileSystemDatasetRepository));
        MetadataProvider provider = ((FileSystemDatasetRepository)repository).getMetadataProvider();
        Assert.assertTrue((String)"Repo is using a FileSystemMetadataProvider", (boolean)(provider instanceof FileSystemMetadataProvider));
        FileSystemMetadataProvider fsProvider = (FileSystemMetadataProvider)provider;
        Assert.assertTrue((String)"FileSystem is a LocalFileSystem", (boolean)(fsProvider.getFileSytem() instanceof LocalFileSystem));
        Path expected = fsProvider.getFileSytem().makeQualified(new Path("target/dsr-repo-test"));
        Assert.assertEquals((String)"Root directory should be the correct qualified path", (Object)expected, (Object)fsProvider.getRootDirectory());
        Assert.assertEquals((String)"Repository URI scheme", (Object)"repo", (Object)repository.getUri().getScheme());
        Assert.assertEquals((String)"Repository URI scheme", (Object)expected.toUri(), (Object)new URI(repository.getUri().getSchemeSpecificPart()));
    }

    @Test
    public void testLocalAbsolute() throws URISyntaxException {
        URI repositoryUri = new URI("repo:file:///tmp/dsr-repo-test");
        DatasetRepository repository = DatasetRepositories.repositoryFor((URI)repositoryUri);
        FileSystemMetadataProvider provider = (FileSystemMetadataProvider)((FileSystemDatasetRepository)repository).getMetadataProvider();
        Assert.assertEquals((String)"Root directory should be the correct qualified path", (Object)new Path("file:/tmp/dsr-repo-test"), (Object)provider.getRootDirectory());
        Assert.assertEquals((String)"Repository URI", (Object)repositoryUri, (Object)repository.getUri());
    }

    @Test(expected=DatasetIOException.class)
    public void testHdfsFailsDefault() {
        DatasetRepositories.repositoryFor((String)"repo:hdfs:/");
    }

    @Test
    public void testHdfsAbsolute() throws URISyntaxException {
        URI hdfsUri = TestFileSystemRepositoryURIs.getDFS().getUri();
        URI repositoryUri = new URI("repo:hdfs://" + hdfsUri.getAuthority() + "/tmp/dsr-repo-test");
        DatasetRepository repository = DatasetRepositories.repositoryFor((URI)repositoryUri);
        Assert.assertNotNull((String)"Received a repository", (Object)repository);
        Assert.assertTrue((String)"Repo is a FileSystem repo", (boolean)(repository instanceof FileSystemDatasetRepository));
        MetadataProvider provider = ((FileSystemDatasetRepository)repository).getMetadataProvider();
        Assert.assertTrue((String)"Repo is using a FileSystemMetadataProvider", (boolean)(provider instanceof FileSystemMetadataProvider));
        FileSystemMetadataProvider fsProvider = (FileSystemMetadataProvider)provider;
        Assert.assertTrue((String)"FileSystem is a DistributedFileSystem", (boolean)(fsProvider.getFileSytem() instanceof DistributedFileSystem));
        Path expected = fsProvider.getFileSytem().makeQualified(new Path("/tmp/dsr-repo-test"));
        Assert.assertEquals((String)"Root directory should be the correct qualified path", (Object)expected, (Object)fsProvider.getRootDirectory());
        Assert.assertEquals((String)"Repository URI", (Object)repositoryUri, (Object)repository.getUri());
    }
}

