/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.PartitionView;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionView;

public class TestFileSystemPartitionView {
    private FileSystemDataset<TestRecord> unpartitioned = null;
    private FileSystemDataset<TestRecord> partitioned = null;

    @Before
    public void createTestDatasets() {
        Datasets.delete((String)"dataset:file:/tmp/datasets/unpartitioned");
        Datasets.delete((String)"dataset:file:/tmp/datasets/partitioned");
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(TestRecord.class).build();
        this.unpartitioned = (FileSystemDataset)Datasets.create((String)"dataset:file:/tmp/datasets/unpartitioned", (DatasetDescriptor)descriptor, TestRecord.class);
        descriptor = new DatasetDescriptor.Builder(descriptor).partitionStrategy(new PartitionStrategy.Builder().hash("id", 4).build()).build();
        this.partitioned = (FileSystemDataset)Datasets.create((String)"dataset:file:/tmp/datasets/partitioned", (DatasetDescriptor)descriptor, TestRecord.class);
        TestFileSystemPartitionView.writeTestRecords(this.unpartitioned);
        TestFileSystemPartitionView.writeTestRecords(this.partitioned);
    }

    @After
    public void removeTestDatasets() {
        Datasets.delete((String)"dataset:file:/tmp/datasets/unpartitioned");
        Datasets.delete((String)"dataset:file:/tmp/datasets/partitioned");
    }

    @Test
    public void testFullPaths() {
        FileSystemPartitionView partition = this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned"));
        Assert.assertEquals((String)"Should accept a full root URI", (Object)URI.create("file:/tmp/datasets/partitioned"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a null relative URI", null, (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(new Path("file:/tmp/datasets/partitioned"));
        Assert.assertEquals((String)"Should accept a full root Path", (Object)URI.create("file:/tmp/datasets/partitioned"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a null relative Path", null, (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=0"));
        Assert.assertEquals((String)"Should accept a full sub-partition URI", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a correct relative URI", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(new Path("file:/tmp/datasets/partitioned/id_hash=0"));
        Assert.assertEquals((String)"Should accept a full sub-partition Path", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a correct relative Path", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(URI.create("/tmp/datasets/partitioned/id_hash=0"));
        Assert.assertEquals((String)"Should accept a schemeless URI", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a correct relative URI", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(new Path("/tmp/datasets/partitioned/id_hash=0"));
        Assert.assertEquals((String)"Should accept a schemeless Path", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a correct relative Path", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/"));
        Assert.assertEquals((String)"Should strip trailing slash from full URI", (Object)URI.create("file:/tmp/datasets/partitioned"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should should strip trailing slash from relative URI", null, (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=0/"));
        Assert.assertEquals((String)"Should strip trailing slash from full URI", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should should strip trailing slash from relative URI", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=5"));
        Assert.assertEquals((String)"Should accept non-existent full URI", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=5"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should should have correct non-existent relative URI", (Object)URI.create("id_hash=5"), (Object)partition.getRelativeLocation());
        TestHelpers.assertThrows("Should reject paths not in the dataset", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemPartitionView.this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/unpartitioned"));
            }
        });
        TestHelpers.assertThrows("Should reject paths not in the dataset", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemPartitionView.this.partitioned.getPartitionView(URI.create("file:/tmp/datasets"));
            }
        });
        TestHelpers.assertThrows("Should reject paths in other file systems", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemPartitionView.this.partitioned.getPartitionView(URI.create("hdfs:/tmp/datasets/partitioned"));
            }
        });
        TestHelpers.assertThrows("Should reject paths deeper than partitions", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemPartitionView.this.partitioned.getPartitionView(URI.create("hdfs:/tmp/datasets/partitioned/id_hash=0/data_hash=2"));
            }
        });
        TestHelpers.assertThrows("Should reject invalid paths", NumberFormatException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemPartitionView.this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=trees"));
            }
        });
    }

    @Test
    public void testRelativePaths() {
        FileSystemPartitionView partition = this.partitioned.getPartitionView(URI.create("id_hash=0"));
        Assert.assertEquals((String)"Should accept a relative URI", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have a the same relative URI", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView(new Path("id_hash=0"));
        Assert.assertEquals((String)"Should accept a relative Path", (Object)URI.create("file:/tmp/datasets/partitioned/id_hash=0"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have the an equivalent relative Path", (Object)URI.create("id_hash=0"), (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView((URI)null);
        Assert.assertEquals((String)"Should accept a null URI", (Object)URI.create("file:/tmp/datasets/partitioned"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have the an equivalent relative URI", null, (Object)partition.getRelativeLocation());
        partition = this.partitioned.getPartitionView((Path)null);
        Assert.assertEquals((String)"Should accept a null Path", (Object)URI.create("file:/tmp/datasets/partitioned"), (Object)partition.getLocation());
        Assert.assertEquals((String)"Should have the an equivalent relative Path", null, (Object)partition.getRelativeLocation());
        TestHelpers.assertThrows("Should reject empty Path", NumberFormatException.class, new Runnable(){

            @Override
            public void run() {
                TestFileSystemPartitionView.this.partitioned.getPartitionView(URI.create(""));
            }
        });
    }

    @Test
    public void testCoveringPartitions() {
        Iterable partitions = this.unpartitioned.getCoveringPartitions();
        Assert.assertEquals((String)"Should have a single partition view at the root", (Object)this.unpartitioned.getPartitionView(URI.create("file:/tmp/datasets/unpartitioned")), (Object)Iterables.getOnlyElement((Iterable)partitions));
        partitions = this.partitioned.getCoveringPartitions();
        HashSet expected = Sets.newHashSet();
        expected.add(this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=0")));
        expected.add(this.partitioned.getPartitionView(new Path("file:/tmp/datasets/partitioned/id_hash=1")));
        expected.add(this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=2")));
        expected.add(this.partitioned.getPartitionView(new Path("file:/tmp/datasets/partitioned/id_hash=3")));
        Assert.assertEquals((String)"Should have a partition view for each partition", (Object)expected, (Object)Sets.newHashSet((Iterable)partitions));
        FileSystemPartitionView partition0 = this.partitioned.getPartitionView(URI.create("file:/tmp/datasets/partitioned/id_hash=0"));
        partition0.deleteAll();
        expected.remove(partition0);
        Assert.assertEquals((String)"Should have a partition view for each partition", (Object)expected, (Object)Sets.newHashSet((Iterable)partitions));
    }

    @Test
    public void testDeletePartitions() {
        Iterable partitions = this.partitioned.getCoveringPartitions();
        HashSet expected = Sets.newHashSet((Iterable)partitions);
        for (PartitionView partition : partitions) {
            Assert.assertTrue((String)"Should delete data", (boolean)partition.deleteAll());
            expected.remove(partition);
            HashSet actual = Sets.newHashSet((Iterable)this.partitioned.getCoveringPartitions());
            Assert.assertEquals((String)"Should only list remaining partitions", (Object)expected, (Object)actual);
        }
        for (PartitionView partition : partitions) {
            Assert.assertFalse((String)"Should indicate no data was present", (boolean)partition.deleteAll());
        }
    }

    @Test
    public void testRestrictedRead() throws IOException {
        FileSystemPartitionView partition0 = this.partitioned.getPartitionView(URI.create("id_hash=0"));
        FileSystemPartitionView partition1 = this.partitioned.getPartitionView(URI.create("id_hash=1"));
        FileSystemPartitionView partition2 = this.partitioned.getPartitionView(URI.create("id_hash=2"));
        FileSystemPartitionView partition3 = this.partitioned.getPartitionView(URI.create("id_hash=3"));
        int count0 = DatasetTestUtilities.materialize(partition0).size();
        int total = DatasetTestUtilities.materialize(this.partitioned).size();
        Assert.assertTrue((String)"Should read some records", (count0 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should not read the entire dataset", (count0 < total ? 1 : 0) != 0);
        FileSystem local = LocalFileSystem.getInstance();
        local.rename(new Path(partition1.getLocation()), new Path(this.partitioned.getDirectory(), "0"));
        local.rename(new Path(partition2.getLocation()), new Path(this.partitioned.getDirectory(), "hash=0"));
        local.rename(new Path(partition3.getLocation()), new Path(this.partitioned.getDirectory(), "id_hash=00"));
        int newCount0 = DatasetTestUtilities.materialize(partition0).size();
        Assert.assertEquals((String)"Should match original count", (long)count0, (long)newCount0);
        int countByConstraints = DatasetTestUtilities.materialize(partition0.toConstraintsView()).size();
        Assert.assertEquals((String)"Should match total count", (long)total, (long)countByConstraints);
    }

    @Test
    public void testRestrictedDelete() throws IOException {
        FileSystemPartitionView partition0 = this.partitioned.getPartitionView(URI.create("id_hash=0"));
        FileSystemPartitionView partition1 = this.partitioned.getPartitionView(URI.create("id_hash=1"));
        FileSystemPartitionView partition2 = this.partitioned.getPartitionView(URI.create("id_hash=2"));
        FileSystemPartitionView partition3 = this.partitioned.getPartitionView(URI.create("id_hash=3"));
        int count0 = DatasetTestUtilities.materialize(partition0).size();
        int total = DatasetTestUtilities.materialize(this.partitioned).size();
        Assert.assertTrue((String)"Should read some records", (count0 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should not read the entire dataset", (count0 < total ? 1 : 0) != 0);
        FileSystem local = LocalFileSystem.getInstance();
        local.rename(new Path(partition1.getLocation()), new Path(this.partitioned.getDirectory(), "0"));
        local.rename(new Path(partition2.getLocation()), new Path(this.partitioned.getDirectory(), "hash=0"));
        local.rename(new Path(partition3.getLocation()), new Path(this.partitioned.getDirectory(), "id_hash=00"));
        Assert.assertEquals((String)"Constraints should match all 4 directories", (long)total, (long)DatasetTestUtilities.materialize(partition0.toConstraintsView()).size());
        partition0.deleteAll();
        int newCount0 = DatasetTestUtilities.materialize(partition0).size();
        Assert.assertEquals((String)"Should have removed all records in id_hash=0", (long)0L, (long)newCount0);
        Assert.assertTrue((String)"Should not have deleted other directories", (boolean)local.exists(new Path(this.partitioned.getDirectory(), "0")));
        Assert.assertTrue((String)"Should not have deleted other directories", (boolean)local.exists(new Path(this.partitioned.getDirectory(), "hash=0")));
        Assert.assertTrue((String)"Should not have deleted other directories", (boolean)local.exists(new Path(this.partitioned.getDirectory(), "id_hash=00")));
        Assert.assertEquals((String)"Should match total without deleted data", (long)(total - count0), (long)DatasetTestUtilities.materialize(partition0.toConstraintsView()).size());
        this.partitioned.unbounded.deleteAll();
        Assert.assertFalse((String)"Should have deleted all other directories", (boolean)local.exists(new Path(this.partitioned.getDirectory(), "0")));
        Assert.assertFalse((String)"Should have deleted all other directories", (boolean)local.exists(new Path(this.partitioned.getDirectory(), "hash=0")));
        Assert.assertFalse((String)"Should have deleted all other directories", (boolean)local.exists(new Path(this.partitioned.getDirectory(), "id_hash=00")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTestRecords(View<TestRecord> view) {
        DatasetWriter writer = null;
        try {
            writer = view.newWriter();
            for (int i = 0; i < 10; ++i) {
                TestRecord record = new TestRecord();
                record.id = i;
                record.data = "test-" + i;
                writer.write((Object)record);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static class TestRecord {
        private long id;
        private String data;
    }
}

