/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.FileSystemPartitionIterator;

@RunWith(value=Parameterized.class)
public class TestFileSystemPartitionIterator
extends MiniDFSTest {
    public FileSystem fileSystem;
    public Path testDirectory;
    public static List<StorageKey> keys;
    public static final PartitionStrategy strategy;
    public static final Constraints emptyConstraints;
    private static final Schema schema;
    public static final long oct_25_2012;
    public static final long oct_24_2013;
    public static final long oct_25_2013;
    public static final long oct_24_2013_end;

    @BeforeClass
    public static void createExpectedKeys() {
        keys = Lists.newArrayList();
        for (Integer year : Arrays.asList(2012, 2013)) {
            for (Integer month : Arrays.asList(9, 10, 11, 12)) {
                for (Integer day : Arrays.asList(22, 24, 25)) {
                    StorageKey k = new StorageKey.Builder(strategy).add("year", (Object)year).add("month", (Object)month).add("day", (Object)day).build();
                    keys.add(k);
                }
            }
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException {
        MiniDFSTest.setupFS();
        Object[][] data = new Object[][]{{TestFileSystemPartitionIterator.getDFS()}, {TestFileSystemPartitionIterator.getFS()}};
        return Arrays.asList(data);
    }

    public TestFileSystemPartitionIterator(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Before
    public void createDirectoryLayout() throws Exception {
        this.testDirectory = this.fileSystem.makeQualified(new Path(Files.createTempDir().getAbsolutePath()));
        for (String year : Arrays.asList("year=2012", "year=2013")) {
            Path yearPath = new Path(this.testDirectory, year);
            for (String month : Arrays.asList("month=09", "month=10", "month=11", "month=12")) {
                Path monthPath = new Path(yearPath, month);
                for (String day : Arrays.asList("day=22", "day=24", "day=25")) {
                    Path dayPath = new Path(monthPath, day);
                    this.fileSystem.mkdirs(dayPath);
                }
            }
        }
    }

    @After
    public void cleanDirectoryLayout() throws Exception {
        this.fileSystem.delete(this.testDirectory, true);
    }

    @Test
    public void testUnbounded() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.toKeyPredicate());
        TestFileSystemPartitionIterator.assertIterableEquals(keys, partitions);
    }

    @Test
    public void testFrom() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.from("timestamp", (Comparable)Long.valueOf(oct_24_2013)).toKeyPredicate());
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(16, 24), partitions);
    }

    @Test
    public void testAfter() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.fromAfter("timestamp", (Comparable)Long.valueOf(oct_24_2013_end)).toKeyPredicate());
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(17, 24), partitions);
    }

    @Test
    public void testTo() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.to("timestamp", (Comparable)Long.valueOf(oct_25_2012)).toKeyPredicate());
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(0, 6), partitions);
    }

    @Test
    public void testBefore() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.toBefore("timestamp", (Comparable)Long.valueOf(oct_25_2012)).toKeyPredicate());
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(0, 5), partitions);
    }

    @Test
    public void testWith() throws Exception {
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)emptyConstraints.with("timestamp", new Object[]{oct_24_2013}).toKeyPredicate());
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(16, 17), partitions);
    }

    @Test
    public void testDayRange() throws Exception {
        Constraints.KeyPredicate predicate = emptyConstraints.from("timestamp", (Comparable)Long.valueOf(oct_24_2013)).to("timestamp", (Comparable)Long.valueOf(oct_24_2013_end)).toKeyPredicate();
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)predicate);
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(16, 17), partitions);
    }

    @Test
    public void testLargerRange() throws Exception {
        Constraints.KeyPredicate predicate = emptyConstraints.from("timestamp", (Comparable)Long.valueOf(oct_25_2012)).to("timestamp", (Comparable)Long.valueOf(oct_24_2013)).toKeyPredicate();
        FileSystemPartitionIterator partitions = new FileSystemPartitionIterator(this.fileSystem, this.testDirectory, strategy, schema, (Predicate)predicate);
        TestFileSystemPartitionIterator.assertIterableEquals(keys.subList(5, 17), partitions);
    }

    public static <T> void assertIterableEquals(Iterable<T> expected, Iterable<T> actualIterable) {
        HashSet expectedSet = Sets.newHashSet(expected);
        for (T actual : actualIterable) {
            Assert.assertTrue((String)("Unexpected record: " + actual), (boolean)expectedSet.remove(actual));
        }
        Assert.assertEquals((String)("Not all expected records were present: " + expectedSet), (long)0L, (long)expectedSet.size());
    }

    static {
        strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        emptyConstraints = new Constraints((Schema)SchemaBuilder.record((String)"Event").fields().requiredLong("timestamp").endRecord(), strategy);
        schema = (Schema)SchemaBuilder.record((String)"Event").fields().requiredLong("id").requiredLong("timestamp").endRecord();
        oct_25_2012 = new DateTime(2012, 10, 25, 0, 0, DateTimeZone.UTC).getMillis();
        oct_24_2013 = new DateTime(2013, 10, 24, 0, 0, DateTimeZone.UTC).getMillis();
        oct_25_2013 = new DateTime(2013, 10, 25, 0, 0, DateTimeZone.UTC).getMillis();
        oct_24_2013_end = oct_25_2013 - 1L;
    }
}

