/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Resources;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetReader;

public class TestFileSystemDatasetReader
extends TestDatasetReaders<GenericData.Record> {
    private FileSystem fileSystem;

    @Override
    public DatasetReader<GenericData.Record> newReader() throws IOException {
        return new FileSystemDatasetReader(LocalFileSystem.getInstance(), new Path(Resources.getResource((String)"data/strings-100.avro").getFile()), DatasetTestUtilities.STRING_SCHEMA, GenericData.Record.class);
    }

    @Override
    public int getTotalRecords() {
        return 100;
    }

    @Override
    public DatasetTestUtilities.RecordValidator<GenericData.Record> getValidator() {
        return new DatasetTestUtilities.RecordValidator<GenericData.Record>(){

            @Override
            public void validate(GenericData.Record record, int recordNum) {
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("text").toString());
            }
        };
    }

    @Before
    public void setUp() throws IOException {
        this.fileSystem = LocalFileSystem.getInstance();
    }

    @Test
    public void testEvolvedSchema() throws IOException {
        Schema schema = (Schema)SchemaBuilder.record((String)"mystring").fields().requiredString("text").name("text2").type().stringType().stringDefault("N/A").endRecord();
        FileSystemDatasetReader reader = new FileSystemDatasetReader(this.fileSystem, new Path(Resources.getResource((String)"data/strings-100.avro").getFile()), schema, GenericData.Record.class);
        DatasetTestUtilities.checkReaderBehavior(reader, 100, new DatasetTestUtilities.RecordValidator<GenericData.Record>(){

            @Override
            public void validate(GenericData.Record record, int recordNum) {
                Assert.assertEquals((Object)String.valueOf(recordNum), (Object)record.get("text").toString());
                Assert.assertEquals((Object)"N/A", (Object)record.get("text2").toString());
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFileSystem() {
        FileSystemDatasetReader reader = new FileSystemDatasetReader(null, new Path("/tmp/does-not-exist.avro"), DatasetTestUtilities.STRING_SCHEMA, String.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullFile() {
        FileSystemDatasetReader reader = new FileSystemDatasetReader(this.fileSystem, null, DatasetTestUtilities.STRING_SCHEMA, String.class);
    }

    @Test(expected=DatasetIOException.class)
    public void testMissingFile() {
        FileSystemDatasetReader reader = new FileSystemDatasetReader(this.fileSystem, new Path("/tmp/does-not-exist.avro"), DatasetTestUtilities.STRING_SCHEMA, String.class);
        Assert.assertNotNull((Object)reader);
        reader.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DatasetIOException.class)
    public void testEmptyFile() throws IOException {
        Path emptyFile = new Path("/tmp/empty-file.avro");
        Assert.assertTrue((String)"Failed to create a new empty file", (boolean)this.fileSystem.createNewFile(emptyFile));
        try {
            FileSystemDatasetReader reader = new FileSystemDatasetReader(this.fileSystem, emptyFile, DatasetTestUtilities.STRING_SCHEMA, String.class);
            Assert.assertNotNull((Object)reader);
            reader.initialize();
        }
        finally {
            Assert.assertTrue((String)"Failed to clean up empty file", (boolean)this.fileSystem.delete(emptyFile, true));
        }
    }
}

