/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;

public class TestDefaultConfigurationFileSystem
extends MiniDFSTest {
    private static final DatasetRepository repo = new FileSystemDatasetRepository.Builder().configuration(TestDefaultConfigurationFileSystem.getConfiguration()).rootDirectory(URI.create("hdfs:/tmp/datasets")).build();

    @Before
    public void createStringsDataset() throws Exception {
        repo.delete("ns", "strings");
        repo.create("ns", "strings", new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build());
    }

    @After
    public void removeStringsDataset() {
        repo.delete("ns", "strings");
    }

    @Test
    public void testFindsHDFS() throws Exception {
        Configuration existing = DefaultConfiguration.get();
        DefaultConfiguration.set((Configuration)TestDefaultConfigurationFileSystem.getConfiguration());
        FileSystemDataset dataset = (FileSystemDataset)Datasets.load((String)"dataset:hdfs:/tmp/datasets/ns/strings");
        Assert.assertNotNull((String)"Dataset should be found", (Object)dataset);
        Assert.assertEquals((String)"Dataset should be located in HDFS", (Object)"hdfs", (Object)dataset.getFileSystem().getUri().getScheme());
        DefaultConfiguration.set((Configuration)existing);
    }

    @Test(expected=DatasetIOException.class)
    public void testCannotFindHDFS() throws Exception {
        Datasets.load((String)"dataset:hdfs:/tmp/datasets/ns/strings");
    }
}

