/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.io.Files;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.PartitionListener;
import org.kitesdk.data.spi.StorageKey;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.kitesdk.data.spi.filesystem.FileSystemMetadataProvider;
import org.kitesdk.data.spi.filesystem.FileSystemView;
import org.kitesdk.data.spi.filesystem.PartitionedDatasetWriter;

public class TestDatasetWriterCacheLoader {
    private Configuration conf;
    private FileSystem fileSystem;
    private Path testDirectory;
    private FileSystemDatasetRepository repo;
    private PartitionStrategy partitionStrategy;
    private FileSystemView<Object> view;

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.fileSystem = FileSystem.get((Configuration)this.conf);
        this.testDirectory = new Path(Files.createTempDir().getAbsolutePath());
        this.repo = new FileSystemDatasetRepository(this.conf, this.testDirectory, (MetadataProvider)new EnusrePartitionPathDoesNotExistMetadataProvider(this.conf, this.testDirectory));
        this.partitionStrategy = new PartitionStrategy.Builder().hash("username", 2).build();
        FileSystemDataset users = (FileSystemDataset)this.repo.create("ns", "users", new DatasetDescriptor.Builder().schema(DatasetTestUtilities.USER_SCHEMA).partitionStrategy(this.partitionStrategy).build());
        this.view = new FileSystemView(users, null, null, Object.class);
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDirectory, true);
    }

    @Test
    public void testInitializeAfterParitionAddedCallback() throws Exception {
        PartitionedDatasetWriter.DatasetWriterCacheLoader loader = new PartitionedDatasetWriter.DatasetWriterCacheLoader(this.view);
        StorageKey key = new StorageKey.Builder(this.partitionStrategy).add("username", (Object)"test1").build();
        loader.load(key);
    }

    @Test
    public void testIncrementatlInitializeAfterParitionAddedCallback() throws Exception {
        PartitionedDatasetWriter.IncrementalDatasetWriterCacheLoader loader = new PartitionedDatasetWriter.IncrementalDatasetWriterCacheLoader(this.view);
        StorageKey key = new StorageKey.Builder(this.partitionStrategy).add("username", (Object)"test1").build();
        loader.load(key);
    }

    private static class EnusrePartitionPathDoesNotExistMetadataProvider
    extends FileSystemMetadataProvider
    implements PartitionListener {
        public EnusrePartitionPathDoesNotExistMetadataProvider(Configuration conf, Path rootDirectory) {
            super(conf, rootDirectory);
        }

        public void partitionAdded(String namespace, String name, String partition) {
            Path root = this.getRootDirectory();
            Path partitionPath = new Path(FileSystemDatasetRepository.pathForDataset((Path)root, (String)namespace, (String)name), partition);
            try {
                Assert.assertFalse((String)("Partition path " + partitionPath + " does not exist"), (boolean)this.getFileSytem().exists(partitionPath));
            }
            catch (IOException ex) {
                Assert.fail((String)ex.getMessage());
            }
        }

        public void partitionDeleted(String namespace, String name, String partition) {
        }
    }
}

