/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetRecordException;
import org.kitesdk.data.LocalFileSystem;
import org.kitesdk.data.TestDatasetReaders;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.filesystem.CSVFileReader;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;
import org.kitesdk.data.spi.filesystem.TestBean;
import org.kitesdk.data.spi.filesystem.TestGenericRecord;

public class TestCSVFileReader
extends TestDatasetReaders<GenericData.Record> {
    public static final String CSV_CONTENT = "str,34,2.11,false\r\n\"str,2\",,4,true\nstr3,\"\",null\nstr4,,,";
    public static final String REORDERED_CSV_CONTENT = "myBool,myFloat,myInt,myStr,ignored\nfalse,2.11,34,str,68\r\ntrue,4,,\"str,2\"\ntrue,null,\"\",str3\n,,,str4\n";
    public static final String VALIDATOR_CSV_CONTENT = "id,string,even\n0,a,true\n1,b\n2,c,true\n";
    public static final String TSV_CONTENT = "string\tinteger\tfloat\tbool\rstr\t34\t2.11\tfalse\r\n\"str\t2\"\t\t4\ttrue\nstr3\t\"\"\tnull";
    public static FileSystem localfs = null;
    public static Path csvFile = null;
    public static Path reorderedFile = null;
    public static Path validatorFile = null;
    public static Path tsvFile = null;
    public static Schema STRINGS = (Schema)SchemaBuilder.record((String)"Strings").fields().name("string1").type().stringType().noDefault().name("string2").type().stringType().noDefault().name("string3").type().stringType().noDefault().name("string4").type().stringType().stringDefault("missing value").endRecord();
    public static final Schema VALIDATOR_SCHEMA = (Schema)SchemaBuilder.record((String)"Validator").fields().name("id").type().intType().noDefault().name("string").type().stringType().noDefault().name("even").type().booleanType().booleanDefault(false).endRecord();
    public static Schema BEAN_SCHEMA = (Schema)SchemaBuilder.record((String)TestBean.class.getName()).fields().name("myStr").type().stringType().noDefault().name("myInt").type().intType().intDefault(0).name("myFloat").type().floatType().noDefault().name("myBool").type().booleanType().booleanDefault(false).endRecord();
    public static Schema SCHEMA = (Schema)SchemaBuilder.record((String)"Normal").fields().name("myStr").type().stringType().noDefault().name("myInt").type().intType().intDefault(0).name("myFloat").type().floatType().noDefault().name("myBool").type().booleanType().booleanDefault(false).endRecord();
    public static Schema TYPE_ERROR_SCHEMA = (Schema)SchemaBuilder.record((String)"Normal").fields().name("myString").type().stringType().noDefault().name("myInt").type().intType().intDefault(0).name("myFloat").type().intType().intDefault(34).name("myBool").type().booleanType().booleanDefault(false).endRecord();

    @BeforeClass
    public static void createCSVFiles() throws IOException {
        localfs = LocalFileSystem.getInstance();
        csvFile = new Path("target/temp.csv");
        reorderedFile = new Path("target/reordered.csv");
        tsvFile = new Path("target/temp.tsv");
        validatorFile = new Path("target/validator.csv");
        FSDataOutputStream out = localfs.create(csvFile, true);
        out.writeBytes(CSV_CONTENT);
        out.close();
        out = localfs.create(reorderedFile, true);
        out.writeBytes(REORDERED_CSV_CONTENT);
        out.close();
        out = localfs.create(validatorFile, true);
        out.writeBytes(VALIDATOR_CSV_CONTENT);
        out.close();
        out = localfs.create(tsvFile, true);
        out.writeBytes(TSV_CONTENT);
        out.close();
    }

    @Override
    public DatasetReader<GenericData.Record> newReader() throws IOException {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().property("kite.csv.has-header", "true").schema(VALIDATOR_SCHEMA).build();
        return new CSVFileReader(localfs, validatorFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
    }

    @Override
    public int getTotalRecords() {
        return 3;
    }

    @Override
    public DatasetTestUtilities.RecordValidator<GenericData.Record> getValidator() {
        return new DatasetTestUtilities.RecordValidator<GenericData.Record>(){
            private static final String chars = "abcdef";

            @Override
            public void validate(GenericData.Record record, int recordNum) {
                Assert.assertEquals((Object)recordNum, (Object)record.get("id"));
                Assert.assertEquals((Object)Character.toString(chars.charAt(recordNum)), (Object)record.get("string"));
                Assert.assertEquals((Object)(recordNum % 2 == 0 ? 1 : 0), (Object)record.get("even"));
            }
        };
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonRecordSchemas() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.array().items().stringType()).build();
        new CSVFileReader(localfs, csvFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
    }

    @Test
    public void testStringSchema() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema(STRINGS).build();
        CSVFileReader reader = new CSVFileReader(localfs, csvFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        GenericData.Record rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str", (Object)rec.get(0));
        Assert.assertEquals((Object)"34", (Object)rec.get(1));
        Assert.assertEquals((Object)"2.11", (Object)rec.get(2));
        Assert.assertEquals((Object)"false", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str,2", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"4", (Object)rec.get(2));
        Assert.assertEquals((Object)"true", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str3", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"null", (Object)rec.get(2));
        Assert.assertEquals((Object)"missing value", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str4", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"", (Object)rec.get(2));
        Assert.assertEquals((Object)"", (Object)rec.get(3));
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testTSV() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().property("kite.csv.delimiter", "\t").property("kite.csv.lines-to-skip", "1").schema(STRINGS).build();
        CSVFileReader reader = new CSVFileReader(localfs, tsvFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        GenericData.Record rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str", (Object)rec.get(0));
        Assert.assertEquals((Object)"34", (Object)rec.get(1));
        Assert.assertEquals((Object)"2.11", (Object)rec.get(2));
        Assert.assertEquals((Object)"false", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str\t2", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"4", (Object)rec.get(2));
        Assert.assertEquals((Object)"true", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str3", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"null", (Object)rec.get(2));
        Assert.assertEquals((Object)"missing value", (Object)rec.get(3));
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testTSVWithDeprecatedProperties() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().property("cdk.csv.delimiter", "\t").property("cdk.csv.lines-to-skip", "1").schema(STRINGS).build();
        CSVFileReader reader = new CSVFileReader(localfs, tsvFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        GenericData.Record rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str", (Object)rec.get(0));
        Assert.assertEquals((Object)"34", (Object)rec.get(1));
        Assert.assertEquals((Object)"2.11", (Object)rec.get(2));
        Assert.assertEquals((Object)"false", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str\t2", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"4", (Object)rec.get(2));
        Assert.assertEquals((Object)"true", (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str3", (Object)rec.get(0));
        Assert.assertEquals((Object)"", (Object)rec.get(1));
        Assert.assertEquals((Object)"null", (Object)rec.get(2));
        Assert.assertEquals((Object)"missing value", (Object)rec.get(3));
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testNormalSchema() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema(SCHEMA).build();
        final CSVFileReader reader = new CSVFileReader(localfs, csvFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        GenericData.Record rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str", (Object)rec.get(0));
        Assert.assertEquals((Object)34, (Object)rec.get(1));
        Assert.assertEquals((Object)Float.valueOf(2.11f), (Object)rec.get(2));
        Assert.assertEquals((Object)false, (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str,2", (Object)rec.get(0));
        Assert.assertEquals((Object)0, (Object)rec.get(1));
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)rec.get(2));
        Assert.assertEquals((Object)true, (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about null as a number", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about missing default", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testBadNumericSchema() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema(TYPE_ERROR_SCHEMA).build();
        final CSVFileReader reader = new CSVFileReader(localfs, csvFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should reject float value for integer schema", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
    }

    @Test
    public void testNormalSchemaWithReorderedContent() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().property("kite.csv.has-header", "true").schema(SCHEMA).build();
        final CSVFileReader reader = new CSVFileReader(localfs, reorderedFile, desc, DataModelUtil.accessor(GenericData.Record.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        GenericData.Record rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str", (Object)rec.get(0));
        Assert.assertEquals((Object)34, (Object)rec.get(1));
        Assert.assertEquals((Object)Float.valueOf(2.11f), (Object)rec.get(2));
        Assert.assertEquals((Object)false, (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        rec = (GenericData.Record)reader.next();
        Assert.assertEquals((Object)"str,2", (Object)rec.get(0));
        Assert.assertEquals((Object)0, (Object)rec.get(1));
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)rec.get(2));
        Assert.assertEquals((Object)true, (Object)rec.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about null as a number", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about missing default", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testReflectNormalSchemaWithReorderedContent() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().property("kite.csv.has-header", "true").schema(BEAN_SCHEMA).build();
        final CSVFileReader reader = new CSVFileReader(localfs, reorderedFile, desc, DataModelUtil.accessor(TestBean.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        TestBean bean = (TestBean)reader.next();
        Assert.assertEquals((Object)"str", (Object)bean.myStr);
        Assert.assertEquals((Object)34, (Object)bean.myInt);
        Assert.assertEquals((Object)Float.valueOf(2.11f), (Object)bean.myFloat);
        Assert.assertEquals((Object)false, (Object)bean.myBool);
        Assert.assertTrue((boolean)reader.hasNext());
        bean = (TestBean)reader.next();
        Assert.assertEquals((Object)"str,2", (Object)bean.myStr);
        Assert.assertEquals(null, (Object)bean.myInt);
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)bean.myFloat);
        Assert.assertEquals((Object)true, (Object)bean.myBool);
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about null as a number", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertTrue((boolean)reader.hasNext());
        bean = (TestBean)reader.next();
        Assert.assertEquals((Object)"str4", (Object)bean.myStr);
        Assert.assertEquals(null, (Object)bean.myInt);
        Assert.assertEquals(null, (Object)bean.myFloat);
        Assert.assertEquals((Object)false, (Object)bean.myBool);
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testReflectedRecords() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema(BEAN_SCHEMA).build();
        final CSVFileReader reader = new CSVFileReader(localfs, csvFile, desc, DataModelUtil.accessor(TestBean.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        TestBean bean = (TestBean)reader.next();
        Assert.assertEquals((Object)"str", (Object)bean.myStr);
        Assert.assertEquals((Object)34, (Object)bean.myInt);
        Assert.assertEquals((Object)Float.valueOf(2.11f), (Object)bean.myFloat);
        Assert.assertEquals((Object)false, (Object)bean.myBool);
        Assert.assertTrue((boolean)reader.hasNext());
        bean = (TestBean)reader.next();
        Assert.assertEquals((Object)"str,2", (Object)bean.myStr);
        Assert.assertEquals(null, (Object)bean.myInt);
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)bean.myFloat);
        Assert.assertEquals((Object)true, (Object)bean.myBool);
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about null as a number", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertTrue((boolean)reader.hasNext());
        bean = (TestBean)reader.next();
        Assert.assertEquals((Object)"str4", (Object)bean.myStr);
        Assert.assertEquals(null, (Object)bean.myInt);
        Assert.assertEquals(null, (Object)bean.myFloat);
        Assert.assertEquals((Object)false, (Object)bean.myBool);
        Assert.assertFalse((boolean)reader.hasNext());
    }

    @Test
    public void testCustomGenericRecords() {
        DatasetDescriptor desc = new DatasetDescriptor.Builder().schema(SCHEMA).build();
        final CSVFileReader reader = new CSVFileReader(localfs, csvFile, desc, DataModelUtil.accessor(TestGenericRecord.class, (Schema)desc.getSchema()));
        reader.initialize();
        Assert.assertTrue((boolean)reader.hasNext());
        TestGenericRecord record = (TestGenericRecord)((Object)reader.next());
        Assert.assertEquals((Object)"str", (Object)record.get(0));
        Assert.assertEquals((Object)34, (Object)record.get(1));
        Assert.assertEquals((Object)Float.valueOf(2.11f), (Object)record.get(2));
        Assert.assertEquals((Object)false, (Object)record.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        record = (TestGenericRecord)((Object)reader.next());
        Assert.assertEquals((Object)"str,2", (Object)record.get(0));
        Assert.assertEquals((Object)0, (Object)record.get(1));
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)record.get(2));
        Assert.assertEquals((Object)true, (Object)record.get(3));
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about null as a number", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertTrue((boolean)reader.hasNext());
        TestHelpers.assertThrows("Should complain about missing default", DatasetRecordException.class, new Runnable(){

            @Override
            public void run() {
                reader.next();
            }
        });
        Assert.assertFalse((boolean)reader.hasNext());
    }
}

