/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.filesystem.CSVAppender;
import org.kitesdk.data.spi.filesystem.CSVFileReader;

public class TestCSVAppender
extends MiniDFSTest {
    private static final Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().requiredInt("id").requiredString("email").endRecord();

    @Test
    public void testCSVSyncDFS() throws Exception {
        int i;
        String auth = TestCSVAppender.getDFS().getUri().getAuthority();
        FileSystem fs = TestCSVAppender.getDFS();
        Path path = new Path("hdfs://" + auth + "/tmp/test.csv");
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).build();
        CSVAppender appender = new CSVAppender(fs, path, descriptor);
        GenericData.Record record = new GenericData.Record(schema);
        appender.open();
        for (i = 0; i < 10; ++i) {
            record.put("id", (Object)i);
            record.put("email", (Object)(Integer.toString(i) + "@example.com"));
            appender.append((Object)record);
        }
        Assert.assertEquals((String)"Should not find records before flush", (long)0L, (long)this.count(fs, path, descriptor));
        appender.flush();
        appender.sync();
        Assert.assertEquals((String)"Should find the first 10 records", (long)10L, (long)this.count(fs, path, descriptor));
        for (i = 10; i < 20; ++i) {
            record.put("id", (Object)i);
            record.put("email", (Object)(Integer.toString(i) + "@example.com"));
            appender.append((Object)record);
        }
        Assert.assertEquals((String)"Newly written records should still be buffered", (long)10L, (long)this.count(fs, path, descriptor));
        appender.close();
        appender.cleanup();
        Assert.assertEquals((String)"All records should be found after close", (long)20L, (long)this.count(fs, path, descriptor));
    }

    @Test
    @Ignore(value="LocalFileSystem is broken!?")
    public void testCSVSyncLocalFS() throws Exception {
        int i;
        FileSystem fs = TestCSVAppender.getFS();
        Path path = new Path("file:/tmp/test.csv");
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).build();
        CSVAppender appender = new CSVAppender(fs, path, descriptor);
        GenericData.Record record = new GenericData.Record(schema);
        appender.open();
        for (i = 0; i < 10; ++i) {
            record.put("id", (Object)i);
            record.put("email", (Object)(Integer.toString(i) + "@example.com"));
            appender.append((Object)record);
        }
        Assert.assertEquals((String)"Should not find records before flush", (long)0L, (long)this.count(fs, path, descriptor));
        appender.flush();
        appender.sync();
        Assert.assertEquals((String)"Should find the first 10 records", (long)10L, (long)this.count(fs, path, descriptor));
        for (i = 10; i < 20; ++i) {
            record.put("id", (Object)i);
            record.put("email", (Object)(Integer.toString(i) + "@example.com"));
            appender.append((Object)record);
        }
        Assert.assertEquals((String)"Newly written records should still be buffered", (long)10L, (long)this.count(fs, path, descriptor));
        appender.close();
        appender.cleanup();
        Assert.assertEquals((String)"All records should be found after close", (long)20L, (long)this.count(fs, path, descriptor));
    }

    public int count(FileSystem fs, Path path, DatasetDescriptor descriptor) {
        CSVFileReader reader = new CSVFileReader(fs, path, descriptor, DataModelUtil.accessor(GenericRecord.class, (Schema)descriptor.getSchema()));
        int count = 0;
        reader.initialize();
        for (GenericRecord r : reader) {
            ++count;
            System.err.println(r);
        }
        reader.close();
        return count;
    }
}

