/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Flushable;
import org.kitesdk.data.Syncable;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetReader;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.data.spi.filesystem.PathFilters;
import org.kitesdk.data.spi.filesystem.TestFileSystemWriters;

public class TestAvroWriter
extends TestFileSystemWriters {
    @Override
    public FileSystemWriter<GenericData.Record> newWriter(Path directory, Schema schema) {
        return FileSystemWriter.newWriter((FileSystem)this.fs, (Path)directory, (DatasetDescriptor)new DatasetDescriptor.Builder().schema(schema).format("avro").build());
    }

    @Override
    public DatasetReader<GenericData.Record> newReader(Path path, Schema schema) {
        return new FileSystemDatasetReader(this.fs, path, schema, GenericData.Record.class);
    }

    @Test
    public void testIsFlushable() {
        Assert.assertTrue((boolean)(this.fsWriter instanceof Flushable));
    }

    @Test
    public void testIsSyncable() {
        Assert.assertTrue((boolean)(this.fsWriter instanceof Syncable));
    }

    @Test
    public void testCommitFlushedRecords() throws IOException {
        long i;
        TestAvroWriter.init(this.fsWriter);
        ArrayList written = Lists.newArrayList();
        for (i = 0L; i < 10000L; ++i) {
            GenericData.Record record = TestAvroWriter.record(i, "test-" + i);
            this.fsWriter.write((Object)record);
            written.add(record);
        }
        ((Flushable)this.fsWriter).flush();
        for (i = 10000L; i < 11000L; ++i) {
            this.fsWriter.write((Object)TestAvroWriter.record(i, "test-" + i));
        }
        this.fsWriter.state = ReaderWriterState.ERROR;
        this.fsWriter.close();
        FileStatus[] stats = this.fs.listStatus(this.testDirectory, PathFilters.notHidden());
        Assert.assertEquals((String)"Should contain a visible data file", (long)1L, (long)stats.length);
        DatasetReader<GenericData.Record> reader = this.newReader(stats[0].getPath(), TEST_SCHEMA);
        Assert.assertEquals((String)"Should match written records", (Object)written, (Object)Lists.newArrayList((Iterator)((Iterator)TestAvroWriter.init(reader))));
    }
}

