/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.net.URI;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.View;

public class TestViewUris {
    private static final Schema SCHEMA = (Schema)SchemaBuilder.record((String)"Event").fields().requiredString("id").requiredLong("timestamp").requiredString("color").endRecord();
    private static final PartitionStrategy STRATEGY = new PartitionStrategy.Builder().hash("id", "id_hash", 64).year("timestamp").month("timestamp").day("timestamp").identity("id").build();
    private static Dataset<GenericRecord> test;

    @BeforeClass
    public static void createTestDataset() {
        Datasets.delete((String)"dataset:file:/tmp/test_name");
        test = (Dataset)Datasets.create((String)"dataset:file:/tmp/test_name", (DatasetDescriptor)new DatasetDescriptor.Builder().schema(SCHEMA).partitionStrategy(STRATEGY).build());
    }

    @Test
    public void testSimpleViews() {
        this.assertViewUriEquivalent("dataset", "dataset:file:/tmp/test_name", (View<GenericRecord>)test);
        this.assertViewUriEquivalent("to constraint", "view:file:/tmp/test_name?timestamp=(,0]", (View<GenericRecord>)test.to("timestamp", (Comparable)Long.valueOf(0L)));
        this.assertViewUriEquivalent("View with toBefore constraint", "view:file:/tmp/test_name?timestamp=(,0)", (View<GenericRecord>)test.toBefore("timestamp", (Comparable)Long.valueOf(0L)));
        this.assertViewUriEquivalent("View with from constraint", "view:file:/tmp/test_name?timestamp=[0,)", (View<GenericRecord>)test.from("timestamp", (Comparable)Long.valueOf(0L)));
        this.assertViewUriEquivalent("View with fromAfter constraint", "view:file:/tmp/test_name?timestamp=(0,)", (View<GenericRecord>)test.fromAfter("timestamp", (Comparable)Long.valueOf(0L)));
        this.assertViewUriEquivalent("View with in(\"\") constraint", "view:file:/tmp/test_name?color=in()", (View<GenericRecord>)test.with("color", new Object[]{""}));
        this.assertViewUriEquivalent("View with in constraint", "view:file:/tmp/test_name?color=orange,red", (View<GenericRecord>)test.with("color", new Object[]{"orange", "red"}));
        this.assertViewUriEquivalent("View with exists constraint", "view:file:/tmp/test_name?id=", (View<GenericRecord>)test.with("id", new Object[0]));
    }

    @Test
    public void testBoundedRangeViews() {
        this.assertViewUriEquivalent("[a,b]", "view:file:/tmp/test_name?id=[a,b]", (View<GenericRecord>)test.from("id", (Comparable)((Object)"a")).to("id", (Comparable)((Object)"b")));
        this.assertViewUriEquivalent("[a,b)", "view:file:/tmp/test_name?id=[a,b)", (View<GenericRecord>)test.from("id", (Comparable)((Object)"a")).toBefore("id", (Comparable)((Object)"b")));
        this.assertViewUriEquivalent("(a,b]", "view:file:/tmp/test_name?id=(a,b]", (View<GenericRecord>)test.fromAfter("id", (Comparable)((Object)"a")).to("id", (Comparable)((Object)"b")));
        this.assertViewUriEquivalent("(a,b)", "view:file:/tmp/test_name?id=(a,b)", (View<GenericRecord>)test.fromAfter("id", (Comparable)((Object)"a")).toBefore("id", (Comparable)((Object)"b")));
    }

    @Test
    public void testMixedConstraintViews() {
        this.assertViewUriEquivalent("id, color, and time constraints", "view:file:/tmp/test_name?color=,orange&id=exists()&timestamp=[0,9)", (View<GenericRecord>)test.with("color", new Object[]{"", "orange"}).with("id", new Object[0]).from("timestamp", (Comparable)Long.valueOf(0L)).toBefore("timestamp", (Comparable)Long.valueOf(9L)));
    }

    @Test
    public void testConstraintWithEncodedCharacters() {
        this.assertViewUriEquivalent("encoded constraints", "view:file:/tmp/test_name?color=a%2Fb", (View<GenericRecord>)test.with("color", new Object[]{"a/b"}));
    }

    @Test
    public void testMultiValueConstraintWithEncodedCharacters() {
        this.assertViewUriEquivalent("encoded multi-value constraints", "view:file:/tmp/test_name?color=a%2Cb,c", (View<GenericRecord>)test.with("color", new Object[]{"a,b", "c"}));
    }

    @Test
    public void testURIStringEquality() {
        for (int i = 0; i < 10; ++i) {
            View view;
            String afterUri;
            String a = UUID.randomUUID().toString();
            String b = UUID.randomUUID().toString();
            String originalUri = "view:file:/tmp/test_name?color=" + a + "," + b;
            if (!originalUri.equals(afterUri = (view = Datasets.load((String)originalUri)).getUri().toString())) {
                System.out.println("Iteration: " + i);
                System.out.println("Start: " + originalUri);
                System.out.println("End  : " + afterUri);
            }
            Assert.assertEquals((Object)originalUri, (Object)afterUri);
        }
    }

    public void assertViewUriEquivalent(String desc, String uri, View<GenericRecord> view) {
        View loaded = Datasets.load((String)uri);
        Assert.assertEquals((String)("URI should produce the correct View (" + desc + ")"), view, (Object)loaded);
        URI loadedUri = loaded.getUri();
        View reloaded = Datasets.load((URI)loadedUri);
        Assert.assertEquals((String)("Loaded URI should also load correctly (" + desc + ")"), view, (Object)reloaded);
        Assert.assertEquals((String)("URI should be consistent after load (" + desc + ")"), (Object)loadedUri, (Object)reloaded.getUri());
    }
}

