/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.URIPattern;

public class TestURIPattern {
    private Map<String, String> expected = null;

    @Before
    public void setup() {
        this.expected = Maps.newHashMap();
    }

    @Test
    public void testNonAbsoluteExactMatch() throws URISyntaxException {
        URIPattern pattern = new URIPattern("hive");
        String uri = "hive";
        Assert.assertTrue((boolean)pattern.matches(uri));
    }

    @Test
    public void testSubURI() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:*sub-uri");
        String uri = "scheme:other-scheme:/path/to/data.avro";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("sub-uri", "other-scheme:/path/to/data.avro");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testStaticMatch() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:static");
        String uri = "scheme:static";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testPathGlob() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:///*path");
        String uri = "file:/path/to/data.avro";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "file");
        this.expected.put("path", "path/to/data.avro");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testPathVariables() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql:/:db/:table");
        String uri = "mysql:/myDB/myTable";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("db", "myDB");
        this.expected.put("table", "myTable");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testEmptyPath() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme://authority");
        String uri = "scheme://real-authority";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("auth:host", "real-authority");
        Assert.assertEquals(this.expected, (Object)actual);
        Assert.assertFalse((boolean)pattern.matches(uri + "/"));
        Assert.assertFalse((boolean)pattern.matches("scheme:/"));
        Assert.assertFalse((boolean)pattern.matches(uri + "/abc"));
        Assert.assertFalse((boolean)pattern.matches(uri + "#fragment"));
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testStaticPathStart() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql:/required/:db/:table");
        String uri = "mysql:/required/myDB/myTable";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("db", "myDB");
        this.expected.put("table", "myTable");
        Assert.assertEquals(this.expected, (Object)actual);
        Assert.assertNull((Object)pattern.getMatch("mysql:/myDB/myTable"));
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testStaticPathMixed() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql:/db/:db/table/:table");
        String uri = "mysql:/db/myDB/table/myTable";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("db", "myDB");
        this.expected.put("table", "myTable");
        Assert.assertEquals(this.expected, (Object)actual);
        Assert.assertNull((Object)pattern.getMatch("mysql:/myDB/myTable"));
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testStaticPathEnd() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql:/:db/:table/wtf");
        String uri = "mysql:/myDB/myTable/wtf";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("db", "myDB");
        this.expected.put("table", "myTable");
        Assert.assertEquals(this.expected, (Object)actual);
        Assert.assertNull((Object)pattern.getMatch("mysql:/myDB/myTable"));
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testIgnoreTrailingSlash() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql:/:db/:table");
        String uri = "mysql:/myDB/myTable/";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("db", "myDB");
        this.expected.put("table", "myTable");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create("mysql:/myDB/myTable"), (Object)constructed);
    }

    @Test
    public void testPathVariablesWithGlob() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql:/:db/:table/*the-rest");
        String uri = "mysql:/myDB/myTable/a/b/c";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("db", "myDB");
        this.expected.put("table", "myTable");
        this.expected.put("the-rest", "a/b/c");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testPathVariablesAfterGlob() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:/*path/:ns/:ds");
        String uri = "file:/a/b/c/namespace/dataset";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "file");
        this.expected.put("ns", "namespace");
        this.expected.put("ds", "dataset");
        this.expected.put("path", "a/b/c");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testOpaquePathVariablesAfterGlob() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:*path/:ns/:ds");
        String uri = "file:a/b/c/namespace/dataset";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "file");
        this.expected.put("ns", "namespace");
        this.expected.put("ds", "dataset");
        this.expected.put("path", "a/b/c");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testPathVariablesBeforeAndAfterGlob() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:/:ns/*path/:ds");
        String uri = "file:/namespace/a/b/c/dataset";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "file");
        this.expected.put("ns", "namespace");
        this.expected.put("ds", "dataset");
        this.expected.put("path", "a/b/c");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testOpaquePathVariablesBeforeAndAfterGlob() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file::ns/*path/:ds");
        String uri = "file:namespace/a/b/c/dataset";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "file");
        this.expected.put("ns", "namespace");
        this.expected.put("ds", "dataset");
        this.expected.put("path", "a/b/c");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testDefaultAuthority() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme://user:pass:w0rd@host:3434/*path");
        String uri = "scheme:/path/to/data.avro";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("auth:host", "host");
        this.expected.put("auth:port", "3434");
        this.expected.put("auth:username", "user");
        this.expected.put("auth:password", "pass:w0rd");
        this.expected.put("path", "path/to/data.avro");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testOverrideAuthority() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme://user:pass:w0rd@host:3434/*path");
        String uri = "scheme://other:3435/path/to/data.avro";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("auth:host", "other");
        this.expected.put("auth:port", "3435");
        this.expected.put("auth:username", "user");
        this.expected.put("auth:password", "pass:w0rd");
        this.expected.put("path", "path/to/data.avro");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testDefaultQueryArgs() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:/*path?custom-option=true&use-ssl=false&encoded=a%2Cb");
        String uri = "scheme:/path/to/data.avro";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("path", "path/to/data.avro");
        this.expected.put("custom-option", "true");
        this.expected.put("use-ssl", "false");
        this.expected.put("encoded", "a%2Cb");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testOpaqueDefaultQueryArgs() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:*path?custom-option=true&use-ssl=false");
        String uri = "scheme:path/to/data.avro";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("path", "path/to/data.avro");
        this.expected.put("custom-option", "true");
        this.expected.put("use-ssl", "false");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testOverrideQueryArgs() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:/*path?custom-option=true&use-ssl=false");
        String uri = "scheme:/path/to/data.avro?use-ssl=true";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("path", "path/to/data.avro");
        this.expected.put("custom-option", "true");
        this.expected.put("use-ssl", "true");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testOpaqueOverrideQueryArgs() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:*path?custom-option=true&use-ssl=false");
        String uri = "scheme:path/to/data.avro?use-ssl=true";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "scheme");
        this.expected.put("path", "path/to/data.avro");
        this.expected.put("custom-option", "true");
        this.expected.put("use-ssl", "true");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testMixed() throws URISyntaxException {
        URIPattern pattern = new URIPattern("mysql://cloudera:cloudera@db-host:3434/:db/:table/*the-rest?custom-option=true&use-ssl=false");
        String uri = "mysql://real-db-host/my-db/my-table?use-ssl=true";
        Assert.assertTrue((boolean)pattern.matches(uri));
        Map actual = pattern.getMatch(uri);
        this.expected.put("uri:scheme", "mysql");
        this.expected.put("auth:host", "real-db-host");
        this.expected.put("auth:port", "3434");
        this.expected.put("auth:username", "cloudera");
        this.expected.put("auth:password", "cloudera");
        this.expected.put("db", "my-db");
        this.expected.put("table", "my-table");
        this.expected.put("custom-option", "true");
        this.expected.put("use-ssl", "true");
        Assert.assertEquals(this.expected, (Object)actual);
        URI constructed = pattern.construct(this.expected);
        Assert.assertEquals((Object)URI.create(uri), (Object)constructed);
    }

    @Test
    public void testConstructMissingOptions() throws URISyntaxException {
        final URIPattern pattern = new URIPattern("scheme:/*path/:name");
        TestHelpers.assertThrows("Should reject missing name", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                HashMap options = Maps.newHashMap();
                options.put("path", "a/b/c");
                pattern.construct((Map)options);
            }
        });
        HashMap options = Maps.newHashMap();
        options.put("name", "table-name");
        URI constructed = pattern.construct((Map)options);
        Assert.assertEquals((Object)URI.create("scheme:/table-name"), (Object)constructed);
    }

    @Test
    public void testNotEnoughPathComponents() throws URISyntaxException {
        URIPattern pattern = new URIPattern("scheme:*path/:ns/:name");
        Assert.assertFalse((boolean)pattern.matches("scheme://host:3434/dataset"));
    }

    @Test
    public void testEmptyGlobs() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:/a/*path");
        Map match = pattern.getMatch("file:/a");
        Assert.assertNotNull((Object)match);
        Assert.assertNull(match.get("path"));
        match = pattern.getMatch("file:/a/");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"", match.get("path"));
        match = pattern.getMatch("file:/a//");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"/", match.get("path"));
        pattern = new URIPattern("file:/a/*path/:dataset");
        match = pattern.getMatch("file:/a//dataset");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"", match.get("path"));
        match = pattern.getMatch("file:/a/dataset");
        Assert.assertNotNull((Object)match);
        Assert.assertNull(match.get("path"));
        pattern = new URIPattern("file:/*path");
        match = pattern.getMatch("file:/");
        Assert.assertNotNull((Object)match);
        Assert.assertNull(match.get("path"));
    }

    @Test
    public void testQueryEncoding() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:/path");
        URI original = URI.create("file:/path?f1=a,b,a%2Cb");
        Map match = pattern.getMatch(original);
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"a,b,a%2Cb", match.get("f1"));
        URI constructed = pattern.construct(match);
        Assert.assertEquals((Object)original, (Object)constructed);
    }

    @Test
    public void testOpaqueQueryEncoding() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:path");
        URI original = URI.create("file:path?f1=a,b,a%2Cb");
        Map match = pattern.getMatch(original);
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"a,b,a%2Cb", match.get("f1"));
        URI constructed = pattern.construct(match);
        Assert.assertEquals((Object)original, (Object)constructed);
    }

    @Test
    public void testPathEncoding() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:/*path");
        URI original = URI.create("file:/a%2Fb/c");
        Map match = pattern.getMatch(original);
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"a%2Fb/c", match.get("path"));
        URI constructed = pattern.construct(match);
        Assert.assertEquals((Object)original, (Object)constructed);
    }

    @Test
    public void testOpaquePathEncoding() throws URISyntaxException {
        URIPattern pattern = new URIPattern("file:*path");
        URI original = URI.create("file:a%2Fb/c");
        Map match = pattern.getMatch(original);
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"a%2Fb/c", match.get("path"));
        URI constructed = pattern.construct(match);
        Assert.assertEquals((Object)original, (Object)constructed);
    }
}

