/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.MiniDFSTest;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.Signalable;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.View;
import org.kitesdk.data.event.StandardEvent;
import org.kitesdk.data.spi.DatasetRepository;

@RunWith(value=Parameterized.class)
public abstract class TestRefinableViews
extends MiniDFSTest {
    protected static final long now = System.currentTimeMillis();
    protected static final StandardEvent event = StandardEvent.newBuilder().setEventInitiator("TestRefinableViews").setEventName("TestEvent").setUserId(0L).setSessionId("session-0").setIp("localhost").setTimestamp(now + 35405168L).build();
    protected static final StandardEvent sepEvent = StandardEvent.newBuilder(event).setTimestamp(1379020547042L).build();
    protected static final StandardEvent octEvent = StandardEvent.newBuilder(event).setTimestamp(1381612547042L).setUserId(1L).build();
    protected static final StandardEvent novEvent = StandardEvent.newBuilder(event).setTimestamp(1384204547042L).build();
    private final boolean distributed;
    protected DatasetRepository repo = null;
    protected Configuration conf = null;
    protected FileSystem fs;
    protected PartitionStrategy strategy = null;
    protected DatasetDescriptor testDescriptor = null;
    protected RefinableView<StandardEvent> unbounded = null;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    protected TestRefinableViews(boolean distributed) {
        this.distributed = distributed;
    }

    public abstract DatasetRepository newRepo();

    @Before
    public void setup() throws Exception {
        this.conf = this.distributed ? MiniDFSTest.getConfiguration() : new Configuration();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.repo = this.newRepo();
        this.strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        this.testDescriptor = new DatasetDescriptor.Builder().schemaUri("resource:standard_event.avsc").partitionStrategy(this.strategy).build();
        this.repo.delete("ns", "test");
        this.unbounded = this.repo.create("ns", "test", this.testDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> void assertContentEquals(Set<E> expected, View<E> view) throws IOException {
        DatasetReader reader = null;
        try {
            reader = view.newReader();
            Assert.assertEquals(expected, (Object)Sets.newHashSet((Iterable)reader));
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)false);
        }
    }

    @Test(expected=ValidationException.class)
    public void testNonExistentField() {
        this.unbounded.with("nosuchfield", new Object[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInconsistentFieldType() {
        this.unbounded.with("timestamp", new Object[]{0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyCheck() throws IOException {
        Assert.assertTrue((String)"New dataset should be empty", (boolean)this.unbounded.isEmpty());
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        Assert.assertFalse((String)"Should not be empty after write", (boolean)this.unbounded.isEmpty());
        Assert.assertFalse((String)"Should find event in September", (boolean)this.unbounded.with("timestamp", new Object[]{sepEvent.getTimestamp()}).isEmpty());
        Assert.assertTrue((String)"Should not find event in October", (boolean)this.unbounded.with("timestamp", new Object[]{octEvent.getTimestamp()}).isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitedReader() throws IOException {
        DatasetWriter writer = null;
        try {
            writer = this.unbounded.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, octEvent, novEvent}), this.unbounded);
        long octInstant = octEvent.getTimestamp();
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent}), this.unbounded.with("timestamp", new Object[]{octInstant}));
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent, novEvent}), this.unbounded.from("timestamp", (Comparable)Long.valueOf(octInstant)));
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, octEvent}), this.unbounded.to("timestamp", (Comparable)Long.valueOf(octInstant)));
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{novEvent}), this.unbounded.fromAfter("timestamp", (Comparable)Long.valueOf(octInstant)));
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent}), this.unbounded.toBefore("timestamp", (Comparable)Long.valueOf(octInstant)));
        long octStart = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long novStart = new DateTime(2013, 11, 1, 0, 0, DateTimeZone.UTC).getMillis();
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent}), this.unbounded.from("timestamp", (Comparable)Long.valueOf(octStart)).toBefore("timestamp", (Comparable)Long.valueOf(novStart)));
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, novEvent}), this.unbounded.with("user_id", new Object[]{0L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitedWriter() throws IOException {
        long start = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long end = new DateTime(2013, 11, 14, 0, 0, DateTimeZone.UTC).getMillis();
        final RefinableView range = this.unbounded.from("timestamp", (Comparable)Long.valueOf(start)).toBefore("timestamp", (Comparable)Long.valueOf(end));
        DatasetWriter writer = null;
        try {
            writer = range.newWriter();
            writer.write((Object)octEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{octEvent, novEvent}), range);
        TestHelpers.assertThrows("Should reject older event", IllegalArgumentException.class, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws IOException {
                DatasetWriter writer = null;
                try {
                    writer = range.newWriter();
                    writer.write((Object)sepEvent);
                }
                finally {
                    Closeables.close((Closeable)writer, (boolean)false);
                }
                return null;
            }
        });
        TestHelpers.assertThrows("Should reject current event", IllegalArgumentException.class, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws IOException {
                DatasetWriter writer = null;
                try {
                    writer = range.newWriter();
                    writer.write((Object)event);
                }
                finally {
                    Closeables.close((Closeable)writer, (boolean)false);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitedWriterForNonPartitionedField() throws IOException {
        final RefinableView view = this.unbounded.with("user_id", new Object[]{0L});
        DatasetWriter writer = null;
        try {
            writer = view.newWriter();
            writer.write((Object)sepEvent);
            writer.write((Object)novEvent);
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        TestRefinableViews.assertContentEquals(Sets.newHashSet((Object[])new StandardEvent[]{sepEvent, novEvent}), view);
        TestHelpers.assertThrows("Should reject event with user_id = 1", IllegalArgumentException.class, new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws IOException {
                DatasetWriter writer = null;
                try {
                    writer = view.newWriter();
                    writer.write((Object)octEvent);
                }
                finally {
                    Closeables.close((Closeable)writer, (boolean)false);
                }
                return null;
            }
        });
    }

    @Test
    public void testFromView() {
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long later = instant + 1L;
        final long earlier = instant - 1L;
        final RefinableView fromOctober = this.unbounded.from("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"Should not include older event", (boolean)fromOctober.includes((Object)sepEvent));
        Assert.assertTrue((String)"Should include event", (boolean)fromOctober.includes((Object)octEvent));
        Assert.assertTrue((String)"Should include newer event", (boolean)fromOctober.includes((Object)novEvent));
        Assert.assertTrue((String)"Should include current event", (boolean)fromOctober.includes((Object)event));
        Assert.assertNotNull((String)"to(same instant) should succeed", (Object)fromOctober.to("timestamp", (Comparable)Long.valueOf(instant)));
        Assert.assertNotNull((String)"adding independent constraints should succeed", (Object)fromOctober.with("event_name", new Object[]{"Event"}));
        Assert.assertNotNull((String)"with(later instant) should succeed", (Object)fromOctober.with("timestamp", new Object[]{later}));
        Assert.assertNotNull((String)"from(later instant) should succeed", (Object)fromOctober.from("timestamp", (Comparable)Long.valueOf(later)));
        Assert.assertNotNull((String)"fromAfter(later instant) should succeed", (Object)fromOctober.fromAfter("timestamp", (Comparable)Long.valueOf(later)));
        Assert.assertNotNull((String)"to(later instant) should succeed", (Object)fromOctober.to("timestamp", (Comparable)Long.valueOf(later)));
        Assert.assertNotNull((String)"toAfter(later instant) should succeed", (Object)fromOctober.toBefore("timestamp", (Comparable)Long.valueOf(later)));
        TestHelpers.assertThrows("with(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                fromOctober.with("timestamp", new Object[]{earlier});
            }
        });
        TestHelpers.assertThrows("to(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                fromOctober.to("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("toBefore(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                fromOctober.toBefore("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("from(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                fromOctober.from("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("fromAfter(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                fromOctober.fromAfter("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
    }

    @Test
    public void testFromAfterView() {
        final long instant = new DateTime(2013, 9, 30, 12, 59, 59, 999, DateTimeZone.UTC).getMillis();
        long later = instant + 1L;
        final long earlier = instant - 1L;
        final RefinableView afterSep = this.unbounded.fromAfter("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"Should not include older event", (boolean)afterSep.includes((Object)sepEvent));
        Assert.assertTrue((String)"Should include event", (boolean)afterSep.includes((Object)octEvent));
        Assert.assertTrue((String)"Should include newer event", (boolean)afterSep.includes((Object)novEvent));
        Assert.assertTrue((String)"Should include current event", (boolean)afterSep.includes((Object)event));
        TestHelpers.assertThrows("to(same instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                afterSep.to("timestamp", (Comparable)Long.valueOf(instant));
            }
        });
        Assert.assertNotNull((String)"adding independent constraints should succeed", (Object)afterSep.with("event_name", new Object[]{"Event"}));
        Assert.assertNotNull((String)"with(later instant) should succeed", (Object)afterSep.with("timestamp", new Object[]{later}));
        Assert.assertNotNull((String)"from(later instant) should succeed", (Object)afterSep.from("timestamp", (Comparable)Long.valueOf(later)));
        Assert.assertNotNull((String)"fromAfter(later instant) should succeed", (Object)afterSep.fromAfter("timestamp", (Comparable)Long.valueOf(later)));
        Assert.assertNotNull((String)"to(later instant) should succeed", (Object)afterSep.to("timestamp", (Comparable)Long.valueOf(later)));
        Assert.assertNotNull((String)"toAfter(later instant) should succeed", (Object)afterSep.toBefore("timestamp", (Comparable)Long.valueOf(later)));
        TestHelpers.assertThrows("with(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                afterSep.with("timestamp", new Object[]{earlier});
            }
        });
        TestHelpers.assertThrows("to(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                afterSep.to("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("toBefore(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                afterSep.toBefore("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("from(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                afterSep.from("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("fromAfter(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                afterSep.fromAfter("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
    }

    @Test
    public void testToView() {
        long instant = new DateTime(2013, 9, 30, 12, 59, 59, 999, DateTimeZone.UTC).getMillis();
        final long later = instant + 1L;
        long earlier = instant - 1L;
        final RefinableView toOct = this.unbounded.to("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertTrue((String)"Should include older event", (boolean)toOct.includes((Object)sepEvent));
        Assert.assertFalse((String)"Should not include event", (boolean)toOct.includes((Object)octEvent));
        Assert.assertFalse((String)"Should not include newer event", (boolean)toOct.includes((Object)novEvent));
        Assert.assertFalse((String)"Should not include current event", (boolean)toOct.includes((Object)event));
        Assert.assertNotNull((String)"from(same instant) should succeed", (Object)toOct.from("timestamp", (Comparable)Long.valueOf(instant)));
        Assert.assertNotNull((String)"adding independent constraints should succeed", (Object)toOct.with("event_name", new Object[]{"Event"}));
        Assert.assertNotNull((String)"with(earlier instant) should succeed", (Object)toOct.with("timestamp", new Object[]{earlier}));
        Assert.assertNotNull((String)"from(earlier instant) should succeed", (Object)toOct.from("timestamp", (Comparable)Long.valueOf(earlier)));
        Assert.assertNotNull((String)"fromAfter(earlier instant) should succeed", (Object)toOct.fromAfter("timestamp", (Comparable)Long.valueOf(earlier)));
        Assert.assertNotNull((String)"to(earlier instant) should succeed", (Object)toOct.to("timestamp", (Comparable)Long.valueOf(earlier)));
        Assert.assertNotNull((String)"toAfter(earlier instant) should succeed", (Object)toOct.toBefore("timestamp", (Comparable)Long.valueOf(earlier)));
        TestHelpers.assertThrows("with(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                toOct.with("timestamp", new Object[]{later});
            }
        });
        TestHelpers.assertThrows("to(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                toOct.to("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("toBefore(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                toOct.toBefore("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("from(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                toOct.from("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("fromAfter(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                toOct.fromAfter("timestamp", (Comparable)Long.valueOf(later));
            }
        });
    }

    @Test
    public void testToBeforeView() {
        final long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        final long later = instant + 1L;
        long earlier = instant - 1L;
        final RefinableView beforeOct = this.unbounded.toBefore("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertTrue((String)"Should include older event", (boolean)beforeOct.includes((Object)sepEvent));
        Assert.assertFalse((String)"Should not include event", (boolean)beforeOct.includes((Object)octEvent));
        Assert.assertFalse((String)"Should not include newer event", (boolean)beforeOct.includes((Object)novEvent));
        Assert.assertFalse((String)"Should not include current event", (boolean)beforeOct.includes((Object)event));
        TestHelpers.assertThrows("from(same instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                beforeOct.from("timestamp", (Comparable)Long.valueOf(instant));
            }
        });
        Assert.assertNotNull((String)"adding independent constraints should succeed", (Object)beforeOct.with("event_name", new Object[]{"Event"}));
        Assert.assertNotNull((String)"with(earlier instant) should succeed", (Object)beforeOct.with("timestamp", new Object[]{earlier}));
        Assert.assertNotNull((String)"from(earlier instant) should succeed", (Object)beforeOct.from("timestamp", (Comparable)Long.valueOf(earlier)));
        Assert.assertNotNull((String)"fromAfter(earlier instant) should succeed", (Object)beforeOct.fromAfter("timestamp", (Comparable)Long.valueOf(earlier)));
        Assert.assertNotNull((String)"to(earlier instant) should succeed", (Object)beforeOct.to("timestamp", (Comparable)Long.valueOf(earlier)));
        Assert.assertNotNull((String)"toAfter(earlier instant) should succeed", (Object)beforeOct.toBefore("timestamp", (Comparable)Long.valueOf(earlier)));
        TestHelpers.assertThrows("with(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                beforeOct.with("timestamp", new Object[]{later});
            }
        });
        TestHelpers.assertThrows("to(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                beforeOct.to("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("toBefore(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                beforeOct.toBefore("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("from(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                beforeOct.from("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("fromAfter(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                beforeOct.fromAfter("timestamp", (Comparable)Long.valueOf(later));
            }
        });
    }

    @Test
    public void testWithView() {
        final long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        final long later = instant + 1L;
        final long earlier = instant - 1L;
        final RefinableView withSpecificTimestamp = this.unbounded.with("timestamp", new Object[]{instant});
        Assert.assertNotNull((String)"from(same instant) should succeed", (Object)withSpecificTimestamp.from("timestamp", (Comparable)Long.valueOf(instant)));
        Assert.assertNotNull((String)"to(same instant) should succeed", (Object)withSpecificTimestamp.to("timestamp", (Comparable)Long.valueOf(instant)));
        Assert.assertNotNull((String)"with(same instant) should succeed", (Object)withSpecificTimestamp.with("timestamp", new Object[]{instant}));
        TestHelpers.assertThrows("with(different instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                withSpecificTimestamp.with("timestamp", new Object[]{later});
            }
        });
        TestHelpers.assertThrows("toBefore(same instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                withSpecificTimestamp.toBefore("timestamp", (Comparable)Long.valueOf(instant));
            }
        });
        TestHelpers.assertThrows("fromAfter(same instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                withSpecificTimestamp.fromAfter("timestamp", (Comparable)Long.valueOf(instant));
            }
        });
        TestHelpers.assertThrows("to(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                withSpecificTimestamp.to("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("from(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                withSpecificTimestamp.from("timestamp", (Comparable)Long.valueOf(later));
            }
        });
    }

    @Test
    public void testRange() {
        long start = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long end = new DateTime(2013, 11, 1, 0, 0, DateTimeZone.UTC).getMillis();
        final long later = end + 1L;
        final long earlier = start - 1L;
        long included = octEvent.getTimestamp();
        final RefinableView oct = this.unbounded.from("timestamp", (Comparable)Long.valueOf(start)).to("timestamp", (Comparable)Long.valueOf(end));
        Assert.assertFalse((String)"Should not include older event", (boolean)oct.includes((Object)sepEvent));
        Assert.assertTrue((String)"Should include event", (boolean)oct.includes((Object)octEvent));
        Assert.assertFalse((String)"Should not include newer event", (boolean)oct.includes((Object)novEvent));
        Assert.assertFalse((String)"Should not include current event", (boolean)oct.includes((Object)event));
        Assert.assertNotNull((String)"to(start) should succeed", (Object)oct.to("timestamp", (Comparable)Long.valueOf(start)));
        Assert.assertNotNull((String)"from(end) should succeed", (Object)oct.from("timestamp", (Comparable)Long.valueOf(end)));
        Assert.assertNotNull((String)"adding independent constraints should succeed", (Object)oct.with("event_name", new Object[]{"Event"}));
        Assert.assertNotNull((String)"with(included instant) should succeed", (Object)oct.with("timestamp", new Object[]{included}));
        Assert.assertNotNull((String)"from(included instant) should succeed", (Object)oct.from("timestamp", (Comparable)Long.valueOf(included)));
        Assert.assertNotNull((String)"fromAfter(included instant) should succeed", (Object)oct.fromAfter("timestamp", (Comparable)Long.valueOf(included)));
        Assert.assertNotNull((String)"to(included instant) should succeed", (Object)oct.to("timestamp", (Comparable)Long.valueOf(included)));
        Assert.assertNotNull((String)"toAfter(included instant) should succeed", (Object)oct.toBefore("timestamp", (Comparable)Long.valueOf(included)));
        TestHelpers.assertThrows("with(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.with("timestamp", new Object[]{earlier});
            }
        });
        TestHelpers.assertThrows("to(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.to("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("toBefore(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.toBefore("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("from(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.from("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("fromAfter(earlier instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.fromAfter("timestamp", (Comparable)Long.valueOf(earlier));
            }
        });
        TestHelpers.assertThrows("with(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.with("timestamp", new Object[]{later});
            }
        });
        TestHelpers.assertThrows("to(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.to("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("toBefore(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.toBefore("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("from(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.from("timestamp", (Comparable)Long.valueOf(later));
            }
        });
        TestHelpers.assertThrows("fromAfter(later instant) should fail", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                oct.fromAfter("timestamp", (Comparable)Long.valueOf(later));
            }
        });
    }

    @Test
    public void testUnboundedView() {
        Assert.assertTrue((String)"Should include any StandardEvent", (boolean)this.unbounded.includes((Object)event));
        Assert.assertTrue((String)"Should include even null events", (boolean)this.unbounded.includes(null));
        Assert.assertTrue((String)"Should include older event", (boolean)this.unbounded.includes((Object)sepEvent));
        Assert.assertTrue((String)"Should include event", (boolean)this.unbounded.includes((Object)octEvent));
        Assert.assertTrue((String)"Should include newer event", (boolean)this.unbounded.includes((Object)novEvent));
        Assert.assertNotNull((String)"from should succeed", (Object)this.unbounded.from("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"fromAfter should succeed", (Object)this.unbounded.fromAfter("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"to should succeed", (Object)this.unbounded.to("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"toBefore should succeed", (Object)this.unbounded.toBefore("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"with should succeed", (Object)this.unbounded.with("timestamp", new Object[]{now}));
    }

    @Test
    public void testNotPartitioned() throws Exception {
        DatasetDescriptor flatDescriptor = new DatasetDescriptor.Builder(this.testDescriptor).partitionStrategy((PartitionStrategy)null).build();
        Dataset notPartitioned = this.repo.create("ns", "flat", flatDescriptor);
        Assert.assertTrue((String)"Should include any StandardEvent", (boolean)notPartitioned.includes((Object)event));
        Assert.assertTrue((String)"Should include even null events", (boolean)notPartitioned.includes(null));
        Assert.assertTrue((String)"Should include older event", (boolean)notPartitioned.includes((Object)sepEvent));
        Assert.assertTrue((String)"Should include event", (boolean)notPartitioned.includes((Object)octEvent));
        Assert.assertTrue((String)"Should include newer event", (boolean)notPartitioned.includes((Object)novEvent));
        Assert.assertNotNull((String)"from should succeed", (Object)notPartitioned.from("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"fromAfter should succeed", (Object)notPartitioned.fromAfter("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"to should succeed", (Object)notPartitioned.to("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"toBefore should succeed", (Object)notPartitioned.toBefore("timestamp", (Comparable)Long.valueOf(now)));
        Assert.assertNotNull((String)"with should succeed", (Object)notPartitioned.with("timestamp", new Object[]{now}));
    }

    @Test
    public void testReadySignalWithConstraint() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable withSpecificTimestamp = (Signalable)this.unbounded.with("timestamp", new Object[]{instant});
        Assert.assertFalse((String)"Should not be ready initially", (boolean)withSpecificTimestamp.isReady());
        withSpecificTimestamp.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)withSpecificTimestamp.isReady());
        Signalable multipleWithView = (Signalable)this.unbounded.with("timestamp", new Object[]{instant + 1L, instant + 2L});
        Assert.assertFalse((String)"Should not be ready initially", (boolean)multipleWithView.isReady());
        multipleWithView.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)multipleWithView.isReady());
    }

    @Test
    public void testReadySignalFromConstraint() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable fromSpecificTimestamp = (Signalable)this.unbounded.from("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"Should not be ready initially", (boolean)fromSpecificTimestamp.isReady());
        fromSpecificTimestamp.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)fromSpecificTimestamp.isReady());
    }

    @Test
    public void testReadySignalFromAfterConstraint() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable fromAfterSpecificTimestamp = (Signalable)this.unbounded.from("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"Should not be ready initially", (boolean)fromAfterSpecificTimestamp.isReady());
        fromAfterSpecificTimestamp.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)fromAfterSpecificTimestamp.isReady());
    }

    @Test
    public void testReadySignalToConstraint() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable toSpecificTimestamp = (Signalable)this.unbounded.to("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"Should not be ready initially", (boolean)toSpecificTimestamp.isReady());
        toSpecificTimestamp.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)toSpecificTimestamp.isReady());
    }

    @Test
    public void testReadySignalToBeforeConstraint() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable toBeforeSpecificTimestamp = (Signalable)this.unbounded.toBefore("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"Should not be ready initially", (boolean)toBeforeSpecificTimestamp.isReady());
        toBeforeSpecificTimestamp.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)toBeforeSpecificTimestamp.isReady());
    }

    @Test
    public void testReadySignalMultipleConstraints() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable withTwoConstrainedFields = (Signalable)this.unbounded.with("timestamp", new Object[]{instant}).with("user_id", new Object[]{0L});
        Assert.assertFalse((String)"Should not be ready initially", (boolean)withTwoConstrainedFields.isReady());
        withTwoConstrainedFields.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)withTwoConstrainedFields.isReady());
    }

    @Test
    public void testReadySignalsAroundComparableBoundaries() {
        Assume.assumeTrue((boolean)(this.unbounded instanceof Signalable));
        long instant = new DateTime(2013, 10, 1, 0, 0, DateTimeZone.UTC).getMillis();
        Signalable withSpecificTimestamp = (Signalable)this.unbounded.with("timestamp", new Object[]{instant});
        Assert.assertFalse((String)"Base view should not be ready initially", (boolean)((Signalable)this.unbounded).isReady());
        Assert.assertFalse((String)"Should not be ready initially", (boolean)withSpecificTimestamp.isReady());
        withSpecificTimestamp.signalReady();
        Assert.assertTrue((String)"Should be ready after signal", (boolean)withSpecificTimestamp.isReady());
        Signalable beforeSpecificTimestamp = (Signalable)this.unbounded.toBefore("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"To before the instant should not be ready", (boolean)beforeSpecificTimestamp.isReady());
        Signalable afterSpecificTimestamp = (Signalable)this.unbounded.fromAfter("timestamp", (Comparable)Long.valueOf(instant));
        Assert.assertFalse((String)"To after the instant should not be ready", (boolean)afterSpecificTimestamp.isReady());
        Signalable immediatelyAfterSpecificTimestamp = (Signalable)this.unbounded.with("timestamp", new Object[]{instant + 1L});
        Assert.assertFalse((String)"After the instant should not be ready", (boolean)immediatelyAfterSpecificTimestamp.isReady());
        Signalable immediatelyBeforeSpecificTimestamp = (Signalable)this.unbounded.with("timestamp", new Object[]{instant - 1L});
        Assert.assertFalse((String)"Before the instant should not be ready", (boolean)immediatelyBeforeSpecificTimestamp.isReady());
        Signalable includingSpecificTimestamp = (Signalable)this.unbounded.from("timestamp", (Comparable)Long.valueOf(instant - 1L)).to("timestamp", (Comparable)Long.valueOf(instant + 1L));
        Assert.assertFalse((String)"Including the instant should not be ready", (boolean)includingSpecificTimestamp.isReady());
    }
}

