/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.spi.Marker;
import org.kitesdk.data.spi.MarkerComparator;

public class TestMarkerComparator {
    private static Marker OCT;
    private static Marker OCT_12;
    private static Marker SEPT;
    private static Marker SEPT_30;
    private static Marker NOV;
    private static Marker NOV_1;
    private static MarkerComparator comparator;

    @BeforeClass
    public static void setup() {
        OCT = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).build();
        OCT_12 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)10).add("day", (Object)12).build();
        SEPT = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).build();
        SEPT_30 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)9).add("day", (Object)30).build();
        NOV = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).build();
        NOV_1 = new Marker.Builder().add("year", (Object)2013).add("month", (Object)11).add("day", (Object)1).build();
        PartitionStrategy strategy = new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build();
        comparator = new MarkerComparator(strategy);
    }

    @Test(expected=IllegalStateException.class)
    public void testContainedStateException() {
        comparator.compare(OCT, OCT_12);
    }

    @Test
    public void testLeftInclusiveContained() {
        Assert.assertEquals((long)-1L, (long)comparator.leftCompare(OCT, OCT_12));
        Assert.assertEquals((long)1L, (long)comparator.leftCompare(OCT_12, OCT));
    }

    @Test
    public void testRightInclusiveContained() {
        Assert.assertEquals((long)1L, (long)comparator.rightCompare(OCT, OCT_12));
        Assert.assertEquals((long)-1L, (long)comparator.rightCompare(OCT_12, OCT));
    }

    @Test
    public void testLessThan() {
        Assert.assertEquals((long)-1L, (long)comparator.compare(SEPT_30, OCT));
        Assert.assertEquals((long)-1L, (long)comparator.leftCompare(SEPT_30, OCT));
        Assert.assertEquals((long)-1L, (long)comparator.rightCompare(SEPT_30, OCT));
        Assert.assertEquals((long)1L, (long)comparator.compare(OCT, SEPT_30));
        Assert.assertEquals((long)1L, (long)comparator.leftCompare(OCT, SEPT_30));
        Assert.assertEquals((long)1L, (long)comparator.rightCompare(OCT, SEPT_30));
    }

    @Test
    public void testGreaterThan() {
        Assert.assertEquals((long)1L, (long)comparator.compare(NOV_1, OCT));
        Assert.assertEquals((long)1L, (long)comparator.leftCompare(NOV_1, OCT));
        Assert.assertEquals((long)1L, (long)comparator.rightCompare(NOV_1, OCT));
        Assert.assertEquals((long)-1L, (long)comparator.compare(OCT, NOV_1));
        Assert.assertEquals((long)-1L, (long)comparator.leftCompare(OCT, NOV_1));
        Assert.assertEquals((long)-1L, (long)comparator.rightCompare(OCT, NOV_1));
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((long)0L, (long)comparator.compare(OCT, OCT));
        Assert.assertEquals((long)0L, (long)comparator.compare(SEPT_30, SEPT_30));
        Assert.assertEquals((long)0L, (long)comparator.compare(OCT_12, OCT_12));
        Assert.assertEquals((long)0L, (long)comparator.compare(NOV_1, NOV_1));
        Assert.assertEquals((long)0L, (long)comparator.leftCompare(OCT, OCT));
        Assert.assertEquals((long)0L, (long)comparator.leftCompare(SEPT_30, SEPT_30));
        Assert.assertEquals((long)0L, (long)comparator.leftCompare(OCT_12, OCT_12));
        Assert.assertEquals((long)0L, (long)comparator.leftCompare(NOV_1, NOV_1));
        Assert.assertEquals((long)0L, (long)comparator.rightCompare(OCT, OCT));
        Assert.assertEquals((long)0L, (long)comparator.rightCompare(SEPT_30, SEPT_30));
        Assert.assertEquals((long)0L, (long)comparator.rightCompare(OCT_12, OCT_12));
        Assert.assertEquals((long)0L, (long)comparator.rightCompare(NOV_1, NOV_1));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)comparator.contains(OCT, OCT_12));
        Assert.assertTrue((boolean)comparator.contains(OCT, OCT));
        Assert.assertFalse((boolean)comparator.contains(OCT_12, OCT));
        Assert.assertFalse((boolean)comparator.contains(OCT, SEPT));
        Assert.assertFalse((boolean)comparator.contains(OCT, SEPT_30));
        Assert.assertFalse((boolean)comparator.contains(OCT, NOV));
        Assert.assertFalse((boolean)comparator.contains(OCT, NOV_1));
    }
}

