/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.event.ReflectSmallEvent;
import org.kitesdk.data.event.ReflectStandardEvent;
import org.kitesdk.data.event.SmallEvent;
import org.kitesdk.data.event.StandardEvent;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.filesystem.TestGenericRecord;

public class TestDataModelUtil {
    @Test
    public void testDataModelForGenericType() {
        Class<GenericData.Record> type = GenericData.Record.class;
        GenericData result = DataModelUtil.getDataModelForType(type);
        Assert.assertEquals(GenericData.class, result.getClass());
    }

    @Test
    public void testDataModelForSpecificType() {
        Class<StandardEvent> type = StandardEvent.class;
        GenericData result = DataModelUtil.getDataModelForType(type);
        Assert.assertEquals(SpecificData.class, result.getClass());
    }

    @Test
    public void testDataModelForReflectType() {
        Class<String> type = String.class;
        GenericData result = DataModelUtil.getDataModelForType(type);
        Assert.assertEquals(DataModelUtil.AllowNulls.class, result.getClass());
    }

    @Test
    public void testGetDatumReaderForGenericType() {
        Class<GenericData.Record> type = GenericData.Record.class;
        Schema writerSchema = StandardEvent.getClassSchema();
        DatumReader result = DataModelUtil.getDatumReaderForType(type, (Schema)writerSchema);
        Assert.assertEquals(GenericDatumReader.class, result.getClass());
    }

    @Test
    public void testGetDatumReaderForSpecificType() {
        Class<StandardEvent> type = StandardEvent.class;
        Schema writerSchema = StandardEvent.getClassSchema();
        DatumReader result = DataModelUtil.getDatumReaderForType(type, (Schema)writerSchema);
        Assert.assertEquals(SpecificDatumReader.class, result.getClass());
    }

    @Test
    public void testGetDatumReaderForReflectType() {
        Class<String> type = String.class;
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        DatumReader result = DataModelUtil.getDatumReaderForType(type, (Schema)writerSchema);
        Assert.assertEquals(ReflectDatumReader.class, result.getClass());
    }

    @Test
    public void testResolveTypeGenericToGeneric() {
        Class<GenericData.Record> type = GenericData.Record.class;
        Schema schema = StandardEvent.getClassSchema();
        Class<GenericData.Record> expResult = type;
        Class result = DataModelUtil.resolveType(type, (Schema)schema);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testResolveTypeSpecifcToSpecifc() {
        Class<StandardEvent> type = StandardEvent.class;
        Schema schema = StandardEvent.getClassSchema();
        Class<StandardEvent> expResult = type;
        Class result = DataModelUtil.resolveType(type, (Schema)schema);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testResolveTypeReflectToReflect() {
        Class<String> type = String.class;
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Class<String> expResult = type;
        Class result = DataModelUtil.resolveType(type, (Schema)schema);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testResolveTypeObjectToSpecifc() {
        Class<Object> type = Object.class;
        Schema schema = StandardEvent.getClassSchema();
        Class<StandardEvent> expResult = StandardEvent.class;
        Class result = DataModelUtil.resolveType(type, (Schema)schema);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testResolveTypeObjectToGeneric() {
        Class<Object> type = Object.class;
        Schema schema = (Schema)SchemaBuilder.record((String)"User").fields().requiredString("name").requiredString("color").endRecord();
        Class<GenericData.Record> expResult = GenericData.Record.class;
        Class result = DataModelUtil.resolveType(type, (Schema)schema);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testResolveTypeObjectToReflect() {
        Class<Object> type = Object.class;
        Schema schema = ReflectData.get().getSchema(String.class);
        Class<String> expResult = String.class;
        Class result = DataModelUtil.resolveType(type, (Schema)schema);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testGetReaderSchemaForGeneric() {
        Schema writerSchema;
        Class<GenericData.Record> type = GenericData.Record.class;
        Schema expResult = writerSchema = StandardEvent.getClassSchema();
        Schema result = DataModelUtil.getReaderSchema(type, (Schema)writerSchema);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetReaderSchemaForSpecific() {
        Schema writerSchema;
        Class<StandardEvent> type = StandardEvent.class;
        Schema expResult = writerSchema = StandardEvent.getClassSchema();
        Schema result = DataModelUtil.getReaderSchema(type, (Schema)writerSchema);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetReaderSchemaForReflect() {
        Schema writerSchema;
        Class<String> type = String.class;
        Schema expResult = writerSchema = ReflectData.get().getSchema(String.class);
        Schema result = DataModelUtil.getReaderSchema(type, (Schema)writerSchema);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetReaderSchemaForCompatibleSpecific() {
        Class<SmallEvent> type = SmallEvent.class;
        Schema writerSchema = StandardEvent.getClassSchema();
        Schema expResult = SmallEvent.getClassSchema();
        Schema result = DataModelUtil.getReaderSchema(type, (Schema)writerSchema);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetReaderSchemaForCompatibleReflect() {
        Class<ReflectSmallEvent> type = ReflectSmallEvent.class;
        Schema writerSchema = ReflectData.get().getSchema(ReflectStandardEvent.class);
        Schema expResult = DataModelUtil.AllowNulls.get().getSchema(ReflectSmallEvent.class);
        Schema result = DataModelUtil.getReaderSchema(type, (Schema)writerSchema);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testCreateRecord() {
        Assert.assertNull((String)"createRecord should not create Specific instances", (Object)DataModelUtil.createRecord(StandardEvent.class, (Schema)StandardEvent.getClassSchema()));
        Assert.assertNull((String)"createRecord should not create Reflect instances", (Object)DataModelUtil.createRecord(ReflectStandardEvent.class, (Schema)ReflectData.get().getSchema(ReflectStandardEvent.class)));
        Assert.assertNotNull((String)"createRecord should create Generic instances", (Object)DataModelUtil.createRecord(GenericData.Record.class, (Schema)StandardEvent.getClassSchema()));
        Assert.assertEquals((String)"createRecord did not return the expected class", TestGenericRecord.class, ((Object)((Object)((TestGenericRecord)((Object)DataModelUtil.createRecord(TestGenericRecord.class, (Schema)StandardEvent.getClassSchema()))))).getClass());
    }
}

