/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.ColumnMapping;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.FieldMapping;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;
import org.kitesdk.data.spi.ColumnMappingParser;

public class TestColumnMappingParser {
    public static void checkParser(ColumnMapping expected, String json) {
        ColumnMapping parsed = ColumnMappingParser.parse((String)json);
        Assert.assertEquals((Object)expected, (Object)parsed);
        parsed = ColumnMappingParser.parse((String)expected.toString());
        Assert.assertEquals((String)"Should reparse properly", (Object)expected, (Object)parsed);
    }

    @Test
    public void testMultipleMappings() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().key("key_field").column("username", "meta", "username").column("email", "meta", "email").keyAsColumn("map_field", "map_content", "key_").counter("counter_field", "meta", "counter_field").counter("counter_field2", "meta", "counter_field2").build(), "[\n{\"source\": \"key_field\", \"type\": \"key\"},\n{\"source\": \"username\", \"type\": \"column\",\"family\": \"meta\", \"qualifier\": \"username\"},\n{\"source\": \"email\", \"type\": \"column\",\"family\": \"meta\", \"qualifier\": \"email\"},\n{\"source\": \"map_field\", \"type\": \"keyAsColumn\",\"family\": \"map_content\", \"prefix\": \"key_\"},\n{\"source\": \"counter_field\", \"type\": \"counter\",\"family\": \"meta\", \"qualifier\": \"counter_field\"},\n{\"source\": \"counter_field2\", \"type\": \"counter\",\"family\": \"meta\", \"qualifier\": \"counter_field2\"}\n]\n");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().key("key_field").column("username", "meta", "username").column("email", "meta", "email").keyAsColumn("map_field", "map_content", "key_").version("version").build(), "[\n{\"source\": \"key_field\", \"type\": \"key\"},\n{\"source\": \"username\", \"type\": \"column\",\"family\": \"meta\", \"qualifier\": \"username\"},\n{\"source\": \"email\", \"type\": \"column\",\"family\": \"meta\", \"qualifier\": \"email\"},\n{\"source\": \"map_field\", \"type\": \"keyAsColumn\",\"family\": \"map_content\", \"prefix\": \"key_\"},\n{\"source\": \"version\", \"type\": \"occVersion\"}\n]\n");
        TestHelpers.assertThrows("Should reject counter and occVersion", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[{\"source\": \"v\", \"type\": \"occVersion\"},{\"source\": \"c\", \"type\": \"counter\", \"value\": \"f:q\"}]");
            }
        });
        TestHelpers.assertThrows("Should reject more than one occVersion", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[{\"source\": \"v\", \"type\": \"occVersion\"},{\"source\": \"v2\", \"type\": \"occVersion\"}]");
            }
        });
    }

    @Test
    public void testKeyMapping() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().key("s").build(), "[ {\"source\": \"s\", \"type\": \"key\"} ]");
        TestHelpers.assertThrows("Should reject missing source", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"key\"} ]");
            }
        });
    }

    @Test
    public void testColumnMapping() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().column("s", "f", "q").build(), "[ {\"source\": \"s\", \"type\": \"column\", \"value\": \"f:q\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().column("s", "f", "q").build(), "[ {\"source\": \"s\", \"type\": \"column\",\"family\": \"f\", \"qualifier\": \"q\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().column("s", "fam", "qual").build(), "[ {\"source\": \"s\", \"type\": \"column\", \"value\": \"f:q\", \"family\": \"fam\", \"qualifier\": \"qual\"} ]");
        TestHelpers.assertThrows("Should reject missing source", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"column\", \"family\": \"f\",\"qualifier\": \"q\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\", \"value\": \"f\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\", \"value\": \"f:\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\", \"family\": \"f\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\",\"family\": \"f\", \"qualifier\": \"\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\"\"value\": \"\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\"\"value\": \":\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"column\"\"family\": \"\"} ]");
            }
        });
    }

    @Test
    public void testKeyAsColumnMapping() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().keyAsColumn("s", "f").build(), "[ {\"source\": \"s\", \"type\": \"keyAsColumn\", \"value\": \"f\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().keyAsColumn("s", "f", "p").build(), "[ {\"source\": \"s\", \"type\": \"keyAsColumn\",\"value\": \"f:p\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().keyAsColumn("s", "f").build(), "[ {\"source\": \"s\", \"type\": \"keyAsColumn\",\"family\": \"f\" } ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().keyAsColumn("s", "f", "p").build(), "[ {\"source\": \"s\", \"type\": \"keyAsColumn\",\"family\": \"f\", \"prefix\": \"p\" } ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().keyAsColumn("s", "fam").build(), "[ {\"source\": \"s\", \"type\": \"keyAsColumn\", \"value\": \"f\", \"family\": \"fam\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().keyAsColumn("s", "fam", "pre").build(), "[ {\"source\": \"s\", \"type\": \"keyAsColumn\",\"value\": \"f:p\", \"family\": \"fam\", \"prefix\": \"pre\"} ]");
        TestHelpers.assertThrows("Should reject missing source", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"keyAsColumn\", \"family\": \"f\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"keyAsColumn\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"keyAsColumn\"\"value\": \"\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"keyAsColumn\"\"family\": \"\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"keyAsColumn\"\"value\": \":\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"keyAsColumn\",\"family\": \"f\", \"qualifier\": \"\"} ]");
            }
        });
    }

    @Test
    public void testCounterMapping() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().counter("s", "f", "q").build(), "[ {\"source\": \"s\", \"type\": \"counter\", \"value\": \"f:q\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().counter("s", "f", "q").build(), "[ {\"source\": \"s\", \"type\": \"counter\",\"family\": \"f\", \"qualifier\": \"q\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().counter("s", "fam", "qual").build(), "[ {\"source\": \"s\", \"type\": \"counter\", \"value\": \"f:q\", \"family\": \"fam\", \"qualifier\": \"qual\"} ]");
        TestHelpers.assertThrows("Should reject missing source", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"counter\", \"family\": \"f\",\"qualifier\": \"q\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\", \"value\": \"f\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\", \"value\": \"f:\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\", \"family\": \"f\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing qualifier", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\",\"family\": \"f\", \"qualifier\": \"\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject missing family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\"\"value\": \"\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\"\"value\": \":\"} ]");
            }
        });
        TestHelpers.assertThrows("Should reject empty family", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"s\", \"type\": \"counter\"\"family\": \"\"} ]");
            }
        });
    }

    @Test
    public void testOCCVersionMapping() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().occ("s").build(), "[ {\"source\": \"s\", \"type\": \"occVersion\"} ]");
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().version("s").build(), "[ {\"source\": \"s\", \"type\": \"occVersion\"} ]");
        TestHelpers.assertThrows("Should reject missing source", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"occVersion\"} ]");
            }
        });
    }

    @Test
    public void testNumericInsteadOfString() {
        TestColumnMappingParser.checkParser(new ColumnMapping.Builder().key("34").build(), "[ {\"type\": \"key\", \"source\": 34} ]");
    }

    @Test
    public void testMissingType() {
        TestHelpers.assertThrows("Should reject missing mapping type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"source\": \"banana\"} ]");
            }
        });
    }

    @Test
    public void testUnknownType() {
        TestHelpers.assertThrows("Should reject unknown mapping type", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"cats\", \"source\": \"banana\"} ]");
            }
        });
    }

    @Test
    public void testJsonObject() {
        TestHelpers.assertThrows("Should reject non-array strategy", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"{\"type\": \"year\", \"source\": \"banana\"}");
            }
        });
    }

    @Test
    public void testNonRecordMapping() {
        TestHelpers.assertThrows("Should reject JSON string mapping", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"key\", \"source\": \"id\"},\"cheese!\" ]");
            }
        });
        TestHelpers.assertThrows("Should reject JSON number mapping", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"key\", \"source\": \"id\"},34 ]");
            }
        });
        TestHelpers.assertThrows("Should reject JSON array mapping", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\": \"key\", \"source\": \"id\"},[ 1, 2, 3 ] ]");
            }
        });
    }

    @Test
    public void testInvalidJson() {
        TestHelpers.assertThrows("Should reject bad JSON", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((String)"[ {\"type\", \"key\", \"source\": \"banana\"} ]");
            }
        });
    }

    @Test
    public void testInputStreamIOException() {
        TestHelpers.assertThrows("Should pass DatasetIOException", DatasetIOException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((InputStream)new InputStream(){

                    @Override
                    public int read() throws IOException {
                        throw new IOException("InputStream angry.");
                    }
                });
            }
        });
    }

    @Test
    public void testMissingFile() {
        TestHelpers.assertThrows("Should pass DatasetIOException", DatasetIOException.class, new Runnable(){

            @Override
            public void run() {
                ColumnMappingParser.parse((File)new File("target/missing.json"));
            }
        });
    }

    @Test
    public void testAddEmbeddedColumnMapping() {
        ColumnMapping mapping = new ColumnMapping.Builder().key("id").column("username", "u", "username").column("real_name", "u", "name").build();
        Schema original = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"User\",  \"partitions\": [    {\"type\": \"identity\", \"source\": \"id\", \"name\": \"id_copy\"}  ],  \"fields\": [    {\"name\": \"id\", \"type\": \"long\"},    {\"name\": \"username\", \"type\": \"string\"},    {\"name\": \"real_name\", \"type\": \"string\"}  ]}");
        Schema embedded = ColumnMappingParser.embedColumnMapping((Schema)original, (ColumnMapping)mapping);
        junit.framework.Assert.assertTrue((boolean)ColumnMappingParser.hasEmbeddedColumnMapping((Schema)embedded));
        junit.framework.Assert.assertEquals((Object)mapping, (Object)ColumnMappingParser.parseFromSchema((Schema)embedded));
    }

    @Test
    public void testReplaceEmbeddedPartitionStrategy() {
        ColumnMapping mapping = new ColumnMapping.Builder().key("id").column("username", "u", "username").column("real_name", "u", "name").build();
        Schema original = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"User\",  \"partitions\": [    {\"type\": \"identity\", \"source\": \"id\", \"name\": \"id_copy\"}  ],  \"mapping\": [    {\"type\": \"occVersion\", \"source\": \"id\"},    {\"type\": \"column\",     \"source\": \"username\",     \"family\": \"meta\",     \"qualifier\": \"u\"},    {\"type\": \"column\",     \"source\": \"real_name\",     \"family\": \"meta\",     \"qualifier\": \"r\"}  ],  \"fields\": [    {\"name\": \"id\", \"type\": \"long\"},    {\"name\": \"username\", \"type\": \"string\"},    {\"name\": \"real_name\", \"type\": \"string\"}  ]}");
        Assert.assertTrue((boolean)ColumnMappingParser.hasEmbeddedColumnMapping((Schema)original));
        Assert.assertFalse((boolean)ColumnMappingParser.parseFromSchema((Schema)original).equals((Object)mapping));
        Schema embedded = ColumnMappingParser.embedColumnMapping((Schema)original, (ColumnMapping)mapping);
        Assert.assertTrue((boolean)ColumnMappingParser.hasEmbeddedColumnMapping((Schema)embedded));
        Assert.assertEquals((Object)mapping, (Object)ColumnMappingParser.parseFromSchema((Schema)embedded));
    }

    @Test
    public void testGetKeyMappingsFromSchemaFields() {
        Schema schema = new Schema.Parser().parse("{  \"type\": \"record\",  \"name\": \"User\",  \"fields\": [    {\"name\": \"id\", \"type\": \"long\", \"mapping\":      {\"type\": \"key\", \"value\": \"1\"} },    {\"name\": \"username\", \"type\": \"string\", \"mapping\":      {\"type\": \"key\", \"value\": \"0\"} },    {\"name\": \"real_name\", \"type\": \"string\", \"mapping\":      {\"type\": \"column\", \"value\": \"m:name\"} }  ]}");
        Map keys = ColumnMappingParser.parseKeyMappingsFromSchemaFields((Schema)schema);
        ImmutableMap expected = ImmutableMap.builder().put((Object)0, (Object)FieldMapping.key((String)"username")).put((Object)1, (Object)FieldMapping.key((String)"id")).build();
        Assert.assertEquals((Object)expected, (Object)keys);
    }
}

