/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.spi.CharSequences;

public class TestCharSequences {
    @Test
    public void testCompareStartsWith() {
        Utf8 first = new Utf8("abcd");
        Utf8 second = new Utf8("abc");
        int cmp = first.compareTo(second);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)first.toString().compareTo(second.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)second));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)second));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)second.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)second.toString()));
        cmp = second.compareTo(first);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)second.toString().compareTo(first.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)second, (CharSequence)first));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)second.toString(), (CharSequence)first));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)second, (CharSequence)first.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)second.toString(), (CharSequence)first.toString()));
    }

    @Test
    public void testCompareDifferBeforeEnd() {
        Utf8 first = new Utf8("abcd");
        Utf8 second = new Utf8("abd");
        int cmp = first.compareTo(second);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)first.toString().compareTo(second.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)second));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)second));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)second.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)second.toString()));
        cmp = second.compareTo(first);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)second.toString().compareTo(first.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)second, (CharSequence)first));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)second.toString(), (CharSequence)first));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)second, (CharSequence)first.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)second.toString(), (CharSequence)first.toString()));
    }

    @Test
    public void testCompareEqualLength() {
        Utf8 first = new Utf8("abcd");
        Utf8 second = new Utf8("abdd");
        int cmp = first.compareTo(first);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)first.toString().compareTo(first.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)first));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)new Utf8(first)));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)first));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)first.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)first.toString()));
        cmp = first.compareTo(second);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)first.toString().compareTo(second.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)second));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)second));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first, (CharSequence)second.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)first.toString(), (CharSequence)second.toString()));
        cmp = second.compareTo(first);
        Assert.assertEquals((String)"Utf8 and String compareTo should agree", (long)cmp, (long)second.toString().compareTo(first.toString()));
        Assert.assertEquals((String)"compare(Utf8,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)second, (CharSequence)first));
        Assert.assertEquals((String)"compare(String,Utf8)", (long)cmp, (long)CharSequences.compare((CharSequence)second.toString(), (CharSequence)first));
        Assert.assertEquals((String)"compare(Utf8,String)", (long)cmp, (long)CharSequences.compare((CharSequence)second, (CharSequence)first.toString()));
        Assert.assertEquals((String)"compare(String,String)", (long)cmp, (long)CharSequences.compare((CharSequence)second.toString(), (CharSequence)first.toString()));
    }

    @Test
    public void testHashCode() {
        Utf8 first = new Utf8("abcd");
        Utf8 second = new Utf8("abdd");
        Assert.assertEquals((String)"hashCode(Utf8) == hashCode(Utf8)", (long)CharSequences.hashCode((CharSequence)first), (long)CharSequences.hashCode((CharSequence)new Utf8(first)));
        Assert.assertEquals((String)"hashCode(Utf8) == hashCode(String)", (long)CharSequences.hashCode((CharSequence)first), (long)CharSequences.hashCode((CharSequence)first.toString()));
        Assert.assertEquals((String)"hashCode(String) == hashCode(String)", (long)CharSequences.hashCode((CharSequence)first.toString()), (long)CharSequences.hashCode((CharSequence)first.toString()));
        Assert.assertEquals((String)"hashCode(Utf8) == hashCode(Utf8)", (long)CharSequences.hashCode((CharSequence)second), (long)CharSequences.hashCode((CharSequence)new Utf8(second)));
        Assert.assertEquals((String)"hashCode(Utf8) == hashCode(String)", (long)CharSequences.hashCode((CharSequence)second), (long)CharSequences.hashCode((CharSequence)second.toString()));
        Assert.assertEquals((String)"hashCode(String) == hashCode(String)", (long)CharSequences.hashCode((CharSequence)second.toString()), (long)CharSequences.hashCode((CharSequence)second.toString()));
        Assert.assertFalse((String)"(a != b) => hashCode(a) != hashCode(b) (mostly)", (CharSequences.hashCode((CharSequence)first) == CharSequences.hashCode((CharSequence)second) ? 1 : 0) != 0);
    }

    @Test
    public void testStringCharSequenceSetContains() {
        ArrayList colors = Lists.newArrayList((Object[])new String[]{"orange", "green", "blue", "red", "purple", "red"});
        CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        for (String color : colors) {
            Assert.assertTrue((String)"Should contain Utf8(value)", (boolean)set.contains((Object)new Utf8(color)));
        }
        Assert.assertTrue((String)"Should contain all values", (boolean)set.containsAll((Collection)colors));
    }

    @Test
    public void testUtf8CharSequenceSetContains() {
        ArrayList colors = Lists.newArrayList((Object[])new Utf8[]{new Utf8("orange"), new Utf8("green"), new Utf8("blue"), new Utf8("red"), new Utf8("purple"), new Utf8("red")});
        CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        for (Utf8 color : colors) {
            Assert.assertTrue((String)"Should contain Utf8(value)", (boolean)set.contains((Object)color.toString()));
        }
        Assert.assertTrue((String)"Should contain all values", (boolean)set.containsAll((Collection)colors));
    }

    @Test
    public void testStringCharSequenceSetSize() {
        ArrayList colors = Lists.newArrayList((Object[])new String[]{"orange", "green", "blue", "red", "purple", "red"});
        CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        Assert.assertEquals((String)"Should remove duplicate color", (long)5L, (long)set.size());
    }

    @Test
    public void testUtf8CharSequenceSetSize() {
        ArrayList colors = Lists.newArrayList((Object[])new Utf8[]{new Utf8("orange"), new Utf8("green"), new Utf8("blue"), new Utf8("red"), new Utf8("purple"), new Utf8("red")});
        CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        Assert.assertEquals((String)"Should remove duplicate color", (long)5L, (long)set.size());
    }

    @Test
    public void testStringCharSequenceSetIterator() {
        ArrayList colors = Lists.newArrayList((Object[])new String[]{"orange", "green", "blue", "red", "purple", "red"});
        HashSet normalSet = Sets.newHashSet((Iterable)colors);
        CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        for (CharSequence color : set) {
            Assert.assertTrue((String)"Should return original types", (boolean)(color instanceof String));
            normalSet.remove(color);
        }
        Assert.assertTrue((String)"Should iterate through all values", (boolean)normalSet.isEmpty());
    }

    @Test
    public void testUtf8CharSequenceSetIterator() {
        ArrayList colors = Lists.newArrayList((Object[])new Utf8[]{new Utf8("orange"), new Utf8("green"), new Utf8("blue"), new Utf8("red"), new Utf8("purple"), new Utf8("red")});
        HashSet normalSet = Sets.newHashSet((Iterable)colors);
        CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        for (CharSequence color : set) {
            Assert.assertTrue((String)"Should return original types", (boolean)(color instanceof Utf8));
            normalSet.remove(color);
        }
        Assert.assertTrue((String)"Should iterate through all values", (boolean)normalSet.isEmpty());
    }

    @Test
    public void testStringCharSequenceSetImmutable() {
        ArrayList colors = Lists.newArrayList((Object[])new String[]{"orange", "green", "blue", "red", "purple", "red"});
        final CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        TestHelpers.assertThrows("Should reject additions to the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.add((CharSequence)"white");
            }
        });
        TestHelpers.assertThrows("Should reject bulk additions to the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.addAll((Collection)Lists.newArrayList((Object[])new String[]{"white", "black"}));
            }
        });
        TestHelpers.assertThrows("Should reject removals from the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.remove((Object)"purple");
            }
        });
        TestHelpers.assertThrows("Should reject bulk removals from the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.removeAll((Collection)Lists.newArrayList((Object[])new String[]{"purple", "red"}));
            }
        });
    }

    @Test
    public void testUtf8CharSequenceSetImmutable() {
        ArrayList colors = Lists.newArrayList((Object[])new Utf8[]{new Utf8("orange"), new Utf8("green"), new Utf8("blue"), new Utf8("red"), new Utf8("purple"), new Utf8("red")});
        final CharSequences.ImmutableCharSequenceSet set = new CharSequences.ImmutableCharSequenceSet((Iterable)colors);
        TestHelpers.assertThrows("Should reject additions to the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.add((CharSequence)new Utf8("white"));
            }
        });
        TestHelpers.assertThrows("Should reject bulk additions to the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.addAll((Collection)Lists.newArrayList((Object[])new Utf8[]{new Utf8("white"), new Utf8("black")}));
            }
        });
        TestHelpers.assertThrows("Should reject removals from the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.remove((Object)new Utf8("purple"));
            }
        });
        TestHelpers.assertThrows("Should reject bulk removals from the set", UnsupportedOperationException.class, new Runnable(){

            @Override
            public void run() {
                set.removeAll((Collection)Lists.newArrayList((Object[])new Utf8[]{new Utf8("purple"), new Utf8("red")}));
            }
        });
    }

    @Test
    public void testCharSequenceSetEqualsAndHashCode() {
        ArrayList stringColors = Lists.newArrayList((Object[])new String[]{"orange", "green", "blue", "red", "purple", "red"});
        CharSequences.ImmutableCharSequenceSet strings = new CharSequences.ImmutableCharSequenceSet((Iterable)stringColors);
        ArrayList utf8Colors = Lists.newArrayList((Object[])new Utf8[]{new Utf8("orange"), new Utf8("green"), new Utf8("blue"), new Utf8("red"), new Utf8("purple"), new Utf8("red")});
        CharSequences.ImmutableCharSequenceSet utf8s = new CharSequences.ImmutableCharSequenceSet((Iterable)utf8Colors);
        Assert.assertEquals((String)"Identical String and Utf8 sets should be equal", (Object)strings, (Object)utf8s);
        Assert.assertEquals((String)"Sets equal => hash codes equal", (long)strings.hashCode(), (long)utf8s.hashCode());
    }
}

