/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetExistsException;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.spi.AbstractMetadataProvider;

public class MemoryMetadataProvider
extends AbstractMetadataProvider {
    private final Map<String, Map<String, DatasetDescriptor>> descriptors = Maps.newHashMap();
    private final Configuration conf;
    private final transient FileSystem fs;

    public MemoryMetadataProvider(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        this.conf = conf;
        try {
            this.fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not get default FileSystem", ex);
        }
    }

    public void clear() {
        this.descriptors.clear();
    }

    protected URI newLocation(String name) {
        return new Path(Files.createTempDir().getAbsolutePath()).toUri();
    }

    public DatasetDescriptor load(String namespace, String name) {
        Map<String, DatasetDescriptor> datasets;
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        if (this.descriptors.containsKey(namespace) && (datasets = this.descriptors.get(namespace)).containsKey(name)) {
            return datasets.get(name);
        }
        throw new DatasetNotFoundException("Missing dataset:" + namespace + ":" + name);
    }

    public DatasetDescriptor create(String namespace, String name, DatasetDescriptor descriptor) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        if (this.exists(namespace, name)) {
            throw new DatasetExistsException("Dataset already exists for name:" + name);
        }
        DatasetDescriptor newDescriptor = descriptor.getLocation() == null ? new DatasetDescriptor.Builder(descriptor).location(this.fs.makeQualified(new Path(this.newLocation(name)))).build() : descriptor;
        if (!this.descriptors.containsKey(namespace)) {
            this.descriptors.put(namespace, Maps.newHashMap());
        }
        Map<String, DatasetDescriptor> datasets = this.descriptors.get(namespace);
        datasets.put(name, newDescriptor);
        return newDescriptor;
    }

    public DatasetDescriptor update(String namespace, String name, DatasetDescriptor descriptor) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Descriptor cannot be null");
        if (!this.exists(namespace, name)) {
            throw new DatasetNotFoundException("Missing dataset:" + name);
        }
        this.descriptors.get(namespace).put(name, descriptor);
        return descriptor;
    }

    public boolean delete(String namespace, String name) {
        Map<String, DatasetDescriptor> datasets;
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        if (this.descriptors.containsKey(namespace) && (datasets = this.descriptors.get(namespace)).containsKey(name)) {
            datasets.remove(name);
            if (datasets.isEmpty()) {
                this.descriptors.remove(namespace);
            }
            return true;
        }
        return false;
    }

    public boolean exists(String namespace, String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this.descriptors.containsKey(namespace) && this.descriptors.get(namespace).containsKey(name);
    }

    public Collection<String> namespaces() {
        return this.descriptors.keySet();
    }

    public Collection<String> datasets(String namespace) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Namespace cannot be null");
        if (this.descriptors.containsKey(namespace)) {
            return this.descriptors.get(namespace).keySet();
        }
        return ImmutableList.of();
    }
}

