/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.event;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class StandardEvent
extends SpecificRecordBase
implements SpecificRecord {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"StandardEvent\",\"namespace\":\"org.kitesdk.data.event\",\"doc\":\"A standard event type for logging, based on the paper 'The Unified Logging Infrastructure for Data Analytics at Twitter' by Lee et al, http://vldb.org/pvldb/vol5/p1771_georgelee_vldb2012.pdf\",\"fields\":[{\"name\":\"event_initiator\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Where the event was triggered from in the format {client,server}_{user,app}, e.g. 'client_user'. Required.\"},{\"name\":\"event_name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"A hierarchical name for the event, with parts separated by ':'. Required.\"},{\"name\":\"user_id\",\"type\":\"long\",\"doc\":\"A unique identifier for the user. Required.\"},{\"name\":\"session_id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"A unique identifier for the session. Required.\"},{\"name\":\"ip\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The IP address of the host where the event originated. Required.\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The point in time when the event occurred, represented as the number of milliseconds since January 1, 1970, 00:00:00 GMT. Required.\"}]}");
    private String event_initiator;
    private String event_name;
    private long user_id;
    private String session_id;
    private String ip;
    private long timestamp;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public StandardEvent() {
    }

    public StandardEvent(String event_initiator, String event_name, Long user_id, String session_id, String ip, Long timestamp) {
        this.event_initiator = event_initiator;
        this.event_name = event_name;
        this.user_id = user_id;
        this.session_id = session_id;
        this.ip = ip;
        this.timestamp = timestamp;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.event_initiator;
            }
            case 1: {
                return this.event_name;
            }
            case 2: {
                return this.user_id;
            }
            case 3: {
                return this.session_id;
            }
            case 4: {
                return this.ip;
            }
            case 5: {
                return this.timestamp;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.event_initiator = (String)value$;
                break;
            }
            case 1: {
                this.event_name = (String)value$;
                break;
            }
            case 2: {
                this.user_id = (Long)value$;
                break;
            }
            case 3: {
                this.session_id = (String)value$;
                break;
            }
            case 4: {
                this.ip = (String)value$;
                break;
            }
            case 5: {
                this.timestamp = (Long)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getEventInitiator() {
        return this.event_initiator;
    }

    public String getEventName() {
        return this.event_name;
    }

    public Long getUserId() {
        return this.user_id;
    }

    public String getSessionId() {
        return this.session_id;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(StandardEvent other) {
        return new Builder(other);
    }

    public static class Builder
    extends SpecificRecordBuilderBase<StandardEvent>
    implements RecordBuilder<StandardEvent> {
        private String event_initiator;
        private String event_name;
        private long user_id;
        private String session_id;
        private String ip;
        private long timestamp;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.event_initiator)) {
                this.event_initiator = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.event_initiator);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.event_name)) {
                this.event_name = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.event_name);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.user_id)) {
                this.user_id = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.user_id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.session_id)) {
                this.session_id = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.session_id);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.ip)) {
                this.ip = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.ip);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.timestamp)) {
                this.timestamp = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[5] = true;
            }
        }

        private Builder(StandardEvent other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.event_initiator)) {
                this.event_initiator = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.event_initiator);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.event_name)) {
                this.event_name = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.event_name);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.user_id)) {
                this.user_id = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.user_id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.session_id)) {
                this.session_id = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.session_id);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.ip)) {
                this.ip = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.ip);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.timestamp)) {
                this.timestamp = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[5] = true;
            }
        }

        public String getEventInitiator() {
            return this.event_initiator;
        }

        public Builder setEventInitiator(String value) {
            this.validate(this.fields()[0], value);
            this.event_initiator = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasEventInitiator() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearEventInitiator() {
            this.event_initiator = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getEventName() {
            return this.event_name;
        }

        public Builder setEventName(String value) {
            this.validate(this.fields()[1], value);
            this.event_name = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEventName() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEventName() {
            this.event_name = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getUserId() {
            return this.user_id;
        }

        public Builder setUserId(long value) {
            this.validate(this.fields()[2], value);
            this.user_id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasUserId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearUserId() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSessionId() {
            return this.session_id;
        }

        public Builder setSessionId(String value) {
            this.validate(this.fields()[3], value);
            this.session_id = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSessionId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSessionId() {
            this.session_id = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getIp() {
            return this.ip;
        }

        public Builder setIp(String value) {
            this.validate(this.fields()[4], value);
            this.ip = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasIp() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearIp() {
            this.ip = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(long value) {
            this.validate(this.fields()[5], value);
            this.timestamp = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasTimestamp() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearTimestamp() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public StandardEvent build() {
            try {
                StandardEvent record = new StandardEvent();
                record.event_initiator = this.fieldSetFlags()[0] ? this.event_initiator : (String)this.defaultValue(this.fields()[0]);
                record.event_name = this.fieldSetFlags()[1] ? this.event_name : (String)this.defaultValue(this.fields()[1]);
                record.user_id = this.fieldSetFlags()[2] ? this.user_id : (Long)this.defaultValue(this.fields()[2]);
                record.session_id = this.fieldSetFlags()[3] ? this.session_id : (String)this.defaultValue(this.fields()[3]);
                record.ip = this.fieldSetFlags()[4] ? this.ip : (String)this.defaultValue(this.fields()[4]);
                record.timestamp = this.fieldSetFlags()[5] ? this.timestamp : (Long)this.defaultValue(this.fields()[5]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

