/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import junit.framework.Assert;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.Test;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.ValidationException;

public class TestDescriptorValidation {
    @Test
    public void testAllowedPartitionSchemaCombinations() {
        Assert.assertNotNull((String)"Should return a valid DatasetDescriptor", (Object)new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredString("message").requiredBoolean("bool").requiredLong("timestamp").requiredInt("number").requiredDouble("double").requiredFloat("float").requiredBytes("payload").endRecord()).partitionStrategy(new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").hour("timestamp").minute("timestamp").identity("message", "message_copy").identity("timestamp", "ts").identity("number", "num").hash("message", 48).hash("timestamp", 48).hash("number", 48).hash("payload", 48).hash("float", 48).hash("double", 48).hash("bool", 48).range("number", new int[]{5, 10, 15, 20}).range("message", new String[]{"m", "z", "M", "Z"}).build()).build());
    }

    @Test
    public void testRejectsNullSchema() {
        TestHelpers.assertThrows("Should reject null schema", NullPointerException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema((Schema)null).partitionStrategy(new PartitionStrategy.Builder().hash("array", 48).build()).build();
            }
        });
        TestHelpers.assertThrows("Should reject missing schema", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().partitionStrategy(new PartitionStrategy.Builder().hash("array", 48).build()).build();
            }
        });
    }

    @Test
    public void testAllowsNonRecordSchemaWithoutPartitioning() {
        Assert.assertNotNull((String)"Non-record should produce a valid descriptor", (Object)new DatasetDescriptor.Builder().schema(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT))).build());
    }

    @Test
    public void testRejectsPartitioningWithNonRecordSchema() {
        TestHelpers.assertThrows("Should reject partitioning without a record", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT))).partitionStrategy(new PartitionStrategy.Builder().hash("array", 48).build()).build();
            }
        });
    }

    @Test
    public void testRejectsPartitioningOnMissingField() {
        TestHelpers.assertThrows("Should reject partitioning on a missing field", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredString("field").endRecord()).partitionStrategy(new PartitionStrategy.Builder().hash("array", 48).build()).build();
            }
        });
    }

    @Test
    public void testRejectsSchemaPartitionerTypeMismatch() {
        TestHelpers.assertThrows("Should reject int for long partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredInt("timestamp").endRecord()).partitionStrategy(new PartitionStrategy.Builder().year("timestamp").month("timestamp").day("timestamp").build()).build();
            }
        });
        TestHelpers.assertThrows("Should reject string for int partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredString("username").endRecord()).partitionStrategy(new PartitionStrategy.Builder().range("number", new int[]{5, 10, 15}).build()).build();
            }
        });
        TestHelpers.assertThrows("Should reject int for string partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredInt("number").endRecord()).partitionStrategy(new PartitionStrategy.Builder().range("number", new String[]{"m", "z"}).build()).build();
            }
        });
        TestHelpers.assertThrows("Should reject int for long partitioner", ValidationException.class, new Runnable(){

            @Override
            public void run() {
                new DatasetDescriptor.Builder().schema((Schema)SchemaBuilder.record((String)"Record").fields().requiredInt("timestamp").endRecord()).partitionStrategy(new PartitionStrategy.Builder().year("timestamp").build()).build();
            }
        });
    }
}

