/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.net.URI;
import junit.framework.Assert;
import org.junit.Test;
import org.kitesdk.data.URIBuilder;

public class TestDatasetsURIBuilder {
    @Test
    public void testBuildDatasetUri() {
        URI uri = new URIBuilder("repo:file:/tmp/data", "ns", "test-ds").build();
        Assert.assertEquals((Object)URI.create("dataset:file:/tmp/data/ns/test-ds"), (Object)uri);
    }

    @Test
    public void testBuildViewUri() {
        URI uri = new URIBuilder("repo:file:/tmp/data", "ns", "test-ds").with("username", (Object)"bob").with("lastName", (Object)"Smith").build();
        Assert.assertEquals((Object)URI.create("view:file:/tmp/data/ns/test-ds?username=bob&lastName=Smith"), (Object)uri);
    }

    @Test
    public void testRepoUriHasQueryString() {
        URI uri = new URIBuilder("repo:file:/tmp/data?repoParam=x", "ns", "test-ds").with("username", (Object)"bob").build();
        Assert.assertEquals((Object)URI.create("view:file:/tmp/data/ns/test-ds?repoParam=x&username=bob"), (Object)uri);
    }
}

