/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.generic.GenericRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.MockRepositories;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.TestHelpers;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.AbstractRefinableView;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDatasets {
    private DatasetRepository repo = null;
    private URI repoUri = null;

    @Before
    public void setupMock() {
        this.repo = MockRepositories.newMockRepository();
        this.repoUri = this.repo.getUri();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).getUri();
    }

    @Test
    public void testCreate() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, Object.class)).thenReturn((Object)expected);
        Dataset ds = (Dataset)Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testCreateWithoutType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, GenericRecord.class)).thenReturn((Object)expected);
        Dataset ds = (Dataset)Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateNullType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor, null);
    }

    @Test
    public void testCreateStringUri() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, Object.class)).thenReturn((Object)expected);
        Dataset ds = (Dataset)Datasets.create((String)datasetUri.toString(), (DatasetDescriptor)descriptor, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testCreateStringUriWithoutType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, GenericRecord.class)).thenReturn((Object)expected);
        Dataset ds = (Dataset)Datasets.create((String)datasetUri.toString(), (DatasetDescriptor)descriptor);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testCreateView() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, Object.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        RefinableView view = (RefinableView)Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testCreateViewWithoutType() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, GenericRecord.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        View view = Datasets.create((URI)datasetUri, (DatasetDescriptor)descriptor);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testCreateViewStringUri() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, Object.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        RefinableView view = (RefinableView)Datasets.create((String)datasetUri.toString(), (DatasetDescriptor)descriptor, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testCreateViewStringUriWithoutType() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.create("ns", "test", descriptor, GenericRecord.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        View view = Datasets.create((String)datasetUri.toString(), (DatasetDescriptor)descriptor);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).create("ns", "test", descriptor, GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testLoad() {
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", Object.class)).thenReturn((Object)expected);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Dataset ds = (Dataset)Datasets.load((URI)datasetUri, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testLoadWithoutType() {
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", GenericRecord.class)).thenReturn((Object)expected);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Dataset ds = (Dataset)Datasets.load((URI)datasetUri);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadNullType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Datasets.load((URI)datasetUri, null);
    }

    @Test
    public void testLoadStringUri() {
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", Object.class)).thenReturn((Object)expected);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Dataset ds = (Dataset)Datasets.load((URI)datasetUri, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testLoadStringUriWithoutType() {
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", GenericRecord.class)).thenReturn((Object)expected);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Dataset ds = (Dataset)Datasets.load((URI)datasetUri);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testLoadView() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", Object.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        RefinableView view = (RefinableView)Datasets.load((URI)datasetUri, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testLoadViewWithoutType() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", GenericRecord.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        RefinableView view = (RefinableView)Datasets.load((URI)datasetUri);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testLoadViewStringUri() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", Object.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        RefinableView view = (RefinableView)Datasets.load((String)datasetUri.toString(), Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testLoadViewStringUriWithoutType() throws Exception {
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaUri("resource:schema/user.avsc").build();
        Constraints constraints = new Constraints(descriptor.getSchema(), null).with("username", new Object[]{"user1"}).with("email", new Object[]{"user1@example.com"});
        AbstractDataset ds = (AbstractDataset)Mockito.mock(AbstractDataset.class);
        Mockito.when((Object)this.repo.load("ns", "test", GenericRecord.class)).thenReturn((Object)ds);
        Mockito.when((Object)ds.getDescriptor()).thenReturn((Object)descriptor);
        AbstractRefinableView userAndEmailView = (AbstractRefinableView)Mockito.mock(AbstractRefinableView.class);
        Mockito.when((Object)ds.filter(constraints)).thenReturn((Object)userAndEmailView);
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("username", (Object)"user1").with("email", (Object)"user1@example.com").with("ignoredOption", (Object)"abc").build();
        RefinableView view = (RefinableView)Datasets.load((String)datasetUri.toString());
        ((DatasetRepository)Mockito.verify((Object)this.repo)).load("ns", "test", GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        ((AbstractDataset)Mockito.verify((Object)ds)).getDescriptor();
        ((AbstractDataset)Mockito.verify((Object)ds)).filter(constraints);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ds});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{userAndEmailView});
        Assert.assertEquals((Object)userAndEmailView, (Object)view);
    }

    @Test
    public void testDelete() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Datasets.delete((URI)datasetUri);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("ns", "test");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testDeleteStringUri() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Datasets.delete((String)datasetUri.toString());
        ((DatasetRepository)Mockito.verify((Object)this.repo)).delete("ns", "test");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testDeleteRejectsViewUri() {
        final URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("field", (Object)34).build();
        TestHelpers.assertThrows("Should reject view URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                Datasets.delete((URI)datasetUri);
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testExists() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Mockito.when((Object)this.repo.exists("ns", "test")).thenReturn((Object)true);
        Assert.assertTrue((boolean)Datasets.exists((URI)datasetUri));
        ((DatasetRepository)Mockito.verify((Object)this.repo)).exists("ns", "test");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testExistsStringUri() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Mockito.when((Object)this.repo.exists("ns", "test")).thenReturn((Object)false);
        Assert.assertFalse((boolean)Datasets.exists((String)datasetUri.toString()));
        ((DatasetRepository)Mockito.verify((Object)this.repo)).exists("ns", "test");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testExistsRejectsViewUri() {
        final URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("field", (Object)34).build();
        TestHelpers.assertThrows("Should reject view URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                Datasets.exists((URI)datasetUri);
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testUpdate() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.update("ns", "test", descriptor, Object.class)).thenReturn((Object)expected);
        Dataset ds = Datasets.update((URI)datasetUri, (DatasetDescriptor)descriptor, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update("ns", "test", descriptor, Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testUpdateWithoutType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.update("ns", "test", descriptor, GenericRecord.class)).thenReturn((Object)expected);
        Dataset ds = Datasets.update((URI)datasetUri, (DatasetDescriptor)descriptor);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update("ns", "test", descriptor, GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateNullType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Datasets.update((URI)datasetUri, (DatasetDescriptor)descriptor, null);
    }

    @Test
    public void testUpdateStringUri() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.update("ns", "test", descriptor, Object.class)).thenReturn((Object)expected);
        Dataset ds = Datasets.update((String)datasetUri.toString(), (DatasetDescriptor)descriptor, Object.class);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update("ns", "test", descriptor, Object.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testUpdateStringUriWithoutType() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        Dataset expected = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)this.repo.update("ns", "test", descriptor, GenericRecord.class)).thenReturn((Object)expected);
        Dataset ds = Datasets.update((String)datasetUri.toString(), (DatasetDescriptor)descriptor);
        ((DatasetRepository)Mockito.verify((Object)this.repo)).update("ns", "test", descriptor, GenericRecord.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{expected});
        Assert.assertEquals((Object)expected, (Object)ds);
    }

    @Test
    public void testUpdateRejectsViewUri() {
        final URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("field", (Object)34).build();
        final DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schemaLiteral("\"string\"").build();
        TestHelpers.assertThrows("Should reject view URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                Datasets.update((URI)datasetUri, (DatasetDescriptor)descriptor, Object.class);
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testListRejectsDatasetUri() {
        TestHelpers.assertThrows("Should reject dataset URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                Datasets.list((URI)new URIBuilder(TestDatasets.this.repoUri, "ns", "test").build());
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testListRejectsViewUri() {
        TestHelpers.assertThrows("Should reject dataset URI", IllegalArgumentException.class, new Runnable(){

            @Override
            public void run() {
                Datasets.list((URI)new URIBuilder(TestDatasets.this.repoUri, "ns", "test").with("field", (Object)34).build());
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testListRepoUri() {
        Mockito.when((Object)this.repo.namespaces()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"ns"}));
        Mockito.when((Object)this.repo.datasets("ns")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}));
        ArrayList expected = Lists.newArrayList((Object[])new URI[]{new URIBuilder(this.repoUri, "ns", "a").build(), new URIBuilder(this.repoUri, "ns", "b").build(), new URIBuilder(this.repoUri, "ns", "c").build()});
        Collection datasetUris = Datasets.list((URI)this.repoUri);
        ((DatasetRepository)Mockito.verify((Object)this.repo, (VerificationMode)Mockito.times((int)2))).getUri();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).namespaces();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).datasets("ns");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Assert.assertEquals((Object)expected, (Object)datasetUris);
    }

    @Test
    public void testListStringRepoUri() {
        Mockito.when((Object)this.repo.namespaces()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"ns"}));
        Mockito.when((Object)this.repo.datasets("ns")).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}));
        ArrayList expected = Lists.newArrayList((Object[])new URI[]{new URIBuilder(this.repoUri, "ns", "a").build(), new URIBuilder(this.repoUri, "ns", "b").build(), new URIBuilder(this.repoUri, "ns", "c").build()});
        Collection datasetUris = Datasets.list((String)this.repoUri.toString());
        ((DatasetRepository)Mockito.verify((Object)this.repo, (VerificationMode)Mockito.times((int)2))).getUri();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).namespaces();
        ((DatasetRepository)Mockito.verify((Object)this.repo)).datasets("ns");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
        Assert.assertEquals((Object)expected, (Object)datasetUris);
    }

    @Test
    public void testRepositoryFor() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Assert.assertEquals((Object)this.repo, (Object)DatasetRepositories.repositoryFor((URI)datasetUri));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testRepositoryForStringUri() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").build();
        Assert.assertEquals((Object)this.repo, (Object)DatasetRepositories.repositoryFor((String)datasetUri.toString()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testRepositoryForView() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("field", (Object)34).build();
        Assert.assertEquals((Object)this.repo, (Object)DatasetRepositories.repositoryFor((URI)datasetUri));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }

    @Test
    public void testRepositoryForViewStringUri() {
        URI datasetUri = new URIBuilder(this.repoUri, "ns", "test").with("field", (Object)34).build();
        Assert.assertEquals((Object)this.repo, (Object)DatasetRepositories.repositoryFor((String)datasetUri.toString()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.repo});
    }
}

