/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.spi.InitializeAccessor;
import org.kitesdk.data.spi.filesystem.DatasetTestUtilities;

public abstract class TestDatasetReaders<R> {
    private DatasetReader<R> reader = null;
    private int totalRecords = 0;
    private DatasetTestUtilities.RecordValidator<R> validator = null;

    public abstract DatasetReader<R> newReader() throws IOException;

    public abstract int getTotalRecords();

    public abstract DatasetTestUtilities.RecordValidator<R> getValidator();

    @Before
    public void setupReader() throws IOException {
        this.reader = this.newReader();
        this.totalRecords = this.getTotalRecords();
        this.validator = this.getValidator();
    }

    @Test
    public void testBasicBehavior() throws IOException {
        DatasetTestUtilities.checkReaderBehavior(this.reader, this.totalRecords, this.validator);
    }

    @Test
    public void testDoubleCloseIgnored() throws IOException {
        DatasetTestUtilities.checkReaderBehavior(this.reader, this.totalRecords, this.validator);
        this.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testHasNextOnClosedWriterFails() throws IOException {
        DatasetTestUtilities.checkReaderBehavior(this.reader, this.totalRecords, this.validator);
        try {
            this.reader.hasNext();
        }
        finally {
            this.reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testNextOnClosedWriterFails() throws IOException {
        DatasetTestUtilities.checkReaderBehavior(this.reader, this.totalRecords, this.validator);
        try {
            this.reader.next();
        }
        finally {
            this.reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemove() throws IOException {
        try {
            try {
                if (!this.reader.isOpen() && this.reader instanceof InitializeAccessor) {
                    ((InitializeAccessor)this.reader).initialize();
                }
            }
            catch (Throwable t) {
                Assert.fail((String)("Reader failed in open: " + t.getClass().getName()));
            }
            Assert.assertTrue((String)"Reader is not open after open()", (boolean)this.reader.isOpen());
            try {
                this.reader.remove();
                Assert.fail((String)"Remove before iteration succeeded");
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            DatasetTestUtilities.checkReaderIteration(this.reader, this.totalRecords, this.validator);
            try {
                this.reader.remove();
                Assert.fail((String)"Remove after last hasNext() succeeded");
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            this.reader.close();
        }
    }
}

