/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.kitesdk.compat.DynMethods;

public class MiniDFSTest {
    private static Configuration conf = null;
    private static MiniDFSCluster cluster = null;
    private static FileSystem dfs = null;
    private static FileSystem lfs = null;
    private static DynMethods.UnboundMethod getFS = new DynMethods.Builder("getFileSystem").impl(MiniDFSCluster.class, new Class[0]).build();

    protected static Configuration getConfiguration() {
        return conf;
    }

    protected static FileSystem getDFS() {
        return dfs;
    }

    protected static FileSystem getFS() {
        return lfs;
    }

    @BeforeClass
    public static void setupFS() throws IOException {
        if (cluster == null) {
            Configuration c = new Configuration();
            c.setBoolean("dfs.webhdfs.enabled", true);
            cluster = new MiniDFSCluster(c, 1, true, null);
            dfs = (FileSystem)getFS.invoke((Object)cluster, new Object[0]);
            conf = new Configuration(dfs.getConf());
            lfs = FileSystem.getLocal((Configuration)conf);
        }
    }

    @AfterClass
    public static void teardownFS() throws IOException {
        dfs = null;
        lfs = null;
        conf = null;
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }
}

