/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.net.URI;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.RefinableView;
import org.kitesdk.data.View;
import org.kitesdk.data.impl.Accessor;
import org.kitesdk.data.spi.Conversions;
import org.kitesdk.data.spi.FieldPartitioner;
import org.kitesdk.data.spi.SchemaUtil;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.base.Splitter;
import org.kitesdk.shaded.com.google.common.collect.Iterables;

public class FileSystemDatasets {
    private static final Splitter PATH_SPLITTER = Splitter.on('/');
    private static final Splitter KV_SPLITTER = Splitter.on('=').limit(2);

    public static <E> View<E> viewForUri(Dataset<E> dataset, URI uri) {
        Preconditions.checkArgument(dataset instanceof FileSystemDataset, "Not a file system dataset: " + dataset);
        DatasetDescriptor descriptor = dataset.getDescriptor();
        String s1 = descriptor.getLocation().getScheme();
        String s2 = uri.getScheme();
        Preconditions.checkArgument(s1 == null || s2 == null || s1.equals(s2), "%s is not contained in %s", uri, descriptor.getLocation());
        URI location = URI.create(descriptor.getLocation().getPath());
        URI relative = location.relativize(URI.create(uri.getPath()));
        if (relative.toString().isEmpty()) {
            return dataset;
        }
        Preconditions.checkArgument(!relative.getPath().startsWith("/"), "%s is not contained in %s", uri, location);
        Preconditions.checkArgument(descriptor.isPartitioned(), "Dataset is not partitioned");
        Schema schema = descriptor.getSchema();
        PartitionStrategy strategy = descriptor.getPartitionStrategy();
        RefinableView<E> view = dataset;
        Iterator<String> parts = PATH_SPLITTER.split(relative.toString()).iterator();
        for (FieldPartitioner fp : Accessor.getDefault().getFieldPartitioners(strategy)) {
            if (!parts.hasNext()) break;
            String value = Iterables.getLast(KV_SPLITTER.split(parts.next()));
            Schema fieldSchema = SchemaUtil.fieldSchema(schema, strategy, fp.getName());
            view = view.with(fp.getName(), Conversions.convert((Object)value, fieldSchema));
        }
        return view;
    }

    public static <E> View<E> viewForUri(Dataset<E> dataset, String uri) {
        return FileSystemDatasets.viewForUri(dataset, URI.create(uri));
    }

    public static <E> View<E> viewForPath(Dataset<E> dataset, Path path) {
        return FileSystemDatasets.viewForUri(dataset, path.toUri());
    }
}

