/**
 * Copyright 2013 Cloudera Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kitesdk.data;

/**
 * <p>
 * Exception thrown to indicate that there is a problem
 * finding a given type.
 * <p>
 * @since 0.15.0
 */
public class TypeNotFoundException extends DatasetException {

  public TypeNotFoundException(String message) {
    super(message);
  }

  public TypeNotFoundException(String message, Throwable cause) {
    super(message, cause);
  }

  public TypeNotFoundException(Throwable cause) {
    super(cause);
  }
}
