/*
 * Copyright 2013 Cloudera Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kitesdk.data;

/**
 * {@link DatasetException} thrown when an implementation-specific step fails
 * and prevents a dataset operation from completing successfully.
 *
 * @since 0.17.0
 */
public class DatasetOperationException extends DatasetException {
  public DatasetOperationException(String message, Object... args) {
    super(format(message, args));
  }

  public DatasetOperationException(Throwable t, String message, Object... args) {
    super(format(message, args), t);
  }

  public DatasetOperationException(String message, Throwable t) {
    super(message, t);
  }
}
