/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.builtin;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.workitem.builtin.AbstractExceptionHandlingTaskHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.WorkItemHandlerRuntimeException;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;

public class SignallingTaskHandlerDecorator
extends AbstractExceptionHandlingTaskHandler {
    private final String eventType;
    private String workItemExceptionParameterName = "jbpm.workitem.exception";
    private final Map<String, Integer> processInstanceExceptionMap = new HashMap<String, Integer>();
    private int exceptionCountLimit = 1;

    public SignallingTaskHandlerDecorator(Class<? extends KogitoWorkItemHandler> originalTaskHandlerClass, String eventType) {
        super(originalTaskHandlerClass);
        this.eventType = eventType;
    }

    public SignallingTaskHandlerDecorator(KogitoWorkItemHandler originalTaskHandler, String eventType) {
        super(originalTaskHandler);
        this.eventType = eventType;
    }

    public SignallingTaskHandlerDecorator(Class<? extends KogitoWorkItemHandler> originalTaskHandlerClass, String eventType, int exceptionCountLimit) {
        super(originalTaskHandlerClass);
        this.eventType = eventType;
        this.exceptionCountLimit = exceptionCountLimit;
    }

    public SignallingTaskHandlerDecorator(KogitoWorkItemHandler originalTaskHandler, String eventType, int exceptionCountLimit) {
        super(originalTaskHandler);
        this.eventType = eventType;
        this.exceptionCountLimit = exceptionCountLimit;
    }

    public void setWorkItemExceptionParameterName(String parameterName) {
        this.workItemExceptionParameterName = parameterName;
    }

    public String getWorkItemExceptionParameterName() {
        return this.workItemExceptionParameterName;
    }

    @Override
    public void handleException(KogitoWorkItemManager manager, KogitoWorkItemHandler originalTaskHandler, KogitoWorkItem workItem, WorkItemTransition transition, Throwable cause) {
        switch (transition.id()) {
            case "activate": {
                if (this.getAndIncreaseExceptionCount(workItem.getProcessInstanceStringId()) < this.exceptionCountLimit) {
                    workItem.getParameters().put(this.workItemExceptionParameterName, cause);
                    ((InternalKogitoWorkItemManager)manager).signalEvent(this.eventType, workItem, workItem.getProcessInstanceStringId());
                    break;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new WorkItemHandlerRuntimeException(cause, "Signalling process instance " + workItem.getProcessInstanceId() + " with '" + this.eventType + "' resulted this exception.");
            }
            case "abort": {
                if (this.getAndIncreaseExceptionCount(workItem.getProcessInstanceStringId()) >= this.exceptionCountLimit) break;
                workItem.getParameters().put(this.workItemExceptionParameterName, cause);
                ((InternalKogitoWorkItemManager)manager).signalEvent(this.eventType, workItem, workItem.getProcessInstanceId());
            }
        }
    }

    private int getAndIncreaseExceptionCount(String processInstanceId) {
        Integer count = this.processInstanceExceptionMap.get(processInstanceId);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.processInstanceExceptionMap.put(processInstanceId, count);
        return count - 1;
    }

    public void setExceptionCountLimit(int limit) {
        this.exceptionCountLimit = limit;
    }

    public void clear() {
        this.processInstanceExceptionMap.clear();
    }
}

