/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.builtin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemHandlerRuntimeException;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.impl.DefaultKogitoWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskHandler
extends DefaultKogitoWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTaskHandler.class);
    private String resultVarName;

    public ServiceTaskHandler() {
        this("Result");
    }

    public ServiceTaskHandler(String resultVarName) {
        this.resultVarName = resultVarName;
    }

    @Override
    public Optional<WorkItemTransition> activateWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workItem, WorkItemTransition transition) {
        String service = (String)workItem.getParameter("Interface");
        String interfaceImplementationRef = (String)workItem.getParameter("interfaceImplementationRef");
        String operation = (String)workItem.getParameter("Operation");
        String parameterType = (String)workItem.getParameter("ParameterType");
        Object parameter = workItem.getParameter("Parameter");
        String[] services = new String[]{service, interfaceImplementationRef};
        Class<?> c = null;
        for (String serv : services) {
            try {
                c = Class.forName(serv);
                break;
            }
            catch (ClassNotFoundException cnfe) {
                if (serv.compareTo(services[services.length - 1]) != 0) continue;
                this.handleException(cnfe, service, interfaceImplementationRef, operation, parameterType, parameter);
            }
        }
        try {
            Object instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class[] classes = null;
            Object[] params = null;
            if (parameterType != null) {
                classes = new Class[]{Class.forName(parameterType)};
                params = new Object[]{parameter};
            }
            Method method = c.getMethod(operation, classes);
            Object result = method.invoke(instance, params);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(this.resultVarName, result);
            return Optional.of(this.workItemLifeCycle.newTransition("complete", workItem.getPhaseStatus(), results, new Policy[0]));
        }
        catch (Exception cnfe) {
            this.handleException(cnfe, service, interfaceImplementationRef, operation, parameterType, parameter);
            return Optional.empty();
        }
    }

    private void handleException(Throwable cause, String service, String interfaceImplementationRef, String operation, String paramType, Object param) {
        logger.debug("Handling exception {} inside service {} or {} and operation {} with param type {} and value {}", new Object[]{cause.getMessage(), service, interfaceImplementationRef, operation, paramType, param});
        Throwable realCause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("Interface", service);
        info.put("InterfaceImplementationRef", interfaceImplementationRef);
        info.put("Operation", operation);
        info.put("ParameterType", paramType);
        info.put("Parameter", param);
        info.put("workItemHandlerType", this.getClass().getSimpleName());
        WorkItemHandlerRuntimeException wihRe = new WorkItemHandlerRuntimeException(realCause, info);
        wihRe.setStackTrace(realCause.getStackTrace());
        throw wihRe;
    }
}

