/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn.config;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.kogito.decision.DecisionConfig;
import org.kie.kogito.decision.DecisionEventListenerConfig;
import org.kie.kogito.dmn.config.CachedDecisionEventListenerConfig;

public abstract class AbstractDecisionConfig
implements DecisionConfig {
    private final DecisionEventListenerConfig decisionEventListener;

    protected AbstractDecisionConfig(Iterable<DecisionEventListenerConfig> decisionEventListenerConfigs, Iterable<DMNRuntimeEventListener> dmnRuntimeEventListeners) {
        this.decisionEventListener = this.extractDecisionEventListenerConfig(decisionEventListenerConfigs, dmnRuntimeEventListeners);
    }

    @Override
    public DecisionEventListenerConfig decisionEventListeners() {
        return this.decisionEventListener;
    }

    private DecisionEventListenerConfig extractDecisionEventListenerConfig(Iterable<DecisionEventListenerConfig> decisionEventListenerConfigs, Iterable<DMNRuntimeEventListener> dmnRuntimeEventListeners) {
        return this.mergeDecisionEventListenerConfig(StreamSupport.stream(decisionEventListenerConfigs.spliterator(), false).collect(Collectors.toList()), StreamSupport.stream(dmnRuntimeEventListeners.spliterator(), false).collect(Collectors.toList()));
    }

    private DecisionEventListenerConfig mergeDecisionEventListenerConfig(Collection<DecisionEventListenerConfig> decisionEventListenerConfigs, Collection<DMNRuntimeEventListener> dmnRuntimeEventListeners) {
        return new CachedDecisionEventListenerConfig(AbstractDecisionConfig.merge(decisionEventListenerConfigs, DecisionEventListenerConfig::listeners, dmnRuntimeEventListeners));
    }

    private static <C, L> List<L> merge(Collection<C> configs, Function<C, Collection<L>> configToListeners, Collection<L> listeners) {
        return Stream.concat(configs.stream().flatMap(c -> ((Collection)configToListeners.apply(c)).stream()), listeners.stream()).collect(Collectors.toList());
    }
}

