/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.dmn;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.io.ReaderResource;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNOption;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.internal.utils.DMNEvaluationUtils;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.kogito.dmn.DMNKogitoCallbacks;
import org.kie.kogito.dmn.rest.KogitoDMNResult;

public class DMNKogito {
    private DMNKogito() {
    }

    public static DMNRuntime createGenericDMNRuntime(Set<DMNProfile> customDMNProfiles, boolean enableRuntimeTypeCheckOption, Reader ... readers) {
        DMNKogitoCallbacks.beforeCreateGenericDMNRuntime(readers);
        List resources = Stream.of(readers).map(ReaderResource::new).collect(Collectors.toList());
        EvalHelper.clearGenericAccessorCache();
        DMNRuntimeBuilder dmnRuntimeBuilder = DMNRuntimeBuilder.fromDefaults();
        customDMNProfiles.forEach(arg_0 -> ((DMNRuntimeBuilder)dmnRuntimeBuilder).addProfile(arg_0));
        DMNRuntime dmnRuntime = (DMNRuntime)dmnRuntimeBuilder.buildConfiguration().fromResources(resources).getOrElseThrow(e -> new RuntimeException("Error initializing DMNRuntime", (Throwable)e));
        RuntimeTypeCheckOption runtimeTypeCheckOption = new RuntimeTypeCheckOption(enableRuntimeTypeCheckOption);
        ((DMNRuntimeImpl)dmnRuntime).setOption((DMNOption)runtimeTypeCheckOption);
        DMNKogitoCallbacks.afterCreateGenericDMNRuntime(dmnRuntime);
        return dmnRuntime;
    }

    public static DMNModel modelByName(DMNRuntime dmnRuntime, String modelName) {
        List modelsWithName = dmnRuntime.getModels().stream().filter(m -> modelName.equals(m.getName())).collect(Collectors.toList());
        if (modelsWithName.size() == 1) {
            return (DMNModel)modelsWithName.get(0);
        }
        throw new RuntimeException("Multiple model with the same name: " + modelName);
    }

    public static KogitoDMNResult evaluate(DMNRuntime dmnRuntime, String modelName, Map<String, Object> dmnContext) {
        return DMNKogito.evaluate(dmnRuntime, DMNKogito.modelByName(dmnRuntime, modelName).getNamespace(), modelName, dmnContext);
    }

    public static KogitoDMNResult evaluate(DMNRuntime dmnRuntime, String modelNamespace, String modelName, Map<String, Object> dmnContext) {
        DMNEvaluationUtils.DMNEvaluationResult evaluationResult = DMNEvaluationUtils.evaluate((DMNRuntime)dmnRuntime, (String)modelNamespace, (String)modelName, dmnContext, null, null, null);
        return new KogitoDMNResult(modelNamespace, modelName, evaluationResult.result);
    }
}

