/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.management.RestJobsService;
import org.kie.kogito.jobs.service.api.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringRestJobsService
extends RestJobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringRestJobsService.class);
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;

    @Autowired
    public SpringRestJobsService(@Value(value="${kogito.jobs-service.url}") String jobServiceUrl, @Value(value="${kogito.service.url}") String callbackEndpoint, @Autowired(required=false) RestTemplate restTemplate, @Autowired ObjectMapper objectMapper) {
        super(jobServiceUrl, callbackEndpoint, objectMapper);
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    SpringRestJobsService() {
        this(null, null, null, null);
    }

    @PostConstruct
    public void initialize() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            LOGGER.debug("No RestTemplate found, creating a default one");
        }
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        throw new UnsupportedOperationException("Scheduling for process jobs is not yet implemented");
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        String callback = this.getCallbackEndpoint(description);
        LOGGER.debug("Job to be scheduled {} with callback URL {}", (Object)description, (Object)callback);
        Job job = this.buildJob(description, callback);
        HttpEntity<String> request = this.buildJobRequest(job);
        ResponseEntity result = this.restTemplate.postForEntity(this.getJobsServiceUri(), request, String.class);
        if (result.getStatusCode().isSameCodeAs(HttpStatusCode.valueOf((int)200))) {
            LOGGER.debug("Creating of the job {} done with status code {} ", (Object)job, (Object)result.getStatusCode());
        }
        return job.getId();
    }

    public boolean cancelJob(String id) {
        try {
            this.restTemplate.delete(this.getJobsServiceUri() + "/{id}", new Object[]{id});
            return true;
        }
        catch (RestClientException e) {
            LOGGER.debug("Exception thrown during canceling of job {}", (Object)id, (Object)e);
            return false;
        }
    }

    private HttpEntity<String> buildJobRequest(Job job) {
        String json;
        try {
            json = this.objectMapper.writeValueAsString((Object)job);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("It was not possible to create the http request for the job: " + job, e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return new HttpEntity((Object)json, (MultiValueMap)headers);
    }
}

